/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.cdi.seam.config.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IType;
import org.jboss.tools.cdi.core.extension.AbstractDefinitionContextExtension;
import org.jboss.tools.cdi.internal.core.impl.definition.AbstractTypeDefinition;
import org.jboss.tools.cdi.internal.core.impl.definition.AnnotationDefinition;
import org.jboss.tools.cdi.internal.core.impl.definition.DefinitionContext;
import org.jboss.tools.cdi.internal.core.impl.definition.TypeDefinition;
import org.jboss.tools.cdi.seam.config.core.definition.SeamBeansDefinition;

public class ConfigDefinitionContext
extends AbstractDefinitionContextExtension {
    private Map<IPath, SeamBeansDefinition> beanXMLs = new HashMap<IPath, SeamBeansDefinition>();
    private Map<IPath, SeamBeansDefinition> seambeanXMLs = new HashMap<IPath, SeamBeansDefinition>();
    private Map<String, AnnotationDefinition> annotations = new HashMap<String, AnnotationDefinition>();
    private Map<String, IPath> possibleTypes = new HashMap<String, IPath>();

    public ConfigDefinitionContext getWorkingCopy() {
        return (ConfigDefinitionContext)super.getWorkingCopy();
    }

    protected ConfigDefinitionContext copy(boolean clean) {
        ConfigDefinitionContext copy = new ConfigDefinitionContext();
        copy.root = this.root;
        if (!clean) {
            copy.beanXMLs.putAll(this.beanXMLs);
            copy.seambeanXMLs.putAll(this.seambeanXMLs);
            copy.annotations.putAll(this.annotations);
            copy.initPossibleTypes();
        }
        return copy;
    }

    protected void doApplyWorkingCopy() {
        String[] as;
        ConfigDefinitionContext copy = (ConfigDefinitionContext)this.workingCopy;
        this.beanXMLs = copy.beanXMLs;
        this.seambeanXMLs = copy.seambeanXMLs;
        String[] stringArray = as = this.annotations.keySet().toArray(new String[0]);
        int n = as.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (!copy.annotations.containsKey(s)) {
                AnnotationDefinition d = this.annotations.get(s);
                IType type = d.getType();
                this.root.clean(type.getFullyQualifiedName());
                this.root.getAnnotationKind(type);
            }
            ++n2;
        }
        this.annotations = copy.annotations;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clean() {
        Map<Object, SeamBeansDefinition> map = this.beanXMLs;
        synchronized (map) {
            this.beanXMLs.clear();
        }
        map = this.seambeanXMLs;
        synchronized (map) {
            this.seambeanXMLs.clear();
        }
        map = this.annotations;
        synchronized (map) {
            this.annotations.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clean(IPath path) {
        SeamBeansDefinition def;
        Map<IPath, SeamBeansDefinition> map = this.beanXMLs;
        synchronized (map) {
            def = this.beanXMLs.remove(path);
            if (def != null) {
                def.clean(this);
            }
        }
        map = this.seambeanXMLs;
        synchronized (map) {
            def = this.seambeanXMLs.remove(path);
            if (def != null) {
                def.clean(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clean(String typeName) {
        Map<String, AnnotationDefinition> map = this.annotations;
        synchronized (map) {
            this.annotations.remove(typeName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBeanXML(IPath path, SeamBeansDefinition def) {
        Map<IPath, SeamBeansDefinition> map = this.beanXMLs;
        synchronized (map) {
            this.beanXMLs.put(path, def);
        }
        this.root.addToParents(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSeamBeanXML(IPath path, SeamBeansDefinition def) {
        Map<IPath, SeamBeansDefinition> map = this.seambeanXMLs;
        synchronized (map) {
            this.seambeanXMLs.put(path, def);
        }
        this.root.addToParents(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<SeamBeansDefinition> getSeamBeansDefinitions() {
        HashSet<SeamBeansDefinition> result = new HashSet<SeamBeansDefinition>();
        Map<IPath, SeamBeansDefinition> map = this.beanXMLs;
        synchronized (map) {
            result.addAll(this.beanXMLs.values());
        }
        map = this.seambeanXMLs;
        synchronized (map) {
            result.addAll(this.seambeanXMLs.values());
        }
        return result;
    }

    public Set<IPath> getAllPaths() {
        HashSet<IPath> result = new HashSet<IPath>();
        result.addAll(this.beanXMLs.keySet());
        result.addAll(this.seambeanXMLs.keySet());
        return result;
    }

    public SeamBeansDefinition getDefinition(IPath path) {
        if (this.beanXMLs.containsKey(path)) {
            return this.beanXMLs.get(path);
        }
        if (this.seambeanXMLs.containsKey(path)) {
            return this.seambeanXMLs.get(path);
        }
        return null;
    }

    public void addAnnotation(String typeName, AnnotationDefinition def) {
        IPath path;
        this.annotations.put(typeName, def);
        Object object = def.getResource() != null ? def.getResource().getFullPath() : (path = def.getType() != null ? def.getType().getPath() : null);
        if (path != null) {
            ((DefinitionContext)this.root).addType(path, typeName, (AbstractTypeDefinition)def);
        }
    }

    public List<TypeDefinition> getTypeDefinitions() {
        ArrayList<TypeDefinition> result = new ArrayList<TypeDefinition>();
        for (SeamBeansDefinition def : this.beanXMLs.values()) {
            result.addAll(def.getTypeDefinitions());
        }
        for (SeamBeansDefinition def : this.seambeanXMLs.values()) {
            result.addAll(def.getTypeDefinitions());
        }
        return result;
    }

    void initPossibleTypes() {
        Set<IPath> ps = this.getAllPaths();
        for (IPath p : ps) {
            SeamBeansDefinition d = this.getDefinition(p);
            Set<String> ns = d.getPossibleTypeNames();
            for (String type : ns) {
                this.possibleTypes.put(type, p);
            }
        }
    }

    public IPath getPathForPossibleType(String type) {
        return this.possibleTypes.get(type);
    }
}

