/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.thym.android.ui;

import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.thym.android.core.adt.AndroidDevice;
import org.eclipse.thym.android.core.adt.AndroidSDKManager;
import org.eclipse.thym.core.HybridProject;
import org.eclipse.thym.ui.launch.HybridProjectLaunchShortcut;
import org.eclipse.ui.PlatformUI;

public class AndroidDeviceLaunchShortcut
extends HybridProjectLaunchShortcut {
    private AndroidDevice deviceToRun;

    protected boolean validateBuildToolsReady() throws CoreException {
        AndroidSDKManager sdkManager = AndroidSDKManager.getManager();
        List targets = sdkManager.listTargets();
        if (targets == null || targets.isEmpty()) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.thym.android.ui", "No targets to build against"));
        }
        return true;
    }

    protected boolean shouldProceedWithLaunch(HybridProject project) {
        if (this.getDeviceToRun() == null) {
            MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"No Device attached", (String)"No developer enabled android device is attached to this computer please attach your device and try again.");
            return false;
        }
        return super.shouldProceedWithLaunch(project);
    }

    protected void updateLaunchConfiguration(ILaunchConfigurationWorkingCopy wc) {
        wc.setAttribute("org.eclipse.thym.android.core.ATTR_IS_DEVICE_LAUNCH", true);
        AndroidDevice device = this.getDeviceToRun();
        if (device != null) {
            wc.setAttribute("org.eclipse.thym.android.core.ATTR_DEVICE_SERIAL", device.getSerialNumber());
        }
    }

    protected boolean isCorrectLaunchConfiguration(IProject project, ILaunchConfiguration config) throws CoreException {
        if (config.getAttribute("org.eclipse.thym.android.core.ATTR_IS_DEVICE_LAUNCH", false)) {
            return super.isCorrectLaunchConfiguration(project, config);
        }
        return false;
    }

    protected String getLaunchConfigurationTypeID() {
        return "org.eclipse.thym.android.core.AndroidLaunchConfigurationType";
    }

    private AndroidDevice getDeviceToRun() {
        if (this.deviceToRun == null) {
            try {
                AndroidSDKManager sdkManager = AndroidSDKManager.getManager();
                List devices = sdkManager.listDevices();
                for (AndroidDevice androidDevice : devices) {
                    if (androidDevice.isEmulator()) continue;
                    this.deviceToRun = androidDevice;
                    break;
                }
            }
            catch (CoreException coreException) {
                return null;
            }
        }
        return this.deviceToRun;
    }

    protected String getLaunchConfigurationNamePrefix(IProject project) {
        return String.valueOf(project.getName()) + " (Android Device)";
    }
}

