/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate.jpt.core.internal.context.java;

import java.util.LinkedList;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;

public class JpaUtil {
    public static Boolean isTypeImplementsInterface(IJavaProject javaProject, IType type, String interfaceName) throws JavaModelException {
        if (type == null) {
            return null;
        }
        boolean hasInconsistency = false;
        String[] interfaces = type.getSuperInterfaceNames();
        LinkedList<String> resolvedInterfaceNames = new LinkedList<String>();
        int i = 0;
        while (i < interfaces.length) {
            if (interfaceName.equals(interfaces[i])) {
                return true;
            }
            String[][] resolvedInterfaces = type.resolveType(interfaces[i]);
            if (resolvedInterfaces != null) {
                String[][] stringArray = resolvedInterfaces;
                int n = resolvedInterfaces.length;
                int n2 = 0;
                while (n2 < n) {
                    String[] parts = stringArray[n2];
                    String fullName = parts[0].length() > 0 ? String.valueOf(parts[0]) + '.' + parts[1] : parts[1];
                    resolvedInterfaceNames.add(fullName);
                    if (interfaceName.equals(fullName)) {
                        return true;
                    }
                    ++n2;
                }
            } else {
                hasInconsistency = true;
            }
            ++i;
        }
        if (type.getSuperclassName() != null) {
            String[][] resolvedSuperClass = type.resolveType(type.getSuperclassName());
            if (resolvedSuperClass != null) {
                String fullName;
                String string = fullName = resolvedSuperClass[0][0].length() > 0 ? String.valueOf(resolvedSuperClass[0][0]) + '.' + resolvedSuperClass[0][1] : resolvedSuperClass[0][1];
                if (interfaceName.equals(fullName)) {
                    return true;
                }
                IType parentType = javaProject.findType(fullName);
                Boolean recursiveResult = JpaUtil.isTypeImplementsInterface(javaProject, parentType, interfaceName);
                if (recursiveResult == null) {
                    hasInconsistency = true;
                } else if (recursiveResult.booleanValue()) {
                    return true;
                }
            } else {
                hasInconsistency = true;
            }
        }
        for (String interface_ : resolvedInterfaceNames) {
            IType parentInterface = javaProject.findType(interface_);
            Boolean recursiveResult = JpaUtil.isTypeImplementsInterface(javaProject, parentInterface, interfaceName);
            if (recursiveResult == null) {
                hasInconsistency = true;
                continue;
            }
            if (!recursiveResult.booleanValue()) continue;
            return true;
        }
        return hasInconsistency ? null : Boolean.valueOf(false);
    }

    public static Boolean isTypeImplementsOneOfInterfaces(IJavaProject javaProject, IType type, String ... interfacesName) throws JavaModelException {
        boolean hasInconsistency = false;
        String[] stringArray = interfacesName;
        int n = interfacesName.length;
        int n2 = 0;
        while (n2 < n) {
            String interfaceName = stringArray[n2];
            Boolean implementsThis = JpaUtil.isTypeImplementsInterface(javaProject, type, interfaceName);
            if (implementsThis == null) {
                hasInconsistency = true;
            } else if (implementsThis.booleanValue()) {
                return true;
            }
            ++n2;
        }
        return hasInconsistency ? null : Boolean.valueOf(false);
    }
}

