/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate.jpt.core.internal.context.java;

import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jpt.common.core.internal.utility.EmptyTextRange;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.common.utility.iterable.ListIterable;
import org.eclipse.jpt.jpa.core.context.JpaContextModel;
import org.eclipse.jpt.jpa.core.context.java.JavaGeneratorContainer;
import org.eclipse.jpt.jpa.core.context.orm.EntityMappings;
import org.eclipse.jpt.jpa.core.internal.context.ContextContainerTools;
import org.eclipse.jpt.jpa.core.internal.context.java.AbstractJavaDatabaseGenerator;
import org.eclipse.jpt.jpa.core.resource.java.DatabaseGeneratorAnnotation;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.jboss.tools.hibernate.jpt.core.internal.HibernateAbstractJpaFactory;
import org.jboss.tools.hibernate.jpt.core.internal.context.GenericGenerator;
import org.jboss.tools.hibernate.jpt.core.internal.context.Messages;
import org.jboss.tools.hibernate.jpt.core.internal.context.Parameter;
import org.jboss.tools.hibernate.jpt.core.internal.context.java.HibernateGenericGeneratorContainer;
import org.jboss.tools.hibernate.jpt.core.internal.context.java.JavaDbGenericGenerator;
import org.jboss.tools.hibernate.jpt.core.internal.context.java.JavaParameter;
import org.jboss.tools.hibernate.jpt.core.internal.context.java.JpaUtil;
import org.jboss.tools.hibernate.jpt.core.internal.resource.java.GenericGeneratorAnnotation;
import org.jboss.tools.hibernate.jpt.core.internal.resource.java.ParameterAnnotation;
import org.jboss.tools.hibernate.jpt.core.internal.validation.HibernateJpaValidationMessage;

public class JavaDbGenericGeneratorImpl
extends AbstractJavaDatabaseGenerator<GenericGeneratorAnnotation>
implements JavaDbGenericGenerator,
Messages {
    private String strategy;
    protected final Vector<JavaParameter> parameters = new Vector();
    protected final ParameterContainerAdapter parameterContainerAdapter = new ParameterContainerAdapter();
    public static List<String> generatorClasses = new ArrayList<String>();

    static {
        generatorClasses.add("uuid");
        generatorClasses.add("uuid2");
        generatorClasses.add("hilo");
        generatorClasses.add("assigned");
        generatorClasses.add("identity");
        generatorClasses.add("select");
        generatorClasses.add("sequence");
        generatorClasses.add("seqhilo");
        generatorClasses.add("increment");
        generatorClasses.add("foreign");
        generatorClasses.add("guid");
        generatorClasses.add("uuid.hex");
        generatorClasses.add("sequence-identity");
    }

    public JavaDbGenericGeneratorImpl(HibernateGenericGeneratorContainer parent, GenericGeneratorAnnotation generatorAnnotation) {
        super((JavaGeneratorContainer)parent, (DatabaseGeneratorAnnotation)generatorAnnotation);
        this.strategy = generatorAnnotation.getStrategy();
        this.initializeParameters();
    }

    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.setStrategy_(((GenericGeneratorAnnotation)this.generatorAnnotation).getStrategy());
        this.syncParameters();
    }

    public void update() {
        super.update();
        this.updateModels((Iterable)this.getParameters());
    }

    public HibernateGenericGeneratorContainer getParent() {
        return (HibernateGenericGeneratorContainer)super.getParent();
    }

    public void convertTo(EntityMappings entityMappings) {
    }

    public void delete() {
        this.getParent().removeGenericGenerator(this);
    }

    public Class<GenericGenerator> getGeneratorType() {
        return GenericGenerator.class;
    }

    @Override
    public String getStrategy() {
        return this.strategy;
    }

    @Override
    public void setStrategy(String strategy) {
        ((GenericGeneratorAnnotation)this.getGeneratorAnnotation()).setStrategy(strategy);
        this.setStrategy_(strategy);
    }

    protected void setStrategy_(String strategy) {
        String oldStrategy = this.strategy;
        this.strategy = strategy;
        this.firePropertyChanged("genericStrategyProperty", oldStrategy, strategy);
    }

    @Override
    public TextRange getStrategyTextRange() {
        return ((GenericGeneratorAnnotation)this.generatorAnnotation).getStrategyTextRange();
    }

    protected String getCatalog() {
        return null;
    }

    protected String getSchema() {
        return null;
    }

    public void validate(List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
        this.validateStrategy(messages, reporter);
    }

    protected void validateStrategy(List<IMessage> messages, IReporter reporter) {
        if (this.strategy != null) {
            TextRange range;
            TextRange textRange = range = this.getStrategyTextRange() == null ? EmptyTextRange.instance() : this.getStrategyTextRange();
            if (this.strategy.trim().length() == 0) {
                messages.add(HibernateJpaValidationMessage.buildMessage(1, "STRATEGY_CANT_BE_EMPTY", this.getResource(), range));
            } else if (!generatorClasses.contains(this.strategy)) {
                IType lwType = null;
                try {
                    lwType = this.getJpaProject().getJavaProject().findType(this.strategy);
                    if (lwType == null || !lwType.isClass()) {
                        messages.add(HibernateJpaValidationMessage.buildMessage(1, "STRATEGY_CLASS_NOT_FOUND", new String[]{this.strategy}, this.getResource(), range));
                    } else if (!JpaUtil.isTypeImplementsInterface(this.getJpaProject().getJavaProject(), lwType, "org.hibernate.id.IdentifierGenerator").booleanValue()) {
                        messages.add(HibernateJpaValidationMessage.buildMessage(1, "STRATEGY_INTERFACE", new String[]{this.strategy}, this.getResource(), range));
                    }
                }
                catch (JavaModelException javaModelException) {}
            }
        }
    }

    protected HibernateAbstractJpaFactory getJpaFactory() {
        return (HibernateAbstractJpaFactory)super.getJpaFactory();
    }

    @Override
    public ListIterable<JavaParameter> getParameters() {
        return IterableTools.cloneLive(this.parameters);
    }

    @Override
    public int getParametersSize() {
        return this.parameters.size();
    }

    public JavaParameter addParameter() {
        return this.addParameter(this.parameters.size());
    }

    @Override
    public JavaParameter addParameter(int index) {
        ParameterAnnotation annotation = ((GenericGeneratorAnnotation)this.generatorAnnotation).addParameter(index);
        return this.addParameter_(index, annotation);
    }

    @Override
    public void removeParameter(Parameter parameter) {
        this.removeParameter(this.parameters.indexOf(parameter));
    }

    @Override
    public void removeParameter(int index) {
        ((GenericGeneratorAnnotation)this.generatorAnnotation).removeParameter(index);
        this.removeParameter_(index);
    }

    protected void removeParameter_(int index) {
        this.removeItemFromList(index, this.parameters, "parameters");
    }

    @Override
    public void moveParameter(int targetIndex, int sourceIndex) {
        ((GenericGeneratorAnnotation)this.generatorAnnotation).moveParameter(targetIndex, sourceIndex);
        this.moveItemInList(targetIndex, sourceIndex, this.parameters, "parameters");
    }

    protected void initializeParameters() {
        for (ParameterAnnotation param : ((GenericGeneratorAnnotation)this.generatorAnnotation).getParameters()) {
            this.parameters.add(this.buildParameter(param));
        }
    }

    protected JavaParameter buildParameter(ParameterAnnotation parameterAnnotation) {
        return this.getJpaFactory().buildJavaParameter((JpaContextModel)this, parameterAnnotation);
    }

    protected void syncParameters() {
        ContextContainerTools.synchronizeWithResourceModel((ContextContainerTools.Adapter)this.parameterContainerAdapter);
    }

    protected Iterable<ParameterAnnotation> getParameterAnnotations() {
        return ((GenericGeneratorAnnotation)this.generatorAnnotation).getParameters();
    }

    protected void moveParameter_(int index, JavaParameter parameter) {
        this.moveItemInList(index, parameter, this.parameters, "parameters");
    }

    protected JavaParameter addParameter_(int index, ParameterAnnotation parameterAnnotation) {
        JavaParameter parameter = this.buildParameter(parameterAnnotation);
        this.addItemToList(index, parameter, this.parameters, "parameters");
        return parameter;
    }

    protected void removeParameter_(JavaParameter parameter) {
        this.removeParameter_(this.parameters.indexOf(parameter));
    }

    public int buildDefaultInitialValue() {
        return GenericGenerator.DEFAULT_INITIAL_VALUE;
    }

    public Iterable<String> getCompletionProposals(int pos) {
        Iterable result = super.getCompletionProposals(pos);
        if (result != null) {
            return result;
        }
        TextRange strategyRange = this.getStrategyTextRange();
        if (strategyRange != null && strategyRange.touches(pos)) {
            return IterableTools.iterable((Object[])generatorClasses.toArray(new String[generatorClasses.size()]));
        }
        return null;
    }

    protected class ParameterContainerAdapter
    implements ContextContainerTools.Adapter<JavaParameter, ParameterAnnotation> {
        protected ParameterContainerAdapter() {
        }

        public Iterable<JavaParameter> getContextElements() {
            return JavaDbGenericGeneratorImpl.this.getParameters();
        }

        public Iterable<ParameterAnnotation> getResourceElements() {
            return JavaDbGenericGeneratorImpl.this.getParameterAnnotations();
        }

        public ParameterAnnotation getResourceElement(JavaParameter contextElement) {
            return contextElement.getParameterAnnotation();
        }

        public void moveContextElement(int index, JavaParameter element) {
            JavaDbGenericGeneratorImpl.this.moveParameter_(index, element);
        }

        public void addContextElement(int index, ParameterAnnotation resourceElement) {
            JavaDbGenericGeneratorImpl.this.addParameter_(index, resourceElement);
        }

        public void removeContextElement(JavaParameter element) {
            JavaDbGenericGeneratorImpl.this.removeParameter_(element);
        }
    }
}

