/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.ui.internal.editing;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.DocumentRewriteSession;
import org.eclipse.jface.text.DocumentRewriteSessionType;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension4;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.undo.IStructuredTextUndoManager;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.provisional.format.FormatProcessorXML;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class PomEdits {
    public static final String DEPENDENCIES = "dependencies";
    public static final String GROUP_ID = "groupId";
    public static final String ARTIFACT_ID = "artifactId";
    public static final String DEPENDENCY = "dependency";
    public static final String DEPENDENCY_MANAGEMENT = "dependencyManagement";
    public static final String EXCLUSIONS = "exclusions";
    public static final String EXCLUSION = "exclusion";
    public static final String VERSION = "version";
    public static final String PLUGIN = "plugin";
    public static final String CONFIGURATION = "configuration";
    public static final String PLUGINS = "plugins";
    public static final String PLUGIN_MANAGEMENT = "pluginManagement";
    public static final String BUILD = "build";
    public static final String PARENT = "parent";
    public static final String RELATIVE_PATH = "relativePath";
    public static final String TYPE = "type";
    public static final String CLASSIFIER = "classifier";
    public static final String OPTIONAL = "optional";
    public static final String SCOPE = "scope";
    public static final String MODULES = "modules";
    public static final String MODULE = "module";
    public static final String PROFILE = "profile";
    public static final String ID = "id";
    public static final String NAME = "name";
    public static final String URL = "url";
    public static final String DESCRIPTION = "description";
    public static final String INCEPTION_YEAR = "inceptionYear";
    public static final String ORGANIZATION = "organization";
    public static final String SCM = "scm";
    public static final String CONNECTION = "connection";
    public static final String DEV_CONNECTION = "developerConnection";
    public static final String TAG = "tag";
    public static final String ISSUE_MANAGEMENT = "issueManagement";
    public static final String SYSTEM = "system";
    public static final String SYSTEM_PATH = "systemPath";
    public static final String CI_MANAGEMENT = "ciManagement";
    public static final String PACKAGING = "packaging";
    public static final String PROPERTIES = "properties";
    public static final String EXTENSION = "extension";
    public static final String EXTENSIONS = "extensions";
    public static final String PROFILES = "profiles";
    public static final String EXECUTIONS = "executions";
    public static final String EXECUTION = "execution";
    public static final String GOAL = "goal";
    public static final String GOALS = "goals";

    public static Element findChild(Element parent, String name) {
        if (parent == null) {
            return null;
        }
        NodeList rootList = parent.getChildNodes();
        int i = 0;
        while (i < rootList.getLength()) {
            Element el;
            Node nd = rootList.item(i);
            if (nd instanceof Element && name.equals((el = (Element)nd).getNodeName())) {
                return el;
            }
            ++i;
        }
        return null;
    }

    public static List<Element> findChilds(Element parent, String name) {
        ArrayList<Element> toRet = new ArrayList<Element>();
        if (parent != null) {
            NodeList rootList = parent.getChildNodes();
            int i = 0;
            while (i < rootList.getLength()) {
                Element el;
                Node nd = rootList.item(i);
                if (nd instanceof Element && name.equals((el = (Element)nd).getNodeName())) {
                    toRet.add(el);
                }
                ++i;
            }
        }
        return toRet;
    }

    public static String getTextValue(Node element) {
        if (element == null) {
            return null;
        }
        StringBuffer buff = new StringBuffer();
        NodeList list = element.getChildNodes();
        int i = 0;
        while (i < list.getLength()) {
            Node child = list.item(i);
            if (child instanceof Text) {
                Text text = (Text)child;
                buff.append(text.getData().trim());
            }
            ++i;
        }
        return buff.toString();
    }

    public static Element findChild(Element parent, String name, Matcher ... matchers) {
        block0: for (Element el : PomEdits.findChilds(parent, name)) {
            Matcher[] matcherArray = matchers;
            int n = matchers.length;
            int n2 = 0;
            while (n2 < n) {
                Matcher match = matcherArray[n2];
                if (!match.matches(el)) continue block0;
                ++n2;
            }
            return el;
        }
        return null;
    }

    public static Element createElementWithText(Element parent, String name, String value) {
        Document doc = parent.getOwnerDocument();
        Element newElement = doc.createElement(name);
        parent.appendChild(newElement);
        newElement.appendChild(doc.createTextNode(value));
        return newElement;
    }

    public static Element createElement(Element parent, String name) {
        Document doc = parent.getOwnerDocument();
        Element newElement = doc.createElement(name);
        parent.appendChild(newElement);
        return newElement;
    }

    public static void setText(Element element, String value) {
        NodeList list = element.getChildNodes();
        ArrayList<Node> toRemove = new ArrayList<Node>();
        int i = 0;
        while (i < list.getLength()) {
            Node child = list.item(i);
            if (child instanceof Text) {
                toRemove.add(child);
            }
            ++i;
        }
        for (Node rm : toRemove) {
            element.removeChild(rm);
        }
        Document doc = element.getOwnerDocument();
        element.appendChild(doc.createTextNode(value));
    }

    public static Element getChild(Element parent, String ... names) {
        Element toFormat = null;
        Element toRet = null;
        if (names.length == 0) {
            throw new IllegalArgumentException("At least one child name has to be specified");
        }
        String[] stringArray = names;
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            toRet = PomEdits.findChild(parent, name);
            if (toRet == null) {
                toRet = parent.getOwnerDocument().createElement(name);
                parent.appendChild(toRet);
                if (toFormat == null) {
                    toFormat = toRet;
                }
            }
            parent = toRet;
            ++n2;
        }
        if (toFormat != null) {
            PomEdits.format(toFormat);
        }
        return toRet;
    }

    public static void removeChild(Element parent, Element child) {
        if (child != null) {
            Text txt;
            int lastnewline;
            Node prev = child.getPreviousSibling();
            if (prev instanceof Text && (lastnewline = PomEdits.getLastEolIndex((txt = (Text)prev).getData())) >= 0) {
                txt.setData(txt.getData().substring(0, lastnewline));
            }
            parent.removeChild(child);
        }
    }

    private static int getLastEolIndex(String s) {
        if (s == null || s.length() == 0) {
            return -1;
        }
        int i = s.length() - 1;
        while (i >= 0) {
            char c = s.charAt(i);
            if (c == '\r') {
                return i;
            }
            if (c == '\n') {
                if (i > 0 && s.charAt(i - 1) == '\r') {
                    return i - 1;
                }
                return i;
            }
            --i;
        }
        return -1;
    }

    public static void removeIfNoChildElement(Element el) {
        Node parent;
        NodeList nl = el.getChildNodes();
        boolean hasChilds = false;
        int i = 0;
        while (i < nl.getLength()) {
            Node child = nl.item(i);
            if (child instanceof Element) {
                hasChilds = true;
            }
            ++i;
        }
        if (!hasChilds && (parent = el.getParentNode()) != null && parent instanceof Element) {
            PomEdits.removeChild((Element)parent, el);
            PomEdits.removeIfNoChildElement((Element)parent);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Element insertAt(Element newElement, int offset) {
        Document doc = newElement.getOwnerDocument();
        if (!(doc instanceof IDOMDocument)) throw new IllegalArgumentException();
        IDOMDocument domDoc = (IDOMDocument)doc;
        IndexedRegion ir = domDoc.getModel().getIndexedRegion(offset);
        Node parent = ((Node)ir).getParentNode();
        if (ir instanceof Text) {
            Text txt = (Text)ir;
            String data = txt.getData();
            int dataSplitIndex = offset - ir.getStartOffset();
            String beforeText = data.substring(0, dataSplitIndex);
            String afterText = data.substring(dataSplitIndex);
            Text after = doc.createTextNode(afterText);
            Text before = doc.createTextNode(beforeText);
            parent.replaceChild(after, txt);
            parent.insertBefore(newElement, after);
            parent.insertBefore(before, newElement);
            return newElement;
        } else {
            if (!(ir instanceof Element)) throw new IllegalArgumentException();
            ((Element)ir).appendChild(newElement);
        }
        return newElement;
    }

    public static Element elementAtOffset(Document doc, int offset) {
        if (doc instanceof IDOMDocument) {
            IDOMDocument domDoc = (IDOMDocument)doc;
            IndexedRegion ir = domDoc.getModel().getIndexedRegion(offset);
            if (ir instanceof Element) {
                return (Element)ir;
            }
            Node parent = ((Node)ir).getParentNode();
            if (parent instanceof Element) {
                return (Element)parent;
            }
        }
        return null;
    }

    public static void format(Node newNode) {
        if (newNode.getParentNode() != null && newNode.equals(newNode.getParentNode().getLastChild())) {
            newNode.getParentNode().appendChild(newNode.getParentNode().getOwnerDocument().createTextNode("\n"));
        }
        FormatProcessorXML formatProcessor = new FormatProcessorXML();
        formatProcessor.getFormatPreferences().setLineWidth(2000);
        formatProcessor.formatNode(newNode);
    }

    public static void performOnDOMDocument(OperationTuple ... fileOperations) throws IOException, CoreException {
        OperationTuple[] operationTupleArray = fileOperations;
        int n = fileOperations.length;
        int n2 = 0;
        while (n2 < n) {
            OperationTuple tuple = operationTupleArray[n2];
            IDOMModel domModel = null;
            try {
                DocumentRewriteSession session = null;
                IStructuredTextUndoManager undo = null;
                if (tuple.isReadOnly()) {
                    domModel = (IDOMModel)StructuredModelManager.getModelManager().getExistingModelForRead(tuple.getDocument());
                    if (domModel == null) {
                        domModel = (IDOMModel)StructuredModelManager.getModelManager().getModelForRead((IStructuredDocument)tuple.getDocument());
                    }
                } else {
                    domModel = tuple.getModel() != null ? tuple.getModel() : (tuple.getFile() != null ? (IDOMModel)StructuredModelManager.getModelManager().getModelForEdit(tuple.getFile()) : (IDOMModel)StructuredModelManager.getModelManager().getExistingModelForEdit(tuple.getDocument()));
                    domModel.aboutToChangeModel();
                    undo = domModel.getStructuredDocument().getUndoManager();
                    if (domModel.getStructuredDocument() instanceof IDocumentExtension4) {
                        IDocumentExtension4 ext4 = (IDocumentExtension4)domModel.getStructuredDocument();
                        session = ext4.startRewriteSession(DocumentRewriteSessionType.UNRESTRICTED_SMALL);
                    }
                    undo.beginRecording((Object)domModel);
                }
                try {
                    tuple.getOperation().process((Document)domModel.getDocument());
                }
                finally {
                    if (!tuple.isReadOnly()) {
                        undo.endRecording((Object)domModel);
                        if (session != null && domModel.getStructuredDocument() instanceof IDocumentExtension4) {
                            IDocumentExtension4 ext4 = (IDocumentExtension4)domModel.getStructuredDocument();
                            ext4.stopRewriteSession(session);
                        }
                        domModel.changedModel();
                    }
                }
            }
            finally {
                if (domModel != null) {
                    if (tuple.isReadOnly()) {
                        domModel.releaseFromRead();
                    } else if (domModel.getId() != null) {
                        if (tuple.isForceSave() || domModel.getReferenceCountForEdit() == 1) {
                            domModel.save();
                        }
                        domModel.releaseFromEdit();
                    }
                }
            }
            ++n2;
        }
    }

    public static Matcher childEquals(final String elementName, final String matchingValue) {
        return new Matcher(){

            @Override
            public boolean matches(Element child) {
                String toMatch = PomEdits.getTextValue(PomEdits.findChild(child, elementName));
                return toMatch != null && toMatch.trim().equals(matchingValue);
            }
        };
    }

    public static Matcher textEquals(final String matchingValue) {
        return new Matcher(){

            @Override
            public boolean matches(Element child) {
                String toMatch = PomEdits.getTextValue(child);
                return toMatch != null && toMatch.trim().equals(matchingValue);
            }
        };
    }

    public static Matcher childMissingOrEqual(final String elementName, final String matchingValue) {
        return new Matcher(){

            @Override
            public boolean matches(Element child) {
                Element match = PomEdits.findChild(child, elementName);
                if (match == null) {
                    return true;
                }
                String toMatch = PomEdits.getTextValue(match);
                return toMatch != null && toMatch.trim().equals(matchingValue);
            }
        };
    }

    public static Matcher childAt(final int index) {
        return new Matcher(){
            int count = 0;

            @Override
            public boolean matches(Element child) {
                if (this.count == index) {
                    return true;
                }
                ++this.count;
                return false;
            }
        };
    }

    public static final class CompoundOperation
    implements Operation {
        private final Operation[] operations;

        public CompoundOperation(Operation ... operations) {
            this.operations = operations;
        }

        @Override
        public void process(Document document) {
            Operation[] operationArray = this.operations;
            int n = this.operations.length;
            int n2 = 0;
            while (n2 < n) {
                Operation oper = operationArray[n2];
                oper.process(document);
                ++n2;
            }
        }
    }

    public static interface Matcher {
        public boolean matches(Element var1);
    }

    public static interface Operation {
        public void process(Document var1);
    }

    public static final class OperationTuple {
        private final Operation operation;
        private final IFile file;
        private final IDocument document;
        private final IDOMModel model;
        private boolean readOnly = false;
        private boolean forceSave = false;

        public OperationTuple(IFile file, Operation operation) {
            assert (file != null);
            assert (operation != null);
            this.file = file;
            this.operation = operation;
            this.document = null;
            this.model = null;
            this.forceSave = true;
        }

        public OperationTuple(IDocument document, Operation operation) {
            this(document, operation, false);
        }

        public OperationTuple(IDocument document, Operation operation, boolean readOnly) {
            assert (operation != null);
            this.document = document;
            this.operation = operation;
            this.file = null;
            this.model = null;
            this.readOnly = readOnly;
        }

        public OperationTuple(IDOMModel model, Operation operation) {
            assert (model != null);
            this.operation = operation;
            this.model = model;
            this.document = null;
            this.file = null;
        }

        public void setForceSave() {
            this.forceSave = true;
        }

        public boolean isForceSave() {
            return this.forceSave;
        }

        public boolean isReadOnly() {
            return this.readOnly;
        }

        public IFile getFile() {
            return this.file;
        }

        public Operation getOperation() {
            return this.operation;
        }

        public IDocument getDocument() {
            return this.document;
        }

        public IDOMModel getModel() {
            return this.model;
        }
    }
}

