/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.thym.core.plugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Stack;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.thym.core.HybridCore;
import org.eclipse.thym.core.platform.IPluginInstallationAction;
import org.eclipse.thym.core.plugin.FileOverwriteCallback;

public class PluginInstallActionsRunOperation
implements IWorkspaceRunnable {
    private final List<IPluginInstallationAction> actions;
    private final boolean runUnInstall;
    private final FileOverwriteCallback overwrite;
    private final IProject project;

    public PluginInstallActionsRunOperation(List<IPluginInstallationAction> actions, boolean runUnInstall, FileOverwriteCallback overwrite, IProject project) {
        this.actions = actions;
        this.overwrite = overwrite;
        this.runUnInstall = runUnInstall;
        this.project = project;
    }

    public void run(IProgressMonitor monitor) throws CoreException {
        if (this.overwrite != null) {
            ArrayList<String> list = new ArrayList<String>();
            for (IPluginInstallationAction action : this.actions) {
                String[] files = action.filesToOverwrite();
                if (files == null || files.length <= 0) continue;
                list.addAll(Arrays.asList(files));
            }
            if (!list.isEmpty() && !this.overwrite.isOverwiteAllowed(list.toArray(new String[list.size()]))) {
                HybridCore.log(1, "File overwrite not allowed cancelled Cordova plugin installation", null);
                return;
            }
        }
        Stack<IPluginInstallationAction> executed = new Stack<IPluginInstallationAction>();
        boolean rollback = false;
        try {
            for (IPluginInstallationAction action : this.actions) {
                HybridCore.trace("Running Cordova plugin action: " + action);
                if (monitor.isCanceled()) {
                    rollback = true;
                    break;
                }
                if (this.runUnInstall) {
                    action.unInstall();
                } else {
                    action.install();
                }
                monitor.worked(1);
                executed.push(action);
            }
        }
        catch (Exception e) {
            HybridCore.log(4, "Error while installing plugin", e);
            rollback = true;
        }
        if (rollback) {
            while (!executed.empty()) {
                IPluginInstallationAction action;
                action = (IPluginInstallationAction)executed.pop();
                HybridCore.trace("Rolling back Cordova plugin action: " + action);
                try {
                    if (this.runUnInstall) {
                        action.install();
                        continue;
                    }
                    action.unInstall();
                }
                catch (Exception e) {
                    HybridCore.log(4, "Error rolling back install action", e);
                }
            }
        }
        this.project.refreshLocal(2, monitor);
    }
}

