/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.thym.core.internal.libraries;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.thym.core.HybridCore;
import org.eclipse.thym.core.HybridProject;
import org.eclipse.thym.core.engine.HybridMobileEngine;
import org.eclipse.thym.core.engine.HybridMobileLibraryResolver;
import org.eclipse.thym.core.engine.PlatformLibrary;
import org.eclipse.wst.jsdt.core.IIncludePathEntry;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.IJsGlobalScopeContainer;
import org.eclipse.wst.jsdt.core.JavaScriptCore;
import org.eclipse.wst.jsdt.core.JsGlobalScopeContainerInitializer;
import org.eclipse.wst.jsdt.core.compiler.libraries.LibraryLocation;
import org.osgi.framework.Bundle;

public class CordovaLibraryJsContainerInitializer
extends JsGlobalScopeContainerInitializer {
    public static final String CONTAINER_ID = "org.eclipse.thym.core.CordovaContainerInitializer";
    private IJavaScriptProject project;

    public CordovaLibraryJsContainerInitializer() {
    }

    public CordovaLibraryJsContainerInitializer(IJavaScriptProject project) {
        this.project = project;
    }

    public void initialize(IPath containerPath, IJavaScriptProject project) throws CoreException {
        CordovaLibraryJsContainerInitializer scopeContainer = new CordovaLibraryJsContainerInitializer(project);
        JavaScriptCore.setJsGlobalScopeContainer((IPath)containerPath, (IJavaScriptProject[])new IJavaScriptProject[]{project}, (IJsGlobalScopeContainer[])new IJsGlobalScopeContainer[]{scopeContainer}, null);
    }

    public String getDescription() {
        return "Cordova JS Library";
    }

    public IPath getPath() {
        return new Path(CONTAINER_ID);
    }

    public int getKind() {
        return 3;
    }

    public IIncludePathEntry[] getIncludepathEntries() {
        ArrayList<IIncludePathEntry> list = new ArrayList<IIncludePathEntry>();
        IIncludePathEntry entry = this.getCordovaJsIncludePathEntry();
        if (entry != null) {
            list.add(entry);
        }
        if ((entry = this.getPluginJsIncludePathEntry()) != null) {
            list.add(entry);
        }
        return list.toArray(new IIncludePathEntry[list.size()]);
    }

    private IIncludePathEntry getPluginJsIncludePathEntry() {
        try {
            String content = "cordova.define('cordova/plugin_list', function(require, exports, module) {module.exports = [ ] });";
            String projectName = "cordova_generic";
            if (this.project != null) {
                HybridProject prj = HybridProject.getHybridProject(this.project.getProject());
                if (prj != null) {
                    content = prj.getPluginManager().getCordovaPluginJSContent(null);
                }
                projectName = this.project.getProject().getName();
            }
            IPath pluginJSRuntimePath = this.getLibraryRuntimeFolder().append(projectName).append("cordova_plugins.js");
            ByteArrayInputStream is = new ByteArrayInputStream(content.getBytes());
            File pluginJs = pluginJSRuntimePath.toFile();
            FileUtils.copyInputStreamToFile((InputStream)is, (File)pluginJs);
            return JavaScriptCore.newLibraryEntry((IPath)pluginJSRuntimePath.makeAbsolute(), null, null);
        }
        catch (CoreException e) {
            HybridCore.log(4, "Error creating the cordova plugin JS runtime libraries", e);
        }
        catch (IOException e) {
            HybridCore.log(4, "Error creating the cordova plugin JS runtime libraries", e);
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private IIncludePathEntry getCordovaJsIncludePathEntry() {
        List<PlatformLibrary> platforms;
        File cordovaJS;
        IPath cordovaJSRuntimePath;
        block5: {
            HybridMobileEngine activeEngine;
            block4: {
                try {
                    cordovaJSRuntimePath = this.getLibraryRuntimeFolder().append("cordova.js");
                    cordovaJS = cordovaJSRuntimePath.toFile();
                    if (cordovaJS.exists()) return JavaScriptCore.newLibraryEntry((IPath)cordovaJSRuntimePath.makeAbsolute(), null, null);
                    HybridProject prj = HybridProject.getHybridProject(this.project.getProject());
                    activeEngine = prj.getActiveEngine();
                    if (activeEngine != null) break block4;
                    return null;
                }
                catch (IOException e) {
                    HybridCore.log(4, "Error creating the cordova JS runtime libraries", e);
                    return null;
                }
            }
            platforms = activeEngine.getPlatformLibs();
            if (!platforms.isEmpty()) break block5;
            return null;
        }
        HybridMobileLibraryResolver resolver = platforms.get(0).getPlatformLibraryResolver();
        URL templateCordovaJS = resolver.getTemplateFile(HybridMobileLibraryResolver.PATH_CORDOVA_JS);
        org.eclipse.thym.core.internal.util.FileUtils.fileCopy(templateCordovaJS, org.eclipse.thym.core.internal.util.FileUtils.toURL(cordovaJS));
        return JavaScriptCore.newLibraryEntry((IPath)cordovaJSRuntimePath.makeAbsolute(), null, null);
    }

    private IPath getLibraryRuntimeFolder() {
        IPath libraryRuntimePath = Platform.getStateLocation((Bundle)Platform.getBundle((String)"org.eclipse.thym.core")).append("cordovaJsLib");
        File libRuntimeFile = libraryRuntimePath.toFile();
        if (!libRuntimeFile.isDirectory()) {
            libRuntimeFile.mkdir();
        }
        return libraryRuntimePath;
    }

    public String[] resolvedLibraryImport(String realImport) {
        return new String[]{realImport};
    }

    public boolean canUpdateJsGlobalScopeContainer(IPath containerPath, IJavaScriptProject project) {
        return true;
    }

    public void requestJsGlobalScopeContainerUpdate(IPath containerPath, IJavaScriptProject project, IJsGlobalScopeContainer containerSuggestion) throws CoreException {
    }

    public String getDescription(IPath containerPath, IJavaScriptProject project) {
        return "Cordova JS Library";
    }

    public IJsGlobalScopeContainer getFailureContainer(final IPath containerPath, IJavaScriptProject project) {
        final String description = this.getDescription(containerPath, project);
        return new IJsGlobalScopeContainer(){

            public IIncludePathEntry[] getIncludepathEntries() {
                return new IIncludePathEntry[0];
            }

            public String getDescription() {
                return description;
            }

            public int getKind() {
                return 0;
            }

            public IPath getPath() {
                return containerPath;
            }

            public String toString() {
                return this.getDescription();
            }

            public String[] resolvedLibraryImport(String a) {
                return new String[]{a};
            }
        };
    }

    public Object getComparisonID(IPath containerPath, IJavaScriptProject project) {
        if (containerPath == null) {
            return null;
        }
        return containerPath.segment(0);
    }

    public URI getHostPath(IPath path, IJavaScriptProject project) {
        return null;
    }

    public boolean allowAttachJsDoc() {
        return true;
    }

    public String[] containerSuperTypes() {
        return new String[]{"cordova"};
    }

    public String getInferenceID() {
        return "org.eclipse.wst.jsdt.core.infer.DefaultInferrenceProvider";
    }

    public void removeFromProject(IJavaScriptProject project) {
    }

    public LibraryLocation getLibraryLocation() {
        return null;
    }
}

