/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.thym.core.engine.internal.cordova;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.thym.core.HybridCore;
import org.eclipse.thym.core.engine.AbstractEngineRepoProvider;
import org.eclipse.thym.core.engine.internal.cordova.DownloadableCordovaEngine;
import org.osgi.framework.Bundle;

public class DefaultEngineRepoProvider
extends AbstractEngineRepoProvider {
    private static final String REPO_JSON_URL = "https://raw.githubusercontent.com/eclipse/thym/master/plugins/org.eclipse.thym.core/res/platforms.json";

    @Override
    public List<DownloadableCordovaEngine> getEngines() throws CoreException {
        ArrayList<DownloadableCordovaEngine> downloadableCordovaEngines = new ArrayList();
        try {
            InputStream stream = this.getRemoteJSonStream(REPO_JSON_URL);
            if (stream == null || stream.available() < 1) {
                URL url = FileLocator.find((Bundle)HybridCore.getContext().getBundle(), (IPath)new Path("/res/platforms.json"), null);
                if (url == null) {
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.thym.core", "Could not read downloadable engine list"));
                }
                stream = url.openStream();
            }
            downloadableCordovaEngines = this.getEnginesFromStream(stream);
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.thym.core", "Could not read downloadable engine list", (Throwable)e));
        }
        return downloadableCordovaEngines;
    }
}

