/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.archives.ui.views;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.INullSelectionListener;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.navigator.CommonNavigator;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.PropertySheetPage;
import org.jboss.ide.eclipse.archives.core.model.IArchiveNode;
import org.jboss.ide.eclipse.archives.ui.ArchivesSharedImages;
import org.jboss.ide.eclipse.archives.ui.ArchivesUIMessages;
import org.jboss.ide.eclipse.archives.ui.PrefsInitializer;
import org.jboss.ide.eclipse.archives.ui.actions.BuildAction;
import org.jboss.ide.eclipse.archives.ui.providers.ArchivesContentProviderDelegate;

public class ProjectArchivesCommonView
extends CommonNavigator
implements PrefsInitializer.IArchivesPreferenceListener {
    public static final String ID = "org.jboss.ide.eclipse.archives.ui.ProjectArchivesView";
    protected static ProjectArchivesCommonView instance;
    protected ISelectionListener selectionListener;
    protected IProject currentProject;

    public static ProjectArchivesCommonView getInstance() {
        return instance;
    }

    public ProjectArchivesCommonView() {
        instance = this;
        this.selectionListener = this.createSelectionListener();
    }

    protected IAdaptable getInitialInput() {
        this.currentProject = null;
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    public void createPartControl(Composite aParent) {
        super.createPartControl(aParent);
        this.addBuildActionToSite();
        PrefsInitializer.addListener(this);
    }

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService().addPostSelectionListener(this.selectionListener);
    }

    public void dispose() {
        super.dispose();
        try {
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService().removePostSelectionListener(this.selectionListener);
        }
        catch (NullPointerException nullPointerException) {}
        PrefsInitializer.removeListener(this);
    }

    protected ISelectionListener createSelectionListener() {
        return new INullSelectionListener(){

            public void selectionChanged(IWorkbenchPart part, ISelection selection) {
                if (part == instance) {
                    return;
                }
                if (selection == null || selection.isEmpty()) {
                    if (ProjectArchivesCommonView.this.currentProject != null && !ProjectArchivesCommonView.this.currentProject.isAccessible()) {
                        ProjectArchivesCommonView.this.currentProject = null;
                        ProjectArchivesCommonView.this.jiggleViewerInput();
                    }
                    return;
                }
                if (!(selection instanceof IStructuredSelection)) {
                    return;
                }
                Object element = ((IStructuredSelection)selection).getFirstElement();
                IProject project = this.getProject(element);
                if (project != null && project != ProjectArchivesCommonView.this.currentProject && project.isOpen()) {
                    ProjectArchivesCommonView.this.currentProject = project;
                    ProjectArchivesCommonView.this.jiggleViewerInput();
                }
            }

            public IProject getProject(Object element) {
                IAdaptable adaptable;
                IResource resource;
                if (element instanceof IStructuredSelection) {
                    element = ((IStructuredSelection)element).getFirstElement();
                }
                if (element instanceof IAdaptable && (resource = (IResource)(adaptable = (IAdaptable)element).getAdapter(IResource.class)) != null) {
                    return resource.getProject();
                }
                if (element instanceof ArchivesContentProviderDelegate.WrappedProject) {
                    return ((ArchivesContentProviderDelegate.WrappedProject)element).getElement();
                }
                if (element instanceof IArchiveNode) {
                    String projName = ((IArchiveNode)element).getProjectName();
                    return ResourcesPlugin.getWorkspace().getRoot().getProject(projName);
                }
                return null;
            }
        };
    }

    public IProject getCurrentProject() {
        return this.currentProject;
    }

    protected void jiggleViewerInput() {
        if (this.showProjectRoot()) {
            if (!this.showAllProjects() || !this.getCommonViewer().getInput().equals(ResourcesPlugin.getWorkspace().getRoot())) {
                this.getCommonViewer().setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
            }
        } else {
            this.getCommonViewer().setInput((Object)this.currentProject);
        }
    }

    private boolean showProjectRoot() {
        return PrefsInitializer.getBoolean("showProjectRoot");
    }

    private boolean showAllProjects() {
        return PrefsInitializer.getBoolean("showAllProjects");
    }

    public void addBuildActionToSite() {
        Action buildAction = new Action(ArchivesUIMessages.BuildArchivesNode, ArchivesSharedImages.getImageDescriptor("icons/build_packages.gif")){

            public void run() {
                ProjectArchivesCommonView.this.buildSelection(ProjectArchivesCommonView.this.getSelectedObject());
            }
        };
        IActionBars bars = ((IViewSite)this.getSite()).getActionBars();
        bars.getToolBarManager().add((IAction)buildAction);
    }

    private void buildSelection(Object selected) {
        new BuildAction().run(selected);
    }

    private Object getSelectedObject() {
        IStructuredSelection selection = (IStructuredSelection)this.getCommonViewer().getSelection();
        if (selection != null && !selection.isEmpty()) {
            return selection.getFirstElement();
        }
        return null;
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IPropertySheetPage.class) {
            return new PropertySheetPage();
        }
        return super.getAdapter(adapter);
    }

    public void preferenceChanged(String key, boolean val) {
        this.jiggleViewerInput();
    }

    public void preferenceChanged(String key, String val) {
        this.jiggleViewerInput();
    }
}

