/*
 * Decompiled with CFR 0.152.
 */
package tern.eclipse.ide.internal.ui;

import java.io.IOException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import tern.ITernFile;
import tern.ITernProject;
import tern.TernResourcesManager;
import tern.eclipse.ide.core.resources.TernDocumentFile;
import tern.eclipse.ide.internal.ui.util.AllInOneWorkbenchListener;
import tern.eclipse.ide.ui.TernUIPlugin;

public class EditorActivationTracker
extends AllInOneWorkbenchListener {
    private static final EditorActivationTracker INSTANCE = new EditorActivationTracker();

    public static EditorActivationTracker getInstance() {
        return INSTANCE;
    }

    private EditorActivationTracker() {
        this.initialize();
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbench bench = PlatformUI.getWorkbench();
                if (bench.getWorkbenchWindowCount() > 0) {
                    EditorActivationTracker.this.partActivated(bench.getActiveWorkbenchWindow().getActivePage().getActivePart());
                }
            }
        });
    }

    @Override
    public void partActivated(IWorkbenchPart part) {
        ITernProject project;
        IFile file = this.getFile(part);
        if (file != null && (TernResourcesManager.isHTMLFile((Object)file) || TernResourcesManager.isJSFile((Object)file)) && (project = TernResourcesManager.getTernProject((Object)file.getProject())) != null) {
            new Job("Synchronizing script resources with Tern server..."){

                protected IStatus run(IProgressMonitor monitor) {
                    monitor.beginTask("", -1);
                    project.getFileSynchronizer().ensureSynchronized();
                    return Status.OK_STATUS;
                }
            }.schedule();
        }
    }

    @Override
    public void partDeactivated(IWorkbenchPart part) {
        ITernProject project;
        IFile file = this.getFile(part);
        boolean isHtml = false;
        if (file != null && (TernResourcesManager.isJSFile((Object)file) || (isHtml = TernResourcesManager.isHTMLFile((Object)file))) && (project = TernResourcesManager.getTernProject((Object)file.getProject())) != null) {
            if (isHtml) {
                project.getFileSynchronizer().refresh((Object)file);
                return;
            }
            IDocument document = (IDocument)part.getAdapter(IDocument.class);
            if (document != null) {
                TernDocumentFile tf = new TernDocumentFile(file, document);
                new Job("Synchronizing sources with Tern server", (ITernFile)tf){
                    private final /* synthetic */ ITernFile val$tf;
                    {
                        this.val$tf = iTernFile;
                        super($anonymous0);
                    }

                    protected IStatus run(IProgressMonitor monitor) {
                        try {
                            project.getFileSynchronizer().synchronizeFile(this.val$tf);
                        }
                        catch (IOException e) {
                            TernUIPlugin.getDefault().getLog().log((IStatus)new Status(4, "tern.eclipse.ide.ui", e.getMessage(), (Throwable)e));
                        }
                        return Status.OK_STATUS;
                    }
                }.schedule();
            }
        }
    }

    private IFile getFile(IWorkbenchPart part) {
        IEditorInput input;
        if (part instanceof IEditorPart && (input = ((IEditorPart)part).getEditorInput()) instanceof IFileEditorInput) {
            return ((IFileEditorInput)input).getFile();
        }
        return null;
    }
}

