/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.thym.ui.internal.engine;

import com.github.zafarkhaja.semver.Version;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.window.ToolTip;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.thym.core.HybridCore;
import org.eclipse.thym.core.engine.HybridMobileEngine;
import org.eclipse.thym.core.engine.HybridMobileEngineLocator;
import org.eclipse.thym.core.engine.PlatformLibrary;
import org.eclipse.thym.core.engine.internal.cordova.CordovaEngineProvider;
import org.eclipse.thym.core.extensions.PlatformSupport;
import org.eclipse.thym.ui.HybridUI;
import org.eclipse.thym.ui.PlatformImage;
import org.eclipse.thym.ui.internal.engine.EngineDownloadDialog;
import org.eclipse.thym.ui.internal.status.StatusManager;
import org.eclipse.ui.PlatformUI;

public class AvailableCordovaEnginesSection
implements ISelectionProvider {
    private static final int TABLE_HEIGHT = 250;
    private static final int TABLE_WIDTH = 350;
    private ListenerList selectionListeners;
    private ListenerList engineChangeListeners;
    private CheckboxTableViewer engineList;
    private ISelection prevSelection = new StructuredSelection();
    private CordovaEngineProvider provider;
    private Button removeBtn;

    public AvailableCordovaEnginesSection() {
        this.selectionListeners = new ListenerList();
        this.engineChangeListeners = new ListenerList();
    }

    public void createControl(final Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(composite);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)composite);
        Label tableLbl = new Label(composite, 0);
        tableLbl.setText("Available Engines: ");
        GridDataFactory.generate((Control)tableLbl, (int)2, (int)1);
        final Table table = new Table(composite, 67620);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, false).minSize(new Point(350, 250)).applyTo((Control)table);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        TableColumn col = new TableColumn(table, 0);
        col.setWidth(175);
        col.setText("Name");
        col.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                EngineVersionComparator comp = (EngineVersionComparator)AvailableCordovaEnginesSection.this.engineList.getComparator();
                AvailableCordovaEnginesSection.this.engineList.setComparator((ViewerComparator)new EngineVersionComparator(!comp.descending));
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        col = new TableColumn(table, 0);
        col.setWidth(150);
        col.setText("Platforms");
        col = new TableColumn(table, 0);
        col.setWidth(25);
        table.addListener(4, new Listener(){

            public void handleEvent(Event event) {
                Rectangle rect;
                Point p = new Point(event.x, event.y);
                TableItem item = table.getItem(p);
                if (item != null && (rect = item.getBounds(2)).contains(p)) {
                    EngineTooltip tooltip = new EngineTooltip((Control)table);
                    tooltip.show(p);
                }
            }
        });
        this.engineList = new CheckboxTableViewer(table);
        this.engineList.setContentProvider((IContentProvider)new CordovaEnginesContentProvider());
        this.engineList.setLabelProvider((IBaseLabelProvider)new CordovaEngineLabelProvider());
        this.engineList.setComparator((ViewerComparator)new EngineVersionComparator(true));
        this.engineList.setUseHashlookup(true);
        this.engineList.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                if (event.getChecked()) {
                    AvailableCordovaEnginesSection.this.setSelection((ISelection)new StructuredSelection(event.getElement()));
                } else {
                    AvailableCordovaEnginesSection.this.setSelection((ISelection)new StructuredSelection());
                }
            }
        });
        this.engineList.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                AvailableCordovaEnginesSection.this.updateButtons();
            }
        });
        Composite buttonsContainer = new Composite(composite, 0);
        GridDataFactory.fillDefaults().align(1, 4).applyTo((Control)buttonsContainer);
        GridLayoutFactory.fillDefaults().spacing(0, 3).numColumns(1).applyTo(buttonsContainer);
        Button downloadBtn = new Button(buttonsContainer, 8);
        downloadBtn.setText("Download...");
        GridDataFactory.fillDefaults().align(4, 1).applyTo((Control)downloadBtn);
        downloadBtn.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                EngineDownloadDialog downloadDialog = new EngineDownloadDialog(AvailableCordovaEnginesSection.this.engineList.getControl().getShell());
                int status = downloadDialog.open();
                if (status == 0) {
                    AvailableCordovaEnginesSection.this.updateAvailableEngines();
                }
            }
        });
        Button searchBtn = new Button(buttonsContainer, 8);
        searchBtn.setText("Search...");
        GridDataFactory.fillDefaults().align(4, 1).applyTo((Control)searchBtn);
        searchBtn.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                AvailableCordovaEnginesSection.this.handleSearch(parent);
            }
        });
        this.removeBtn = new Button(buttonsContainer, 8);
        this.removeBtn.setText("Remove");
        GridDataFactory.fillDefaults().align(4, 1).applyTo((Control)this.removeBtn);
        this.removeBtn.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                AvailableCordovaEnginesSection.this.handleRemoveEngine();
            }
        });
        this.updateAvailableEngines();
        this.updateButtons();
    }

    private void updateButtons() {
        this.removeBtn.setEnabled(!this.engineList.getSelection().isEmpty());
    }

    private void updateAvailableEngines() {
        CordovaEngineProvider provider = this.getEngineProvider();
        final List engines = provider.getAvailableEngines();
        Job preCompileJob = new Job("Hybrid Mobile Engine Library pre-compilation"){

            protected IStatus run(IProgressMonitor monitor) {
                for (HybridMobileEngine hybridMobileEngine : engines) {
                    try {
                        hybridMobileEngine.preCompile(monitor);
                    }
                    catch (CoreException e) {
                        HybridUI.log(2, NLS.bind((String)"Pre-compilation for engine {0} {1} has failed", (Object[])new String[]{hybridMobileEngine.getName(), hybridMobileEngine.getVersion()}), e);
                    }
                }
                return Status.OK_STATUS;
            }
        };
        preCompileJob.schedule();
        this.engineList.setInput((Object)engines);
        this.fireEngineListChanged();
    }

    private CordovaEngineProvider getEngineProvider() {
        if (this.provider == null) {
            this.provider = new CordovaEngineProvider();
        }
        return this.provider;
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionListeners.add((Object)listener);
    }

    public void addEngineListChangeListener(EngineListChangeListener listener) {
        this.engineChangeListeners.add((Object)listener);
    }

    public void removeEngineListChangeListener(EngineListChangeListener listener) {
        this.engineChangeListeners.remove((Object)listener);
    }

    public ISelection getSelection() {
        return new StructuredSelection(this.engineList.getCheckedElements());
    }

    public List<HybridMobileEngine> getListedEngines() {
        Object o = this.engineList.getInput();
        if (o == null) {
            return null;
        }
        return (List)o;
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionListeners.remove((Object)this.selectionListeners);
    }

    public void setSelection(ISelection selection) {
        if (selection instanceof IStructuredSelection && !selection.equals(this.prevSelection)) {
            this.prevSelection = selection;
            Object engine = ((IStructuredSelection)selection).getFirstElement();
            if (engine == null) {
                this.engineList.setCheckedElements(new Object[0]);
            } else {
                this.engineList.getTable().getItem(0).setChecked(true);
                this.engineList.setCheckedElements(new Object[]{engine});
                this.engineList.reveal(engine);
            }
            this.engineList.refresh(true);
            this.fireSelectionChanged();
        }
    }

    private void fireSelectionChanged() {
        SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)this, this.getSelection());
        Object[] listeners = this.selectionListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ISelectionChangedListener listener = (ISelectionChangedListener)listeners[i];
            listener.selectionChanged(event);
            ++i;
        }
    }

    private void fireEngineListChanged() {
        Object[] listeners = this.engineChangeListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            EngineListChangeListener l = (EngineListChangeListener)listeners[i];
            l.listChanged();
            ++i;
        }
    }

    private void handleSearch(Composite parent) {
        DirectoryDialog directoryDialog = new DirectoryDialog(parent.getShell());
        directoryDialog.setMessage("Select the directory in which to search for hybrid mobile engines");
        directoryDialog.setText("Search for Hybrid Mobile Engines");
        String pathStr = directoryDialog.open();
        if (pathStr == null) {
            return;
        }
        Path path = new Path(pathStr);
        ProgressMonitorDialog dialog = new ProgressMonitorDialog(parent.getShell());
        dialog.setBlockOnOpen(false);
        dialog.setCancelable(true);
        dialog.open();
        HybridMobileEngineLocator.EngineSearchListener listener = new HybridMobileEngineLocator.EngineSearchListener(){

            public void libraryFound(PlatformLibrary library) {
                AvailableCordovaEnginesSection.this.addPathToPreference(library.getLocation());
                AvailableCordovaEnginesSection.this.getEngineProvider().libraryFound(library);
            }
        };
        IRunnableWithProgress runnable = new IRunnableWithProgress((IPath)path, listener, parent){
            private final /* synthetic */ IPath val$path;
            private final /* synthetic */ HybridMobileEngineLocator.EngineSearchListener val$listener;
            private final /* synthetic */ Composite val$parent;
            {
                this.val$path = iPath;
                this.val$listener = engineSearchListener;
                this.val$parent = composite;
            }

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                List locators = HybridCore.getEngineLocators();
                for (HybridMobileEngineLocator locator : locators) {
                    locator.searchForRuntimes(this.val$path, this.val$listener, monitor);
                }
                this.val$parent.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        AvailableCordovaEnginesSection.this.updateAvailableEngines();
                    }
                });
            }
        };
        try {
            dialog.run(true, true, runnable);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() != null) {
                if (e.getTargetException() instanceof CoreException) {
                    StatusManager.handle((CoreException)e.getTargetException());
                } else {
                    ErrorDialog.openError((Shell)parent.getShell(), (String)"Local Engine Search Error", null, (IStatus)new Status(4, "org.eclipse.thym.ui", "Error when searching for local hybrid mobile engines", e.getTargetException()));
                }
            }
        }
        catch (InterruptedException e) {
            HybridUI.log(4, "Search for Cordova Engines error", e);
        }
    }

    private void addPathToPreference(IPath path) {
        IPreferenceStore store = HybridUI.getDefault().getPreferenceStore();
        String locs = store.getString("custom_engine_loc");
        String pathString = path.toString();
        if (locs == null || locs.isEmpty()) {
            locs = pathString;
        } else {
            String[] locArray = locs.split(",");
            int i = 0;
            while (i < locArray.length) {
                if (locArray[i].equals(pathString)) {
                    return;
                }
                ++i;
            }
            locs = String.valueOf(locs) + "," + pathString;
        }
        store.setValue("custom_engine_loc", locs);
    }

    private void removePathFromPreference(IPath path) {
        IPreferenceStore store = HybridUI.getDefault().getPreferenceStore();
        String locs = store.getString("custom_engine_loc");
        if (locs == null || locs.isEmpty()) {
            return;
        }
        String pathString = path.toString();
        String[] locArray = locs.split(",");
        StringBuilder newLocs = new StringBuilder();
        int i = 0;
        while (i < locArray.length) {
            if (!locArray[i].equals(pathString)) {
                if (i > 0) {
                    newLocs.append(",");
                }
                newLocs.append(locArray[i]);
            }
            ++i;
        }
        store.setValue("custom_engine_loc", newLocs.toString());
    }

    private void handleRemoveEngine() {
        boolean deleteConfirm;
        HybridMobileEngine selectedEngine;
        IStructuredSelection selection = (IStructuredSelection)this.engineList.getSelection();
        ISelection cSelection = this.getSelection();
        HybridMobileEngine checkedEngine = null;
        if (cSelection != null && !cSelection.isEmpty()) {
            IStructuredSelection css = (IStructuredSelection)cSelection;
            checkedEngine = (HybridMobileEngine)css.getFirstElement();
        }
        if ((selectedEngine = (HybridMobileEngine)selection.getFirstElement()).getId().equals("cordova") && !(deleteConfirm = MessageDialog.openConfirm((Shell)this.engineList.getTable().getShell(), (String)"Confirm Delete", (String)NLS.bind((String)"This will remove {0} {1} from your computer. Do you want to continue?", (Object[])new String[]{selectedEngine.getName(), selectedEngine.getVersion()})))) {
            return;
        }
        this.getEngineProvider().deleteEngineLibraries(selectedEngine);
        if (selectedEngine.getId().equals("custom_cordova")) {
            List libs = selectedEngine.getPlatformLibs();
            for (PlatformLibrary pl : libs) {
                this.removePathFromPreference(pl.getLocation());
            }
        }
        this.updateAvailableEngines();
        if (checkedEngine != null && checkedEngine == selectedEngine) {
            this.setSelection((ISelection)new StructuredSelection());
        }
    }

    private class CordovaEngineLabelProvider
    extends LabelProvider
    implements ITableLabelProvider,
    IFontProvider {
        private Font boldFont;

        private CordovaEngineLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            switch (columnIndex) {
                case 2: {
                    return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_INFO_TSK");
                }
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            Assert.isTrue((boolean)(element instanceof HybridMobileEngine));
            HybridMobileEngine engine = (HybridMobileEngine)element;
            switch (columnIndex) {
                case 0: {
                    String bind = "{0} [{1}]";
                    if (engine.getId().equals("custom_cordova")) {
                        bind = String.valueOf(bind) + "*";
                    }
                    return NLS.bind((String)bind, (Object[])new String[]{engine.getName(), engine.getVersion()});
                }
                case 1: {
                    List platforms = engine.getPlatformLibs();
                    StringBuilder platformString = new StringBuilder();
                    for (PlatformLibrary lib : platforms) {
                        platformString.append(lib.getPlatformId());
                        platformString.append(' ');
                    }
                    return platformString.toString();
                }
                case 2: {
                    return null;
                }
            }
            Assert.isTrue((boolean)false);
            return null;
        }

        public Font getFont(Object element) {
            if (!AvailableCordovaEnginesSection.this.engineList.getChecked(element)) {
                return null;
            }
            if (this.boldFont == null) {
                FontDescriptor fontDescriptor = JFaceResources.getDialogFontDescriptor();
                fontDescriptor = fontDescriptor.setStyle(1);
                this.boldFont = fontDescriptor.createFont((Device)Display.getCurrent());
            }
            return this.boldFont;
        }
    }

    private static class CordovaEnginesContentProvider
    implements IStructuredContentProvider {
        private List<HybridMobileEngine> engines;

        private CordovaEnginesContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.engines = (List)newInput;
        }

        public Object[] getElements(Object inputElement) {
            if (this.engines == null) {
                return null;
            }
            return this.engines.toArray();
        }
    }

    public static interface EngineListChangeListener {
        public void listChanged();
    }

    private class EngineTooltip
    extends ToolTip {
        private static final int WIDTH_HINT = 340;

        public EngineTooltip(Control control) {
            super(control, 0, true);
        }

        protected Composite createToolTipContentArea(Event event, Composite parent) {
            GridLayoutFactory.fillDefaults().applyTo(parent);
            IStructuredSelection selection = (IStructuredSelection)AvailableCordovaEnginesSection.this.engineList.getSelection();
            HybridMobileEngine selectedEngine = (HybridMobileEngine)selection.getFirstElement();
            Composite container = new Composite(parent, 0);
            container.setBackground(Display.getCurrent().getSystemColor(1));
            GridDataFactory.fillDefaults().grab(true, true).hint(340, -1).applyTo((Control)container);
            GridLayoutFactory.fillDefaults().numColumns(2).margins(5, 5).spacing(3, 0).applyTo(container);
            List libs = selectedEngine.getPlatformLibs();
            for (PlatformLibrary platformLibrary : libs) {
                Label imageLabel = new Label(container, 0);
                PlatformSupport ps = HybridCore.getPlatformSupport((String)platformLibrary.getPlatformId());
                imageLabel.setImage(PlatformImage.getImageFor("platformSupport", ps.getID()));
                Label path = new Label(container, 64);
                GridDataFactory.fillDefaults().align(4, 1).grab(false, false).applyTo((Control)path);
                path.setSize(315, 0);
                path.setText(Dialog.shortenText((String)platformLibrary.getLocation().toString(), (Control)path));
            }
            return container;
        }
    }

    private static class EngineVersionComparator
    extends ViewerComparator {
        private boolean descending = true;

        public EngineVersionComparator(boolean isDescending) {
            this.descending = isDescending;
        }

        public int compare(Viewer viewer, Object o1, Object o2) {
            HybridMobileEngine e1 = (HybridMobileEngine)o1;
            HybridMobileEngine e2 = (HybridMobileEngine)o2;
            Version version1 = Version.valueOf((String)e1.getVersion());
            Version version2 = Version.valueOf((String)e2.getVersion());
            if (this.descending) {
                return version2.compareTo(version1);
            }
            return version1.compareTo(version2);
        }
    }
}

