/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.thym.ui.config.internal;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.Map;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.BeanProperties;
import org.eclipse.core.databinding.beans.BeansObservables;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.databinding.viewers.ObservableMapLabelProvider;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.thym.core.HybridProject;
import org.eclipse.thym.core.config.Access;
import org.eclipse.thym.core.config.Feature;
import org.eclipse.thym.core.config.Preference;
import org.eclipse.thym.core.config.Widget;
import org.eclipse.thym.core.config.WidgetModel;
import org.eclipse.thym.core.plugin.CordovaPlugin;
import org.eclipse.thym.ui.HybridUI;
import org.eclipse.thym.ui.config.internal.AbstactConfigEditorPage;
import org.eclipse.thym.ui.config.internal.ConfigEditor;
import org.eclipse.thym.ui.config.internal.FormUtils;
import org.eclipse.thym.ui.config.internal.NewAccessDialog;
import org.eclipse.thym.ui.config.internal.NewNameValueDialog;
import org.eclipse.thym.ui.plugins.internal.LaunchCordovaPluginWizardAction;
import org.eclipse.thym.ui.plugins.internal.PluginUninstallAction;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.wst.xml.core.internal.cleanup.CleanupProcessorXML;

public class PropertiesPage
extends AbstactConfigEditorPage {
    private static final String BTN_LBL_REMOVE = "Remove";
    private static final String BTN_LBL_ADD = "Add...";
    private DataBindingContext m_bindingContext;
    private FormToolkit formToolkit;
    private Table preferencesTable;
    private Table accessTable;
    private TableViewer preferencesViewer;
    private TableViewer accessViewer;
    private TableViewer featuresTableViewer;
    private Table featuresTable;
    private Table paramsTable;
    private TableViewer featureParamsTableViewer;

    public PropertiesPage(FormEditor editor) {
        super(editor, "properties", "Platform Properties");
        this.formToolkit = editor.getToolkit();
    }

    private Widget getWidget() {
        return ((ConfigEditor)this.getEditor()).getWidget();
    }

    private WidgetModel getWidgetModel() {
        return ((ConfigEditor)this.getEditor()).getWidgetModel();
    }

    @Override
    protected void createFormContent(IManagedForm managedForm) {
        super.createFormContent(managedForm);
        ScrolledForm form = managedForm.getForm();
        this.formToolkit.decorateFormHeading(form.getForm());
        managedForm.getForm().setText(this.getTitle());
        GridLayout formGridLayout = new GridLayout();
        formGridLayout.horizontalSpacing = 20;
        formGridLayout.verticalSpacing = 17;
        formGridLayout.marginBottom = 12;
        formGridLayout.marginTop = 12;
        formGridLayout.marginRight = 6;
        formGridLayout.marginLeft = 6;
        formGridLayout.marginWidth = 0;
        formGridLayout.marginHeight = 0;
        formGridLayout.makeColumnsEqualWidth = true;
        formGridLayout.numColumns = 2;
        Composite body = managedForm.getForm().getBody();
        body.setLayout((Layout)formGridLayout);
        Composite left = this.formToolkit.createComposite(body);
        left.setLayout((Layout)FormUtils.createFormPaneGridLayout(false, 1));
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)left);
        Composite right = this.formToolkit.createComposite(body);
        right.setLayout((Layout)FormUtils.createFormPaneGridLayout(false, 1));
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)right);
        this.createFeaturesSection(left);
        this.createFeatureParamsSection(right);
        this.createPreferencesSection(left);
        this.createAccessSection(right);
        this.m_bindingContext = this.initDataBindings();
        this.selectFirstFeature();
    }

    private void createAccessSection(Composite right) {
        Section sctnAccess = this.formToolkit.createSection(right, 256);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)sctnAccess);
        this.formToolkit.paintBordersFor((Composite)sctnAccess);
        sctnAccess.setText("Access");
        Composite compositea = this.formToolkit.createComposite((Composite)sctnAccess, 64);
        this.formToolkit.paintBordersFor(compositea);
        sctnAccess.setClient((Control)compositea);
        compositea.setLayout((Layout)FormUtils.createSectionClientGridLayout(false, 2));
        this.accessViewer = new TableViewer(compositea, 67584);
        this.accessTable = this.accessViewer.getTable();
        this.accessTable.setLinesVisible(true);
        this.accessTable.setHeaderVisible(true);
        this.formToolkit.paintBordersFor((Composite)this.accessTable);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.accessTable);
        TableViewerColumn tableViewerColumnOrigin = new TableViewerColumn(this.accessViewer, 0);
        TableColumn tblclmnOrigin = tableViewerColumnOrigin.getColumn();
        tblclmnOrigin.setWidth(100);
        tblclmnOrigin.setText("origin");
        TableViewerColumn tableViewerColumnSubdomains = new TableViewerColumn(this.accessViewer, 0);
        TableColumn tblclmnSubdomains = tableViewerColumnSubdomains.getColumn();
        tblclmnSubdomains.setWidth(100);
        tblclmnSubdomains.setText("subdomains");
        TableViewerColumn tableViewerColumnBrowserOnly = new TableViewerColumn(this.accessViewer, 0);
        TableColumn tblclmnNewColumn = tableViewerColumnBrowserOnly.getColumn();
        tblclmnNewColumn.setWidth(100);
        tblclmnNewColumn.setText("browserOnly");
        Composite buttonComposite = this.formToolkit.createComposite(compositea, 0);
        this.formToolkit.paintBordersFor(buttonComposite);
        buttonComposite.setLayoutData((Object)new GridData(1040));
        GridLayoutFactory.swtDefaults().margins(0, 0).applyTo(buttonComposite);
        Button btnAccessAdd = this.createButton(buttonComposite, BTN_LBL_ADD);
        btnAccessAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewAccessDialog dialog = new NewAccessDialog(PropertiesPage.this.getSite().getShell(), PropertiesPage.this.getWidgetModel());
                if (dialog.open() == 0 && dialog.getAccess() != null) {
                    PropertiesPage.this.getWidget().addAccess(dialog.getAccess());
                    PropertiesPage.this.reformatDocument();
                }
            }
        });
        Button btnAccessRemove = this.createButton(buttonComposite, BTN_LBL_REMOVE);
        btnAccessRemove.setEnabled(false);
        btnAccessRemove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)PropertiesPage.this.accessViewer.getSelection();
                if (selection.isEmpty()) {
                    return;
                }
                Access access = (Access)selection.getFirstElement();
                PropertiesPage.this.getWidget().removeAccess(access);
            }
        });
        this.accessViewer.addSelectionChangedListener((ISelectionChangedListener)new ButtonStateUpdater(btnAccessRemove));
    }

    private void createPreferencesSection(Composite left) {
        Section sctnPreferences = this.formToolkit.createSection(left, 256);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)sctnPreferences);
        this.formToolkit.paintBordersFor((Composite)sctnPreferences);
        sctnPreferences.setText("Preferences");
        Composite composite = this.formToolkit.createComposite((Composite)sctnPreferences, 64);
        this.formToolkit.paintBordersFor(composite);
        sctnPreferences.setClient((Control)composite);
        composite.setLayout((Layout)FormUtils.createSectionClientGridLayout(false, 2));
        this.preferencesViewer = new TableViewer(composite, 67584);
        this.preferencesTable = this.preferencesViewer.getTable();
        this.preferencesTable.setLinesVisible(true);
        this.preferencesTable.setHeaderVisible(true);
        this.formToolkit.paintBordersFor((Composite)this.preferencesTable);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.preferencesTable);
        TableViewerColumn tableViewerColumnName = new TableViewerColumn(this.preferencesViewer, 0);
        TableColumn tblclmnName = tableViewerColumnName.getColumn();
        tblclmnName.setWidth(100);
        tblclmnName.setText("name");
        TableViewerColumn tableViewerColumnValue = new TableViewerColumn(this.preferencesViewer, 0);
        TableColumn tblclmnValue = tableViewerColumnValue.getColumn();
        tblclmnValue.setWidth(100);
        tblclmnValue.setText("value");
        Composite buttonComposite = this.formToolkit.createComposite(composite, 0);
        this.formToolkit.paintBordersFor(buttonComposite);
        buttonComposite.setLayoutData((Object)new GridData(1040));
        GridLayoutFactory.swtDefaults().margins(0, 0).applyTo(buttonComposite);
        Button btnPreferenceAdd = this.createButton(buttonComposite, BTN_LBL_ADD);
        btnPreferenceAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewNameValueDialog dialog = new NewNameValueDialog(PropertiesPage.this.getSite().getShell(), "New Preference");
                if (dialog.open() == 0) {
                    Preference pref = PropertiesPage.this.getWidgetModel().createPreference(PropertiesPage.this.getWidget());
                    pref.setName(dialog.getName());
                    pref.setValue(dialog.getValue());
                    PropertiesPage.this.getWidget().addPreference(pref);
                    PropertiesPage.this.reformatDocument();
                }
            }
        });
        Button btnPreferenceRemove = this.createButton(buttonComposite, BTN_LBL_REMOVE);
        btnPreferenceRemove.setEnabled(false);
        btnPreferenceRemove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)PropertiesPage.this.preferencesViewer.getSelection();
                if (selection.isEmpty()) {
                    return;
                }
                Preference preference = (Preference)selection.getFirstElement();
                PropertiesPage.this.getWidget().removePreference(preference);
            }
        });
        this.preferencesViewer.addSelectionChangedListener((ISelectionChangedListener)new ButtonStateUpdater(btnPreferenceRemove));
    }

    private void createFeatureParamsSection(Composite right) {
        Section sctnParams = this.formToolkit.createSection(right, 384);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)sctnParams);
        this.formToolkit.paintBordersFor((Composite)sctnParams);
        sctnParams.setText("Params");
        sctnParams.setDescription("Specify parameters for the selected plug-in");
        Composite paramsComposite = this.formToolkit.createComposite((Composite)sctnParams, 0);
        this.formToolkit.paintBordersFor(paramsComposite);
        sctnParams.setClient((Control)paramsComposite);
        paramsComposite.setLayout((Layout)FormUtils.createSectionClientGridLayout(false, 2));
        this.featureParamsTableViewer = new TableViewer(paramsComposite, 67584);
        this.featuresTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (!(event.getSelection() instanceof IStructuredSelection)) {
                    return;
                }
                IStructuredSelection sel = (IStructuredSelection)event.getSelection();
                if (sel.isEmpty()) {
                    PropertiesPage.this.featureParamsTableViewer.setInput(null);
                    return;
                }
                Feature feature = (Feature)sel.getFirstElement();
                PropertiesPage.this.featureParamsTableViewer.setInput((Object)feature.getParams());
                feature.addPropertyChangeListener("param", new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent event) {
                        PropertiesPage.this.featureParamsTableViewer.setInput(event.getNewValue());
                    }
                });
            }
        });
        this.featureParamsTableViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){
            private Map<String, String> items;

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                this.items = (Map)newInput;
            }

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                if (this.items == null) {
                    return new Object[0];
                }
                return this.items.entrySet().toArray();
            }
        });
        this.paramsTable = this.featureParamsTableViewer.getTable();
        this.paramsTable.setLinesVisible(true);
        this.paramsTable.setHeaderVisible(true);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.paramsTable);
        this.formToolkit.paintBordersFor((Composite)this.paramsTable);
        TableViewerColumn paramTableColumnViewer = new TableViewerColumn(this.featureParamsTableViewer, 0);
        TableColumn tblclmnParamName = paramTableColumnViewer.getColumn();
        tblclmnParamName.setWidth(100);
        tblclmnParamName.setText("name");
        paramTableColumnViewer.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                Map.Entry entry = (Map.Entry)element;
                return (String)entry.getKey();
            }
        });
        paramTableColumnViewer = new TableViewerColumn(this.featureParamsTableViewer, 0);
        TableColumn tblclmnValueColumn = paramTableColumnViewer.getColumn();
        tblclmnValueColumn.setWidth(200);
        tblclmnValueColumn.setText("value");
        paramTableColumnViewer.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                Map.Entry entry = (Map.Entry)element;
                return (String)entry.getValue();
            }
        });
        Composite featureParamBtnsComposite = new Composite(paramsComposite, 0);
        this.formToolkit.adapt(featureParamBtnsComposite);
        this.formToolkit.paintBordersFor(featureParamBtnsComposite);
        featureParamBtnsComposite.setLayoutData((Object)new GridData(1040));
        GridLayoutFactory.swtDefaults().margins(0, 0).applyTo(featureParamBtnsComposite);
        Button btnAdd = this.createButton(featureParamBtnsComposite, BTN_LBL_ADD);
        btnAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection sel = (IStructuredSelection)PropertiesPage.this.featuresTableViewer.getSelection();
                if (sel.isEmpty()) {
                    return;
                }
                NewNameValueDialog dialog = new NewNameValueDialog(PropertiesPage.this.getSite().getShell(), "New Parameter");
                if (dialog.open() == 0) {
                    Feature selectedFeature = (Feature)sel.getFirstElement();
                    selectedFeature.addParam(dialog.getName(), dialog.getValue());
                    PropertiesPage.this.reformatDocument();
                }
            }
        });
        this.featuresTableViewer.addSelectionChangedListener((ISelectionChangedListener)new ButtonStateUpdater(btnAdd));
        Button btnRemove = this.createButton(featureParamBtnsComposite, BTN_LBL_REMOVE);
        btnRemove.setEnabled(false);
        btnRemove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection sel = (IStructuredSelection)PropertiesPage.this.featuresTableViewer.getSelection();
                if (sel.isEmpty()) {
                    return;
                }
                Feature selectedFeature = (Feature)sel.getFirstElement();
                sel = (IStructuredSelection)PropertiesPage.this.featureParamsTableViewer.getSelection();
                Map.Entry param = (Map.Entry)sel.getFirstElement();
                selectedFeature.removeParam((String)param.getKey());
            }
        });
        this.featureParamsTableViewer.addSelectionChangedListener((ISelectionChangedListener)new ButtonStateUpdater(btnRemove));
    }

    private void createFeaturesSection(Composite left) {
        Section sctnFeatures = this.formToolkit.createSection(left, 384);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)sctnFeatures);
        this.formToolkit.paintBordersFor((Composite)sctnFeatures);
        sctnFeatures.setText("Features");
        sctnFeatures.setDescription("Define plug-ins to be used in this application");
        Composite featuresComposite = this.formToolkit.createComposite((Composite)sctnFeatures, 0);
        this.formToolkit.paintBordersFor(featuresComposite);
        sctnFeatures.setClient((Control)featuresComposite);
        featuresComposite.setLayout((Layout)FormUtils.createSectionClientGridLayout(false, 2));
        this.featuresTableViewer = new TableViewer(featuresComposite, 67588);
        this.featuresTable = this.featuresTableViewer.getTable();
        this.featuresTable.setLinesVisible(false);
        this.featuresTable.setHeaderVisible(false);
        GridData featureTableLayoutData = new GridData(4, 4, true, true, 1, 1);
        this.featuresTable.setLayoutData((Object)featureTableLayoutData);
        this.formToolkit.paintBordersFor((Composite)this.featuresTable);
        TableViewerColumn tableViewerColumnURI = new TableViewerColumn(this.featuresTableViewer, 0);
        TableColumn tblclmnFeatureURI = tableViewerColumnURI.getColumn();
        tblclmnFeatureURI.setWidth(200);
        Composite featureBtnsComposite = this.formToolkit.createComposite(featuresComposite, 0);
        this.formToolkit.paintBordersFor(featureBtnsComposite);
        featureBtnsComposite.setLayoutData((Object)new GridData(1040));
        GridLayoutFactory.swtDefaults().margins(0, 0).applyTo(featureBtnsComposite);
        Button btnFeatureAdd = this.createButton(featureBtnsComposite, BTN_LBL_ADD);
        btnFeatureAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LaunchCordovaPluginWizardAction action = new LaunchCordovaPluginWizardAction(PropertiesPage.this.getConfigEditor());
                action.run();
                PropertiesPage.this.selectFirstFeature();
            }
        });
        Button btnFeatureRemove = this.createButton(featureBtnsComposite, BTN_LBL_REMOVE);
        btnFeatureRemove.setEnabled(false);
        btnFeatureRemove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)PropertiesPage.this.featuresTableViewer.getSelection();
                if (selection.isEmpty()) {
                    return;
                }
                Feature feature = (Feature)selection.getFirstElement();
                IResource resource = (IResource)PropertiesPage.this.getEditorInput().getAdapter(IResource.class);
                HybridProject prj = HybridProject.getHybridProject((IProject)resource.getProject());
                boolean pluginFoundAndRemoved = false;
                try {
                    List plugins = prj.getPluginManager().getInstalledPlugins();
                    for (CordovaPlugin cordovaPlugin : plugins) {
                        if (cordovaPlugin.getName() == null || !cordovaPlugin.getName().equals(feature.getName())) continue;
                        PluginUninstallAction action = new PluginUninstallAction(cordovaPlugin);
                        action.run();
                        pluginFoundAndRemoved = true;
                        break;
                    }
                }
                catch (CoreException ex) {
                    HybridUI.log(4, "Error removing the installed plugin", ex);
                }
                if (!pluginFoundAndRemoved) {
                    PropertiesPage.this.getWidget().removeFeature(feature);
                    PropertiesPage.this.featureParamsTableViewer.setInput(null);
                }
                PropertiesPage.this.selectFirstFeature();
            }
        });
        this.featuresTableViewer.addSelectionChangedListener((ISelectionChangedListener)new ButtonStateUpdater(btnFeatureRemove));
    }

    private Button createButton(Composite parent, String label) {
        Button button = this.formToolkit.createButton(parent, label, 0);
        button.setFont(JFaceResources.getDialogFont());
        PixelConverter converter = new PixelConverter((Control)button);
        int widthHint = converter.convertHorizontalDLUsToPixels(61);
        widthHint = Math.max(widthHint, button.computeSize((int)-1, (int)-1, (boolean)true).x);
        GridDataFactory.swtDefaults().align(4, 1).hint(widthHint, -1).applyTo((Control)button);
        return button;
    }

    private void selectFirstFeature() {
        TableItem[] items = this.featuresTable.getItems();
        if (items.length > 0) {
            Object obj = items[0].getData();
            this.featuresTableViewer.setSelection((ISelection)new StructuredSelection(obj));
        }
    }

    protected DataBindingContext initDataBindings() {
        DataBindingContext bindingContext = new DataBindingContext();
        ObservableListContentProvider listContentProvider = new ObservableListContentProvider();
        IObservableMap[] observeMaps = BeansObservables.observeMaps((IObservableSet)listContentProvider.getKnownElements(), Preference.class, (String[])new String[]{"name", "value"});
        this.preferencesViewer.setLabelProvider((IBaseLabelProvider)new ObservableMapLabelProvider(observeMaps));
        this.preferencesViewer.setContentProvider((IContentProvider)listContentProvider);
        IObservableList preferencesGetWidgetObserveList = BeanProperties.list((String)"preferences").observe((Object)this.getWidget());
        this.preferencesViewer.setInput((Object)preferencesGetWidgetObserveList);
        ObservableListContentProvider listContentProvider_1 = new ObservableListContentProvider();
        IObservableMap[] observeMaps_1 = BeansObservables.observeMaps((IObservableSet)listContentProvider_1.getKnownElements(), Access.class, (String[])new String[]{"origin", "subdomains", "browserOnly"});
        this.accessViewer.setLabelProvider((IBaseLabelProvider)new ObservableMapLabelProvider(observeMaps_1));
        this.accessViewer.setContentProvider((IContentProvider)listContentProvider_1);
        IObservableList accessesGetWidgetObserveList = BeanProperties.list((String)"accesses").observe((Object)this.getWidget());
        this.accessViewer.setInput((Object)accessesGetWidgetObserveList);
        ObservableListContentProvider listContentProvider_2 = new ObservableListContentProvider();
        IObservableMap observeMap = BeansObservables.observeMap((IObservableSet)listContentProvider_2.getKnownElements(), Feature.class, (String)"name");
        this.featuresTableViewer.setLabelProvider((IBaseLabelProvider)new ObservableMapLabelProvider(observeMap));
        this.featuresTableViewer.setContentProvider((IContentProvider)listContentProvider_2);
        IObservableList featuresGetWidgetObserveList = BeanProperties.list((String)"features").observe((Object)this.getWidget());
        this.featuresTableViewer.setInput((Object)featuresGetWidgetObserveList);
        return bindingContext;
    }

    private void reformatDocument() {
        CleanupProcessorXML formatter = new CleanupProcessorXML();
        formatter.cleanupModel(this.getWidgetModel().underLyingModel);
    }

    private final class ButtonStateUpdater
    implements ISelectionChangedListener {
        private Button btn;

        public ButtonStateUpdater(Button btn) {
            this.btn = btn;
        }

        public void selectionChanged(SelectionChangedEvent event) {
            this.btn.setEnabled(!event.getSelection().isEmpty());
        }
    }
}

