/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.ws.jaxrs.core;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.JavaCore;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.builder.JavaElementChangedListener;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.builder.ResourceChangedListener;
import org.jboss.tools.ws.jaxrs.core.internal.utils.Logger;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.IJaxrsEndpoint;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.IJaxrsMetamodel;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.IJaxrsMetamodelChangedListener;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.JaxrsEndpointDelta;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.JaxrsMetamodelDelta;
import org.osgi.framework.BundleContext;

public class JBossJaxrsCorePlugin
extends Plugin {
    public static final String PLUGIN_ID = "org.jboss.tools.ws.jaxrs.core";
    private static JBossJaxrsCorePlugin plugin;
    private final JavaElementChangedListener javaElementChangedListener = new JavaElementChangedListener();
    private final ResourceChangedListener resourceChangedListener = new ResourceChangedListener();
    private final Set<IJaxrsMetamodelChangedListener> metamodelChangedListeners = new HashSet<IJaxrsMetamodelChangedListener>();

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        this.registerListeners();
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        this.unregisterListeners();
        super.stop(context);
    }

    private void registerListeners() {
        JavaCore.addElementChangedListener((IElementChangedListener)this.javaElementChangedListener);
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this.resourceChangedListener, 2);
    }

    private void unregisterListeners() {
        JavaCore.removeElementChangedListener((IElementChangedListener)this.javaElementChangedListener);
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.resourceChangedListener);
    }

    public void pauseListeners() {
        this.javaElementChangedListener.pause();
        this.resourceChangedListener.pause();
    }

    public void resumeListeners() {
        this.javaElementChangedListener.resume();
        this.resourceChangedListener.resume();
    }

    public static JBossJaxrsCorePlugin getDefault() {
        return plugin;
    }

    public void addJaxrsMetamodelChangedListener(IJaxrsMetamodelChangedListener listener) {
        if (!this.metamodelChangedListeners.contains(listener)) {
            Logger.debug("Registering JaxrsMetamodelChangedListener");
            this.metamodelChangedListeners.add(listener);
        }
    }

    public void removeListener(IJaxrsMetamodelChangedListener listener) {
        this.metamodelChangedListeners.remove(listener);
    }

    public static void notifyEndpointChanged(IJaxrsEndpoint endpoint, int deltaKind) {
        if (endpoint != null && !JBossJaxrsCorePlugin.getDefault().metamodelChangedListeners.isEmpty()) {
            JaxrsEndpointDelta delta = new JaxrsEndpointDelta(endpoint, deltaKind);
            Logger.trace("Notify elementChangedListeners after {}", delta);
            for (IJaxrsMetamodelChangedListener listener : JBossJaxrsCorePlugin.getDefault().metamodelChangedListeners) {
                listener.notifyEndpointChanged(delta);
            }
        } else if (JBossJaxrsCorePlugin.getDefault().metamodelChangedListeners.isEmpty()) {
            Logger.trace(" No Listener to notify about endpoint changed (type={}): {}", deltaKind, endpoint);
        }
    }

    public static void notifyEndpointProblemLevelChanged(IJaxrsEndpoint endpoint) {
        Logger.debug("Notifying that problem severity changed to {} for endpoint {} {}", endpoint.getProblemLevel(), endpoint.getHttpMethod().getHttpVerb(), endpoint.getUriPathTemplate());
        for (IJaxrsMetamodelChangedListener listener : JBossJaxrsCorePlugin.getDefault().metamodelChangedListeners) {
            listener.notifyEndpointProblemLevelChanged(endpoint);
        }
    }

    public static void notifyMetamodelProblemLevelChanged(IJaxrsMetamodel metamodel) {
        if (JBossJaxrsCorePlugin.getDefault().metamodelChangedListeners.isEmpty()) {
            Logger.debug("No metamodelChangedListeners to notify that the metamodel problem level changed :(");
            return;
        }
        for (IJaxrsMetamodelChangedListener listener : JBossJaxrsCorePlugin.getDefault().metamodelChangedListeners) {
            listener.notifyMetamodelProblemLevelChanged(metamodel);
        }
    }

    public static void notifyMetamodelChanged(IJaxrsMetamodel metamodel, int deltaKind) {
        if (JBossJaxrsCorePlugin.getDefault().metamodelChangedListeners.isEmpty()) {
            Logger.debug("No metamodelChangedListener to notify of the metamodel changed :(");
            return;
        }
        for (IJaxrsMetamodelChangedListener listener : JBossJaxrsCorePlugin.getDefault().metamodelChangedListeners) {
            listener.notifyMetamodelChanged(new JaxrsMetamodelDelta(metamodel, deltaKind));
        }
    }
}

