/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.ws.ui.views;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import javax.wsdl.Definition;
import javax.wsdl.WSDLException;
import org.jboss.tools.ws.ui.JBossWSUIPlugin;
import org.jboss.tools.ws.ui.utils.TesterWSDLUtils;

public class TestHistoryEntry
implements Cloneable {
    private String url;
    private String action;
    private String body;
    private String method = "GET";
    private String headers;
    private String parms;
    private String[] resultHeadersList;
    private String resultText;
    private String wsTech;
    private String serviceName;
    private String portName;
    private String bindingName;
    private String operationName;
    private Definition wsdlDef = null;
    private String[] serviceNSMessage = null;
    private boolean isSOAP12 = false;

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setResultHeadersList(String[] resultHeadersList) {
        this.resultHeadersList = resultHeadersList == null ? new String[0] : Arrays.copyOf(resultHeadersList, resultHeadersList.length);
    }

    public String[] getResultHeadersList() {
        return this.resultHeadersList;
    }

    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public String getBody() {
        return this.body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public String getHeaders() {
        return this.headers;
    }

    public void setHeaders(String headers) {
        this.headers = headers;
    }

    public String getParms() {
        return this.parms;
    }

    public void setParms(String parms) {
        this.parms = parms;
    }

    public void setResultText(String resultText) {
        this.resultText = resultText;
    }

    public String getResultText() {
        return this.resultText;
    }

    public void setWsTech(String wsTech) {
        this.wsTech = wsTech;
    }

    public String getWsTech() {
        return this.wsTech;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public String getPortName() {
        return this.portName;
    }

    public void setPortName(String portName) {
        this.portName = portName;
    }

    public String getBindingName() {
        return this.bindingName;
    }

    public void setBindingName(String bindingName) {
        this.bindingName = bindingName;
    }

    public String getOperationName() {
        return this.operationName;
    }

    public void setOperationName(String operationName) {
        this.operationName = operationName;
    }

    public void setWsdlDef(Definition wsdlDef) {
        this.wsdlDef = wsdlDef;
    }

    public Definition getWsdlDef() {
        if (this.wsdlDef == null && this.url != null && this.url.length() > 0) {
            try {
                URL tempURL = new URL(this.url);
                this.wsdlDef = TesterWSDLUtils.readWSDLURL(tempURL);
            }
            catch (MalformedURLException e) {
                JBossWSUIPlugin.log(e);
                return null;
            }
            catch (WSDLException e) {
                JBossWSUIPlugin.log(e);
                return null;
            }
        }
        return this.wsdlDef;
    }

    public void setServiceNSMessage(String[] serviceNSMessage) {
        this.serviceNSMessage = serviceNSMessage == null ? new String[0] : Arrays.copyOf(serviceNSMessage, serviceNSMessage.length);
    }

    public String[] getServiceNSMessage() {
        return this.serviceNSMessage;
    }

    public void setSOAP12(boolean isSOAP12) {
        this.isSOAP12 = isSOAP12;
    }

    public boolean isSOAP12() {
        return this.isSOAP12;
    }

    public String toString() {
        return "TestHistoryEntry [url=" + this.url + ", action=" + this.action + ", body=" + this.body + ", method=" + this.method + ", headers=" + this.headers + ", parms=" + this.parms + ", resultHeadersList=" + Arrays.toString(this.resultHeadersList) + ", resultText=" + this.resultText + ", wsTech=" + this.wsTech + ", serviceName=" + this.serviceName + ", portName=" + this.portName + ", bindingName=" + this.bindingName + ", operationName=" + this.operationName + ", wsdlDef=" + this.wsdlDef + ", serviceNSMessage=" + Arrays.toString(this.serviceNSMessage) + ", isSOAP12=" + this.isSOAP12 + "]";
    }

    protected Object clone() throws CloneNotSupportedException {
        TestHistoryEntry newEntry = new TestHistoryEntry();
        newEntry.setAction(this.getAction());
        newEntry.setBindingName(this.getBindingName());
        newEntry.setBody(this.getBody());
        newEntry.setHeaders(this.getHeaders());
        newEntry.setMethod(this.getMethod());
        newEntry.setOperationName(this.getOperationName());
        newEntry.setParms(this.getParms());
        newEntry.setPortName(this.getPortName());
        newEntry.setResultHeadersList(this.getResultHeadersList());
        newEntry.setResultText(this.getResultText());
        newEntry.setServiceName(this.getServiceName());
        newEntry.setServiceNSMessage(this.getServiceNSMessage());
        newEntry.setSOAP12(this.isSOAP12());
        newEntry.setUrl(this.getUrl());
        newEntry.setWsTech(this.getWsTech());
        return newEntry;
    }
}

