/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.ws.ui.utils;

import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.BitSet;

public class URIEncoder {
    static BitSet dontNeedEncoding;
    static final int caseDiff = 32;
    static String dfltEncName;

    static {
        dfltEncName = null;
        dontNeedEncoding = new BitSet(256);
        int i = 97;
        while (i <= 122) {
            dontNeedEncoding.set(i);
            ++i;
        }
        i = 65;
        while (i <= 90) {
            dontNeedEncoding.set(i);
            ++i;
        }
        i = 48;
        while (i <= 57) {
            dontNeedEncoding.set(i);
            ++i;
        }
        dontNeedEncoding.set(45);
        dontNeedEncoding.set(95);
        dontNeedEncoding.set(46);
        dontNeedEncoding.set(42);
        dontNeedEncoding.set(58);
        dontNeedEncoding.set(47);
        dfltEncName = "UTF8";
    }

    private URIEncoder() {
    }

    public static String encode(String s) {
        String str = null;
        try {
            str = URIEncoder.encode(s, dfltEncName);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {}
        return str;
    }

    public static String encode(String s, String enc) throws UnsupportedEncodingException {
        boolean needToChange = false;
        boolean wroteUnencodedChar = false;
        int maxBytesPerChar = 10;
        StringBuffer out = new StringBuffer(s.length());
        ByteArrayOutputStream buf = new ByteArrayOutputStream(maxBytesPerChar);
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)buf, enc));
        int i = 0;
        while (i < s.length()) {
            block10: {
                char c = s.charAt(i);
                if (dontNeedEncoding.get(c)) {
                    out.append(c);
                    wroteUnencodedChar = true;
                } else {
                    try {
                        char d;
                        if (wroteUnencodedChar) {
                            writer = new BufferedWriter(new OutputStreamWriter((OutputStream)buf, enc));
                            wroteUnencodedChar = false;
                        }
                        writer.write(c);
                        if (c >= '\ud800' && c <= '\udbff' && i + 1 < s.length() && (d = s.charAt(i + 1)) >= '\udc00' && d <= '\udfff') {
                            writer.write(d);
                            ++i;
                        }
                        writer.flush();
                    }
                    catch (IOException iOException) {
                        buf.reset();
                        break block10;
                    }
                    byte[] ba = buf.toByteArray();
                    int j = 0;
                    while (j < ba.length) {
                        out.append('%');
                        char ch = Character.forDigit(ba[j] >> 4 & 0xF, 16);
                        if (Character.isLetter(ch)) {
                            ch = (char)(ch - 32);
                        }
                        out.append(ch);
                        ch = Character.forDigit(ba[j] & 0xF, 16);
                        if (Character.isLetter(ch)) {
                            ch = (char)(ch - 32);
                        }
                        out.append(ch);
                        ++j;
                    }
                    buf.reset();
                    needToChange = true;
                }
            }
            ++i;
        }
        return needToChange ? out.toString() : s;
    }
}

