/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.ws.ui.preferences;

import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.jboss.tools.common.ui.widget.editor.BaseFieldEditor;
import org.jboss.tools.common.ui.widget.editor.ButtonFieldEditor;
import org.jboss.tools.common.ui.widget.editor.IFieldEditor;
import org.jboss.tools.common.ui.widget.editor.IFieldEditorFactory;
import org.jboss.tools.ws.core.classpath.JBossWSRuntime;
import org.jboss.tools.ws.core.classpath.JBossWSRuntimeManager;
import org.jboss.tools.ws.ui.messages.JBossWSUIMessages;
import org.jboss.tools.ws.ui.preferences.JBossWSLibraryListFieldEditor;
import org.jboss.tools.ws.ui.utils.JBossWSUIUtils;

public class JBossWSRuntimeListFieldEditor
extends BaseFieldEditor {
    static final int GL_COLUMNS = 2;
    static final int GL_HINT_HEIGHT = 200;
    static final int TC_DEFAULT_WIDTH = 21;
    static final int TC_NAME_WIDTH = 100;
    static final int TC_VERSION_WIDTH = 50;
    static final int TC_PATH_WIDTH = 100;
    private CheckboxTableViewer tableView = null;
    private Composite root = null;
    private ActionPanel actionPanel;
    private Map<JBossWSRuntime, JBossWSRuntime> changed = new HashMap<JBossWSRuntime, JBossWSRuntime>();
    private JBossWSRuntime checkedElement = new JBossWSRuntime();
    private List<JBossWSRuntime> added = new ArrayList<JBossWSRuntime>();
    private List<JBossWSRuntime> removed = new ArrayList<JBossWSRuntime>();

    public JBossWSRuntimeListFieldEditor(String name, String label, Object defaultValue) {
        super(name, label, defaultValue);
    }

    public JBossWSRuntime getDefaultJBossWSRuntime() {
        return this.checkedElement;
    }

    public void setDefaultJBossWSRuntime(JBossWSRuntime rt) {
        this.checkedElement = rt;
    }

    public List<JBossWSRuntime> getAddedJBossWSRuntimes() {
        return this.added;
    }

    public Map<JBossWSRuntime, JBossWSRuntime> getChangedJBossWSRuntimes() {
        return this.changed;
    }

    public List<JBossWSRuntime> getRemoved() {
        return this.removed;
    }

    public Object[] getEditorControls(Object composite) {
        this.root = new Composite((Composite)composite, 0);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.root.setLayoutData((Object)gd);
        this.root.setLayout((Layout)new FormLayout());
        this.createTableView();
        this.createActionBar();
        FormData tableData = new FormData();
        tableData.left = new FormAttachment(0, 5);
        tableData.right = new FormAttachment((Control)this.actionPanel, -5);
        tableData.top = new FormAttachment(0, 5);
        tableData.bottom = new FormAttachment(100, -5);
        this.tableView.getControl().setLayoutData((Object)tableData);
        FormData actionsData = new FormData();
        actionsData.top = new FormAttachment(0, 5);
        actionsData.bottom = new FormAttachment(100, -5);
        actionsData.right = new FormAttachment(100, -5);
        this.actionPanel.setLayoutData(actionsData);
        return new Control[]{this.root};
    }

    protected void createTableView() {
        this.tableView = CheckboxTableViewer.newCheckList((Composite)this.root, (int)68100);
        TableColumn tc1 = new TableColumn(this.tableView.getTable(), 0x1000000);
        tc1.setWidth(21);
        tc1.setResizable(false);
        TableColumn tc2 = new TableColumn(this.tableView.getTable(), 16384);
        tc2.setWidth(100);
        tc2.setText(JBossWSUIMessages.JBossWS_Runtime_List_Field_Editor_Name);
        TableColumn tc3 = new TableColumn(this.tableView.getTable(), 16384);
        tc3.setWidth(50);
        tc3.setText(JBossWSUIMessages.JBossWS_Runtime_List_Field_Editor_Version);
        TableColumn tc4 = new TableColumn(this.tableView.getTable(), 16384);
        tc4.setWidth(100);
        tc4.setText(JBossWSUIMessages.JBossWS_Runtime_List_Field_Editor_Path);
        this.tableView.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof List) {
                    return ((List)inputElement).toArray();
                }
                throw new IllegalArgumentException(JBossWSUIMessages.Error_JBossWS_Runtime_List_Field_Editor_Inputelement_Must_Be_An_Instance_Of_List);
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                viewer.refresh();
            }
        });
        this.tableView.setLabelProvider((IBaseLabelProvider)new ITableLabelProvider(){
            private static final int TC_DEFAULT_NUMBER = 0;
            private static final int TC_NAME_NUMBER = 1;
            private static final int TC_VERSION_NUMBER = 2;
            private static final int TC_PATH_NUMBER = 3;

            public void addListener(ILabelProviderListener listener) {
            }

            public void dispose() {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void removeListener(ILabelProviderListener listener) {
            }

            public Image getColumnImage(Object element, int columnIndex) {
                return null;
            }

            public String getColumnText(Object element, int columnIndex) {
                JBossWSRuntime rt = (JBossWSRuntime)element;
                if (columnIndex == 0) {
                    return "";
                }
                if (columnIndex == 1) {
                    return rt.getName();
                }
                if (columnIndex == 2) {
                    return rt.getVersion().toString();
                }
                if (columnIndex == 3) {
                    return rt.getHomeDir();
                }
                return "";
            }
        });
        this.tableView.setInput(this.getValue());
        this.tableView.getTable().setLinesVisible(true);
        this.tableView.getTable().setHeaderVisible(true);
        this.tableView.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                JBossWSRuntime selRt = (JBossWSRuntime)event.getElement();
                if (event.getChecked()) {
                    JBossWSRuntime deselRt = null;
                    Object[] selRts = JBossWSRuntimeListFieldEditor.this.tableView.getCheckedElements();
                    int i = 0;
                    while (i < selRts.length) {
                        JBossWSRuntime rt = (JBossWSRuntime)selRts[i];
                        if (rt != selRt) {
                            deselRt = rt;
                            break;
                        }
                        ++i;
                    }
                    if (deselRt != null) {
                        Object[] newChecked = new Object[selRts.length - 1];
                        JBossWSRuntimeListFieldEditor.this.checkedElement = null;
                        int i2 = 0;
                        Object[] objectArray = selRts;
                        int n = selRts.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Object object = objectArray[n2];
                            JBossWSRuntime rt = (JBossWSRuntime)object;
                            if (rt == selRt) {
                                newChecked[i2] = rt;
                                JBossWSRuntimeListFieldEditor.this.checkedElement = rt;
                                ++i2;
                            }
                            ++n2;
                        }
                        JBossWSRuntimeListFieldEditor.this.tableView.setCheckedElements(newChecked);
                    } else {
                        JBossWSRuntimeListFieldEditor.this.checkedElement = (JBossWSRuntime)event.getElement();
                    }
                } else if (JBossWSRuntimeListFieldEditor.this.checkedElement == selRt) {
                    JBossWSRuntimeListFieldEditor.this.checkedElement = null;
                }
                JBossWSRuntimeListFieldEditor.this.pcs.firePropertyChange(JBossWSRuntimeListFieldEditor.this.getName(), null, JBossWSRuntimeListFieldEditor.this.getValue());
            }
        });
        for (JBossWSRuntime rt : (List)this.getValue()) {
            if (!rt.isDefault()) continue;
            this.tableView.setChecked((Object)rt, true);
            this.checkedElement = rt;
        }
    }

    protected void createActionBar() {
        this.actionPanel = new ActionPanel(this.root, new BaseAction[]{new AddAction(), new EditAction(), new RemoveAction()});
        this.tableView.addSelectionChangedListener((ISelectionChangedListener)this.actionPanel);
    }

    private void setDefaultRuntime() {
        List runtimes = (List)this.getValue();
        boolean checked = false;
        for (JBossWSRuntime jbossWSRuntime : runtimes) {
            if (this.checkedElement != jbossWSRuntime) continue;
            checked = true;
            this.tableView.setChecked((Object)this.checkedElement, true);
            break;
        }
        if (!(checked || runtimes.size() <= 0 || this.tableView.getCheckedElements() != null && this.tableView.getCheckedElements().length != 0)) {
            this.tableView.setChecked(runtimes.get(0), true);
            this.checkedElement = (JBossWSRuntime)runtimes.get(0);
        }
    }

    public Object[] getEditorControls() {
        return new Control[]{this.root};
    }

    public int getNumberOfControls() {
        return 1;
    }

    public void doFillIntoGrid(Object parent) {
        Assert.isTrue((boolean)(parent instanceof Composite), (String)JBossWSUIMessages.Error_JBossWS_Basic_Editor_Composite);
        Assert.isTrue((boolean)(((Composite)parent).getLayout() instanceof GridLayout), (String)JBossWSUIMessages.Error_JBossWS_Basic_Editor_Support);
        Composite aComposite = (Composite)parent;
        this.getEditorControls(aComposite);
        GridLayout gl = (GridLayout)((Composite)parent).getLayout();
        GridData gd = new GridData();
        gd.horizontalSpan = gl.numColumns;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        ((Control)this.getEditorControls()[0]).setLayoutData((Object)gd);
    }

    public CheckboxTableViewer getTableView() {
        return this.tableView;
    }

    public static class ActionButton
    implements IPropertyChangeListener {
        private Button button;
        private BaseAction action;

        public ActionButton(Composite parent, int style, BaseAction action) {
            this.button = new Button(parent, style);
            this.action = action;
            GridData gd = new GridData(768, 2, false, false);
            gd.horizontalAlignment = 4;
            gd.verticalAlignment = 2;
            this.button.setLayoutData((Object)gd);
            this.action.addPropertyChangeListener(this);
            this.button.setText(action.getText());
            this.button.setEnabled(action.isEnabled());
            this.button.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    ActionButton.this.action.run();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
        }

        public Control getControl() {
            return this.button;
        }

        public void propertyChange(PropertyChangeEvent event) {
            if (event.getProperty().equals("enabled")) {
                this.button.setEnabled(((Boolean)event.getNewValue()).booleanValue());
            }
        }
    }

    public static class ActionPanel
    extends Composite
    implements ISelectionChangedListener {
        private BaseAction[] actions = null;

        public ActionPanel(Composite parent, int style, BaseAction[] actions) {
            super(parent, style);
            this.actions = actions == null ? new BaseAction[0] : Arrays.copyOf(actions, actions.length);
            this.setLayout((Layout)new GridLayout(1, false));
            BaseAction[] baseActionArray = this.actions;
            int n = this.actions.length;
            int n2 = 0;
            while (n2 < n) {
                BaseAction action = baseActionArray[n2];
                new ActionButton(this, 8, action);
                ++n2;
            }
        }

        public ActionPanel(Composite parent, BaseAction[] actions) {
            this(parent, 0, actions);
        }

        public void selectionChanged(SelectionChangedEvent event) {
            BaseAction[] baseActionArray = this.actions;
            int n = this.actions.length;
            int n2 = 0;
            while (n2 < n) {
                BaseAction action = baseActionArray[n2];
                action.setSelection(event.getSelection());
                ++n2;
            }
        }
    }

    public class AddAction
    extends BaseAction {
        public AddAction() {
            super(JBossWSUIMessages.JBossRuntimeListFieldEditor_ActionAdd);
            this.setEnabled(true);
        }

        @Override
        protected void updateEnablement() {
        }

        public void run() {
            JBossWSRuntimeNewWizard wiz = new JBossWSRuntimeNewWizard((List)JBossWSRuntimeListFieldEditor.this.getValue(), JBossWSRuntimeListFieldEditor.this.added);
            WizardDialog dialog = new WizardDialog(Display.getCurrent().getActiveShell(), (IWizard)wiz);
            dialog.open();
            JBossWSRuntimeListFieldEditor.this.tableView.refresh();
            JBossWSRuntimeListFieldEditor.this.setDefaultRuntime();
        }
    }

    public abstract class BaseAction
    extends Action {
        JBossWSRuntime[] runtimes;

        public BaseAction(String name) {
            super(name);
            this.runtimes = new JBossWSRuntime[0];
            this.updateEnablement();
        }

        public void setSelection(ISelection selection) {
            if (selection instanceof IStructuredSelection) {
                ArrayList<JBossWSRuntime> rts = new ArrayList<JBossWSRuntime>();
                Object[] objectArray = ((IStructuredSelection)selection).toArray();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object rt = objectArray[n2];
                    rts.add((JBossWSRuntime)rt);
                    ++n2;
                }
                this.runtimes = rts.toArray(new JBossWSRuntime[0]);
            } else {
                this.runtimes = new JBossWSRuntime[0];
            }
            this.updateEnablement();
        }

        protected abstract void updateEnablement();
    }

    public class EditAction
    extends BaseAction {
        public EditAction() {
            super(JBossWSUIMessages.JBossRuntimeListFieldEditor_ActionEdit);
        }

        @Override
        protected void updateEnablement() {
            this.setEnabled(this.runtimes.length == 1);
        }

        public void run() {
            JBossWSRuntime selected = this.runtimes[0];
            JBossWSRuntimeEditWizard wiz = new JBossWSRuntimeEditWizard((List)JBossWSRuntimeListFieldEditor.this.getValue(), this.runtimes[0], JBossWSRuntimeListFieldEditor.this.added, JBossWSRuntimeListFieldEditor.this.changed);
            WizardDialog dialog = new WizardDialog(Display.getCurrent().getActiveShell(), (IWizard)wiz);
            dialog.open();
            JBossWSRuntimeListFieldEditor.this.tableView.refresh();
            JBossWSRuntime c = null;
            if (JBossWSRuntimeListFieldEditor.this.changed.containsValue(selected) && (c = this.findChangedRuntime(selected)) != null) {
                JBossWSRuntimeListFieldEditor.this.tableView.setSelection((ISelection)new StructuredSelection((Object)c));
            }
            if (c != null && c.isDefault()) {
                JBossWSRuntimeListFieldEditor.this.checkedElement = c;
            }
            JBossWSRuntimeListFieldEditor.this.setDefaultRuntime();
        }

        private JBossWSRuntime findChangedRuntime(JBossWSRuntime source) {
            for (JBossWSRuntime r : JBossWSRuntimeListFieldEditor.this.changed.keySet()) {
                if (source != JBossWSRuntimeListFieldEditor.this.changed.get(r)) continue;
                return r;
            }
            return null;
        }
    }

    public static class JBossWSRuntimeEditWizard
    extends Wizard {
        JBossWSRuntimeWizardPage page1 = null;
        List<JBossWSRuntime> added = null;
        Map<JBossWSRuntime, JBossWSRuntime> changed = null;
        List<JBossWSRuntime> value = null;
        JBossWSRuntime source = null;

        public JBossWSRuntimeEditWizard(List<JBossWSRuntime> existing, JBossWSRuntime source, List<JBossWSRuntime> added, Map<JBossWSRuntime, JBossWSRuntime> changed) {
            this.setWindowTitle(JBossWSUIMessages.JBossWS_Runtime_List_Field_Editor_Edit_Runtime);
            this.page1 = new JBossWSRuntimeWizardPage(existing);
            this.page1.setMessage(JBossWSUIMessages.JBossWS_Runtime_List_Field_Editor_Modify_Runtime);
            this.page1.setTitle(JBossWSUIMessages.JBossWS_Runtime_List_Field_Editor_Edit_Runtime);
            this.addPage((IWizardPage)this.page1);
            this.value = existing;
            this.added = added;
            this.changed = changed;
            this.source = source;
            this.page1.name.setValue((Object)source.getName());
            this.page1.version.setValue((Object)source.getVersion());
            this.page1.homeDir.setValue((Object)source.getHomeDir());
            this.page1.current = source;
        }

        public boolean performFinish() {
            JBossWSRuntime rt = this.page1.getRuntime();
            if (this.added.contains(this.source) || this.changed.containsKey(this.source)) {
                this.source.setName(rt.getName());
                this.source.setHomeDir(rt.getHomeDir());
                this.source.setVersion(rt.getVersion());
                this.source.setUserConfigClasspath(rt.isUserConfigClasspath());
                this.source.setLibraries(rt.getLibraries());
                this.source.setImpl(rt.getImpl());
                this.source.setVersionDetail(rt.getVersionDetail());
            } else {
                int i;
                this.changed.put(rt, this.source);
                if (this.source.isDefault()) {
                    rt.setDefault(true);
                }
                if ((i = this.value.indexOf(this.source)) >= 0) {
                    this.value.set(i, rt);
                } else {
                    this.value.remove(this.source);
                    this.value.add(rt);
                }
            }
            return true;
        }
    }

    public static class JBossWSRuntimeNewWizard
    extends Wizard {
        JBossWSRuntimeWizardPage page1 = null;
        List<JBossWSRuntime> added = null;
        List<JBossWSRuntime> value = null;

        public JBossWSRuntimeNewWizard(List<JBossWSRuntime> exist, List<JBossWSRuntime> added) {
            this.setWindowTitle(JBossWSUIMessages.JBossWS_Runtime_List_Field_Editor_New_Runtime);
            this.page1 = new JBossWSRuntimeWizardPage(exist);
            this.addPage((IWizardPage)this.page1);
            this.value = exist;
            this.added = added;
        }

        public boolean performFinish() {
            JBossWSRuntime rt = this.page1.getRuntime();
            this.added.add(rt);
            this.value.add(rt);
            return true;
        }

        protected JBossWSRuntime getRuntime() {
            return this.page1.getRuntime();
        }
    }

    public static class JBossWSRuntimeWizardPage
    extends WizardPage
    implements PropertyChangeListener {
        private static final String SRT_NAME = "name";
        private static final String SRT_VERSION = "version";
        private static final String SRT_HOMEDIR = "homeDir";
        private static final int GL_PARENT_COLUMNS = 1;
        private static final int GL_CONTENT_COLUMNS = 3;
        List<JBossWSRuntime> value = null;
        IFieldEditor name = IFieldEditorFactory.INSTANCE.createTextEditor("name", JBossWSUIMessages.JBossWS_Runtime_List_Field_Editor_Name2, "");
        IFieldEditor version = IFieldEditorFactory.INSTANCE.createComboEditor("version", JBossWSUIMessages.JBossWS_Runtime_List_Field_Editor_Version, this.getWSFacetVersions(), (Object)"");
        IFieldEditor homeDir = IFieldEditorFactory.INSTANCE.createBrowseFolderEditor("homeDir", JBossWSUIMessages.JBossWS_Runtime_List_Field_Editor_Home_Folder, "");
        Label impl;
        Label vDetail;
        JBossWSRuntime current = null;
        IFieldEditor jars = null;

        public JBossWSRuntimeWizardPage(List<JBossWSRuntime> editedList) {
            super(JBossWSUIMessages.JBossWS_Runtime_List_Field_Editor_New_Runtime);
            this.setMessage(JBossWSUIMessages.JBossWS_Runtime_List_Field_Editor_Create_A_Runtime);
            this.setTitle(JBossWSUIMessages.JBossWS_Runtime_List_Field_Editor_Runtime);
            this.value = editedList;
        }

        public void createControl(Composite parent) {
            parent.setLayout((Layout)new GridLayout(1, false));
            GridData dg = new GridData();
            dg.horizontalAlignment = 4;
            dg.grabExcessHorizontalSpace = true;
            Composite root = new Composite(parent, 0);
            root.setLayoutData((Object)dg);
            GridLayout gl = new GridLayout(3, false);
            root.setLayout((Layout)gl);
            this.name.doFillIntoGrid((Object)root);
            this.name.addPropertyChangeListener((PropertyChangeListener)this);
            this.version.doFillIntoGrid((Object)root);
            this.version.addPropertyChangeListener((PropertyChangeListener)this);
            if (this.current != null) {
                this.version.setValue((Object)this.current.getVersion());
            } else {
                this.version.setValue((Object)this.getWSFacetVersions().get(1));
            }
            this.homeDir.doFillIntoGrid((Object)root);
            this.homeDir.addPropertyChangeListener((PropertyChangeListener)this);
            Label[] texts = JBossWSUIUtils.createWSRuntimeDetailsGroup(root, 3);
            this.impl = texts[0];
            this.vDetail = texts[1];
            if (this.current != null) {
                this.impl.setText(this.current.getImpl());
                this.vDetail.setText(this.current.getVersionDetail());
            }
            this.jars = new JBossWSLibraryListFieldEditor("", "", this.current);
            this.jars.doFillIntoGrid((Object)root);
            this.jars.addPropertyChangeListener((PropertyChangeListener)this);
            this.setPageComplete(false);
            this.setControl((Control)root);
        }

        @Override
        public void propertyChange(java.beans.PropertyChangeEvent evt) {
            if (SRT_HOMEDIR.equals(evt.getPropertyName()) && (this.name.getValueAsString() == null || "".equals(this.name.getValueAsString().trim()) || this.getErrorMessage() != null)) {
                String homeDirName = this.homeDir.getValueAsString();
                if (homeDirName != null && !"".equals(homeDirName.trim())) {
                    File folder = new File(homeDirName);
                    homeDirName = folder.getName();
                }
                this.name.setValue((Object)homeDirName);
            }
            if (this.name.getValueAsString() == null || "".equals(this.name.getValueAsString().toString().trim())) {
                this.setErrorMessage(JBossWSUIMessages.Error_JBossWS_Runtime_List_Field_Editor_Name_Cannot_Be_Empty);
                this.setPageComplete(false);
                return;
            }
            if (!this.name.getValueAsString().matches("[a-zA-Z_][a-zA-Z0-9_\\-\\. ]*")) {
                this.setErrorMessage(JBossWSUIMessages.Error_JBossWS_Runtime_List_Field_Editor_Runtime_Name_Is_Not_Correct);
                this.setPageComplete(false);
                return;
            }
            for (JBossWSRuntime rt : this.value) {
                if (this.current != null && this.current.getName().equals(rt.getName()) || !rt.getName().equals(this.name.getValueAsString())) continue;
                this.setErrorMessage(NLS.bind((String)JBossWSUIMessages.JBossWS_Runtime_List_Field_Editor_Runtime_Already_Exists, (Object)this.name.getValueAsString()));
                this.setPageComplete(false);
                return;
            }
            if (this.jars != null) {
                JBossWSRuntime jarJbws = (JBossWSRuntime)this.jars.getValue();
                if (this.current != null && this.current.getName().equals(this.name.getValueAsString()) && this.current.getHomeDir().equals(this.homeDir.getValueAsString()) && this.current.getVersion().equals(this.version.getValueAsString()) && this.current.isUserConfigClasspath() == jarJbws.isUserConfigClasspath() && (!jarJbws.isUserConfigClasspath() || this.hasSameLibraies(this.current.getLibraries(), jarJbws.getLibraries()))) {
                    this.setErrorMessage(null);
                    this.setPageComplete(false);
                    return;
                }
                if (jarJbws.isUserConfigClasspath() && jarJbws.getLibraries().size() == 0) {
                    this.setErrorMessage(JBossWSUIMessages.JBossRuntimeListFieldEditor_ErrorMessageAtLeastOneJar);
                    this.setPageComplete(false);
                    return;
                }
            }
            if (this.homeDir.getValueAsString() == null || "".equals(this.homeDir.getValueAsString().trim())) {
                this.setErrorMessage(JBossWSUIMessages.Error_JBossWS_Runtime_List_Field_Editor_Path_To_Home_Diretory_Cannot_Be_Empty);
                this.setPageComplete(false);
                return;
            }
            if (!this.runtimeExist(this.homeDir.getValueAsString())) {
                this.setErrorMessage(JBossWSUIMessages.Error_JBossWS_Label_Runtime_Load);
                this.setPageComplete(false);
                return;
            }
            if (SRT_HOMEDIR.equals(evt.getPropertyName())) {
                String[] strs = JBossWSUIUtils.getWSRuntimeDetail(this.homeDir.getValueAsString());
                this.impl.setText(strs[0]);
                this.vDetail.setText(strs[1]);
            }
            this.setErrorMessage(null);
            this.setPageComplete(true);
        }

        private boolean hasSameLibraies(List<String> lib1, List<String> lib2) {
            if (lib1.size() != lib2.size()) {
                return false;
            }
            for (String jar : lib1) {
                if (lib2.contains(jar)) continue;
                return false;
            }
            return true;
        }

        private List<String> getWSFacetVersions() {
            ArrayList<String> versions = new ArrayList<String>();
            IProjectFacet wsFacet = ProjectFacetsManager.getProjectFacet((String)"jbossws.core");
            for (IProjectFacetVersion version : wsFacet.getVersions()) {
                versions.add(version.getVersionString());
            }
            return versions;
        }

        public JBossWSRuntime getRuntime() {
            JBossWSRuntime newRt = new JBossWSRuntime();
            newRt.setName(this.name.getValueAsString());
            newRt.setVersion(this.version.getValueAsString());
            newRt.setHomeDir(this.homeDir.getValueAsString());
            newRt.setImpl(this.impl.getText());
            newRt.setVersionDetail(this.vDetail.getText());
            JBossWSRuntime rt = (JBossWSRuntime)this.jars.getValue();
            newRt.setLibraries(rt.getLibraries());
            newRt.setUserConfigClasspath(rt.isUserConfigClasspath());
            return newRt;
        }

        public ButtonFieldEditor.ButtonPressedAction createSelectFolderAction(String buttonName) {
            return new ButtonFieldEditor.ButtonPressedAction(buttonName){

                public void run() {
                    DirectoryDialog dialog = new DirectoryDialog(Display.getCurrent().getActiveShell());
                    dialog.setFilterPath(this.getFieldEditor().getValueAsString());
                    dialog.setMessage(JBossWSUIMessages.JBossWS_SWT_Field_Editor_Factory_Select_Home_Folder);
                    dialog.setFilterPath(this.getFieldEditor().getValueAsString());
                    String directory = dialog.open();
                    if (directory != null) {
                        this.getFieldEditor().setValue((Object)directory);
                    }
                }
            };
        }

        private boolean runtimeExist(String path) {
            File jbosswsHomeDir = new File(path);
            if (!jbosswsHomeDir.isDirectory()) {
                return false;
            }
            String[] newNode = new String[]{JBossWSUIMessages.Bin, JBossWSUIMessages.Command};
            String jbosswsBinPath = JBossWSUIUtils.addNodesToPath(jbosswsHomeDir.getAbsolutePath(), newNode);
            return new File(jbosswsBinPath).isFile();
        }
    }

    public class RemoveAction
    extends BaseAction {
        public RemoveAction() {
            super(JBossWSUIMessages.JBossRuntimeListFieldEditor_ActionRemove);
        }

        @Override
        protected void updateEnablement() {
            this.setEnabled(this.runtimes.length > 0);
        }

        public void run() {
            JBossWSRuntime[] jBossWSRuntimeArray = this.runtimes;
            int n = this.runtimes.length;
            int n2 = 0;
            while (n2 < n) {
                JBossWSRuntime rt = jBossWSRuntimeArray[n2];
                this.removeRuntime(rt);
                ++n2;
            }
            JBossWSRuntimeListFieldEditor.this.tableView.refresh();
            JBossWSRuntimeListFieldEditor.this.setDefaultRuntime();
        }

        private void removeRuntime(JBossWSRuntime r) {
            boolean used = JBossWSRuntimeManager.isRuntimeUsed((String)r.getName());
            String title = JBossWSUIMessages.JBossWS_Runtime_Delete_Confirm_Title;
            String message = used ? NLS.bind((String)JBossWSUIMessages.JBossWS_Runtime_Delete_Used_Confirm, (Object)r.getName()) : NLS.bind((String)JBossWSUIMessages.JBossWS_Runtime_Delete_Not_Used_Confirm, (Object)r.getName());
            boolean b = MessageDialog.openConfirm((Shell)JBossWSRuntimeListFieldEditor.this.tableView.getControl().getShell(), (String)title, (String)message);
            if (b) {
                if (JBossWSRuntimeListFieldEditor.this.changed.containsKey(r)) {
                    r = (JBossWSRuntime)JBossWSRuntimeListFieldEditor.this.changed.remove(r);
                }
                JBossWSRuntimeListFieldEditor.this.removed.add(r);
                if (JBossWSRuntimeListFieldEditor.this.added.contains(r)) {
                    JBossWSRuntimeListFieldEditor.this.added.remove(r);
                }
                ((List)JBossWSRuntimeListFieldEditor.this.getValue()).remove(r);
            }
            if (JBossWSRuntimeListFieldEditor.this.checkedElement == r) {
                JBossWSRuntimeListFieldEditor.this.checkedElement = null;
            }
        }
    }
}

