/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.resref.core;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.jboss.tools.common.model.ui.action.CommandBar;
import org.jboss.tools.common.model.ui.action.CommandBarListener;
import org.jboss.tools.common.model.ui.objecteditor.XTable;
import org.jboss.tools.common.model.ui.objecteditor.XTableProvider;
import org.jboss.tools.common.resref.core.ResourceReference;
import org.jboss.tools.common.resref.core.ResourceReferenceList;
import org.jboss.tools.common.resref.ui.ResourceReferencesTableProvider;
import org.jboss.tools.vpe.resref.core.Messages;
import org.jboss.tools.vpe.resref.core.ReferenceWizardDialog;

public abstract class AbstractResourceReferencesComposite {
    protected static String ADD = Messages.VRD_LABEL_ADD;
    protected static String EDIT = Messages.VRD_LABEL_EDIT;
    protected static String REMOVE = Messages.VRD_LABEL_REMOVE;
    protected XTable table = new XTable();
    protected CommandBar bar = new CommandBar();
    protected ResourceReferencesTableProvider tableProvider;
    protected Object fileLocation = null;
    protected List dataList = new ArrayList();

    public AbstractResourceReferencesComposite() {
        this.init();
    }

    private void init() {
        this.tableProvider = this.createTableProvider(this.dataList);
        this.bar.getLayout().buttonWidth = 80;
        this.bar.getLayout().direction = 512;
        this.bar.setCommands(new String[]{ADD, EDIT, REMOVE});
        this.bar.addCommandBarListener((CommandBarListener)new BarListener());
        this.table.setTableProvider((XTableProvider)this.tableProvider);
    }

    protected abstract ResourceReferencesTableProvider createTableProvider(List var1);

    protected abstract ResourceReferenceList getReferenceList();

    protected abstract ReferenceWizardDialog getDialog(ResourceReference var1);

    public void setObject(Object fileLocation) {
        this.fileLocation = fileLocation;
        ResourceReference[] rs = null;
        if (fileLocation != null) {
            if (fileLocation instanceof IFile) {
                rs = this.getReferenceList().getAllResources((IFile)fileLocation);
            } else if (fileLocation instanceof IPath) {
                rs = this.getReferenceList().getAllResources((IPath)fileLocation);
            }
        } else {
            rs = new ResourceReference[]{};
        }
        int i = 0;
        while (i < rs.length) {
            this.dataList.add(rs[i]);
            ++i;
        }
    }

    public Control createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(1808));
        GridLayout g = new GridLayout(2, false);
        composite.setLayout((Layout)g);
        Control slc = this.table.createControl(composite);
        slc.setLayoutData((Object)new GridData(1808));
        Control bc = this.bar.createControl(composite);
        GridData gd = new GridData(1040);
        bc.setLayoutData((Object)gd);
        this.table.getTable().addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                AbstractResourceReferencesComposite.this.updateBars();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.update();
        return composite;
    }

    protected ResourceReference[] getReferenceArray() {
        return this.dataList.toArray(new ResourceReference[0]);
    }

    public void clearAll() {
        if (this.dataList != null) {
            this.dataList.clear();
        }
    }

    public void commit() {
        if (this.fileLocation != null) {
            if (this.fileLocation instanceof IFile) {
                this.getReferenceList().setAllResources((IFile)this.fileLocation, this.getReferenceArray());
            } else if (this.fileLocation instanceof IPath) {
                this.getReferenceList().setAllResources((IPath)this.fileLocation, this.getReferenceArray());
            }
        }
    }

    protected abstract void add(int var1);

    protected ResourceReference getDefaultResourceReference() {
        return new ResourceReference("", 1);
    }

    protected abstract void edit(int var1);

    void remove(int index) {
        if (index >= 0) {
            this.dataList.remove(index);
        }
    }

    public void update() {
        if (this.table != null) {
            this.table.update();
        }
        this.updateBars();
    }

    protected void updateBars() {
        boolean canModify = this.table.getSelectionIndex() >= 0;
        this.bar.setEnabled(EDIT, canModify);
        this.bar.setEnabled(REMOVE, canModify);
    }

    public class BarListener
    implements CommandBarListener {
        public void action(String command) {
            int index = AbstractResourceReferencesComposite.this.table.getSelectionIndex();
            if (ADD.equals(command)) {
                AbstractResourceReferencesComposite.this.add(index);
            } else if (EDIT.equals(command)) {
                AbstractResourceReferencesComposite.this.edit(index);
            } else if (REMOVE.equals(command)) {
                AbstractResourceReferencesComposite.this.remove(index);
            }
            AbstractResourceReferencesComposite.this.update();
        }
    }
}

