/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.central.internal.dnd;

import java.lang.reflect.Field;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.HTMLTransfer;
import org.eclipse.swt.dnd.TransferData;
import org.jboss.tools.central.JBossCentralActivator;

public class LinuxURLTransfer
extends ByteArrayTransfer {
    static LinuxURLTransfer _instance = new LinuxURLTransfer();
    private static final String URI_LIST = "text/uri-list";
    private static final int URI_LIST_ID = LinuxURLTransfer.registerType((String)"text/uri-list");
    private static final String TEXT_HTML = "text/html";
    private static final int TEXT_HTML_ID = LinuxURLTransfer.registerType((String)"text/html");

    private LinuxURLTransfer() {
    }

    public static LinuxURLTransfer getInstance() {
        return _instance;
    }

    public void javaToNative(Object object, TransferData transferData) {
        if (LinuxURLTransfer.isLinuxGTK()) {
            try {
                transferData.type = TEXT_HTML_ID;
                HTMLTransfer.getInstance().javaToNative(object, transferData);
            }
            finally {
                transferData.type = URI_LIST_ID;
            }
        }
    }

    public Object nativeToJava(TransferData transferData) {
        if (transferData == null) {
            return null;
        }
        Object object = null;
        if (LinuxURLTransfer.isLinuxGTK()) {
            Class<?> clazz = null;
            Field typeField = null;
            try {
                clazz = transferData.getClass();
                typeField = clazz.getDeclaredField("type");
                if (this.setType(typeField, transferData, TEXT_HTML_ID)) {
                    object = HTMLTransfer.getInstance().nativeToJava(transferData);
                    this.setType(typeField, transferData, URI_LIST_ID);
                }
            }
            catch (Exception e) {
                JBossCentralActivator.log("Can not convert data to URL : " + e.getLocalizedMessage());
            }
        }
        return object;
    }

    private boolean setType(Field typeField, TransferData transferData, int type) throws NoSuchFieldException, IllegalAccessException {
        if (typeField.getType().equals(Integer.TYPE)) {
            typeField.setInt(transferData, type);
            return true;
        }
        if (typeField.getType().equals(Long.TYPE)) {
            typeField.setLong(transferData, type);
            return true;
        }
        return false;
    }

    protected int[] getTypeIds() {
        return new int[]{URI_LIST_ID};
    }

    public TransferData[] getSupportedTypes() {
        if (!LinuxURLTransfer.isLinuxGTK()) {
            return new TransferData[0];
        }
        return super.getSupportedTypes();
    }

    public boolean isSupportedType(TransferData transferData) {
        if (!LinuxURLTransfer.isLinuxGTK()) {
            return false;
        }
        return super.isSupportedType(transferData);
    }

    protected String[] getTypeNames() {
        if (!LinuxURLTransfer.isLinuxGTK()) {
            return new String[0];
        }
        return new String[]{URI_LIST};
    }

    boolean checkURL(Object object) {
        return object instanceof String && ((String)object).length() > 0;
    }

    protected boolean validate(Object object) {
        return this.checkURL(object);
    }

    public static boolean isLinuxGTK() {
        return "linux".equals(Platform.getOS()) && "gtk".equals(Platform.getWS());
    }
}

