/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.central.installation;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.jboss.tools.central.JBossCentralActivator;

public class BundleFamilyExtension {
    private String id;
    private String label;
    private URL defaultListingFileResource;
    private String url;

    public BundleFamilyExtension(String id, String label, URL defaultListingFileResource, String url) {
        this.id = id;
        this.label = label;
        this.defaultListingFileResource = defaultListingFileResource;
        this.url = url;
    }

    public Map<String, Set<VersionRange>> loadBundleList() {
        InputStream stream = null;
        if (this.url != null) {
            try {
                URL toLoadURL = new URL(this.url);
                stream = this.loadStream(toLoadURL);
            }
            catch (MalformedURLException ex) {
                JBossCentralActivator.log(ex);
            }
        }
        if (stream == null && (stream = this.loadStream(this.defaultListingFileResource)) == null) {
            return Collections.emptyMap();
        }
        Properties props = new Properties();
        try {
            props.load(stream);
        }
        catch (IOException ex) {
            JBossCentralActivator.log(ex);
        }
        this.closeStream(stream);
        HashMap<String, Set<VersionRange>> res = new HashMap<String, Set<VersionRange>>();
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            String id = (String)entry.getKey();
            String rangeAsString = (String)entry.getValue();
            HashSet<VersionRange> ranges = new HashSet<VersionRange>();
            String[] stringArray = rangeAsString.split(";");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String rangeString = stringArray[n2];
                VersionRange range = new VersionRange(rangeString);
                ranges.add(range);
                ++n2;
            }
            res.put(id, ranges);
        }
        return res;
    }

    private InputStream loadStream(URL url) {
        try {
            return url.openStream();
        }
        catch (IOException ex) {
            JBossCentralActivator.log(ex);
            return null;
        }
    }

    private void closeStream(InputStream stream) {
        try {
            stream.close();
        }
        catch (IOException ex) {
            JBossCentralActivator.log(ex);
        }
    }
}

