/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.central.editors.xpl.filters;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.jboss.tools.central.Messages;
import org.jboss.tools.central.editors.xpl.filters.UserFilterEntry;

public class FiltersSelectionDialog
extends Dialog {
    private Collection<UserFilterEntry> filters;
    private Set<UserFilterEntry> toggledFilters;

    public FiltersSelectionDialog(Shell parentShell, Collection<UserFilterEntry> filters) {
        super(parentShell);
        this.filters = filters;
        this.toggledFilters = new HashSet<UserFilterEntry>();
    }

    public Control createDialogArea(Composite parent) {
        this.getShell().setText(Messages.DiscoveryViewer_FilterSelectionDialog_title);
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        Label label = new Label(composite, 0);
        label.setText(Messages.DiscoveryViewer_FilterSelectionDialog_label);
        for (final UserFilterEntry filter : this.filters) {
            final Button checkbox = new Button(composite, 32);
            checkbox.setText(filter.getLabel());
            checkbox.setSelection(filter.isEnabled());
            checkbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (checkbox.getSelection() == filter.isEnabled()) {
                        FiltersSelectionDialog.this.toggledFilters.remove(filter);
                    } else {
                        FiltersSelectionDialog.this.toggledFilters.add(filter);
                    }
                }
            });
            GridData layoutData = new GridData();
            layoutData.horizontalIndent = 15;
            checkbox.setLayoutData((Object)layoutData);
        }
        return composite;
    }

    public Set<UserFilterEntry> getToggledFilters() {
        return this.toggledFilters;
    }
}

