/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.central.editors.xpl;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.bindings.keys.ParseException;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.fieldassist.ContentProposal;
import org.eclipse.jface.fieldassist.ContentProposalAdapter;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.mylyn.internal.commons.workbench.Messages;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleControlAdapter;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleControlListener;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.jboss.tools.central.JBossCentralActivator;

public class TextSearchControl
extends Composite {
    private static final int MAX_PROPOSAL_ITEMS = 50;
    private static final String CLEAR_ICON = "org.eclipse.ui.internal.dialogs.CLEAR_ICON";
    private static final String FIND_ICON = "org.eclipse.ui.internal.dialogs.FIND_ICON";
    private static final String SEARCH_SECTION = "searchSection";
    private static final String SEARCH_KEY = "searchKey";
    public static final int ICON_SEARCH = 512;
    public static final int ICON_CANCEL = 256;
    private static final String INITIAL_MESSAGE = "initialMessage";
    private Text textControl;
    private Control clearControl;
    private Control findControl;
    private final Set<SelectionListener> selectionListeners = new HashSet<SelectionListener>();
    private static Boolean useNativeSearchField;
    private String initialMessage;
    private String[] proposals;

    static {
        ImageDescriptor descriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.ui", (String)"$nl$/icons/full/etool16/clear_co.gif");
        if (descriptor != null) {
            JFaceResources.getImageRegistry().put(CLEAR_ICON, descriptor);
        }
        if ((descriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.mylyn.commons.ui", (String)"$nl$/icons/etool16/find.png")) != null) {
            JFaceResources.getImageRegistry().put(FIND_ICON, descriptor);
        }
    }

    public TextSearchControl(Composite parent, boolean automaticFind) {
        super(parent, TextSearchControl.getCompositeStyle(automaticFind, parent));
        String message;
        KeyStroke stroke;
        int textStyle = 4;
        int numColumns = 1;
        if (TextSearchControl.useNativeSearchField(automaticFind, parent)) {
            textStyle = automaticFind ? (textStyle |= 0x180) : (textStyle |= 0x380);
        } else {
            super.setBackground(this.getDisplay().getSystemColor(25));
            super.setFont(parent.getFont());
            numColumns = 2;
            if (!automaticFind) {
                ++numColumns;
            }
        }
        GridLayoutFactory.swtDefaults().margins(0, 0).extendedMargins(0, 0, 0, 0).spacing(0, 1).numColumns(numColumns).applyTo((Composite)this);
        this.textControl = new Text((Composite)this, textStyle);
        GridData gridData = new GridData(4, 4, true, true);
        this.textControl.setLayoutData((Object)gridData);
        String proposalKey = null;
        try {
            stroke = KeyStroke.getInstance((String)"M1+SPACE");
            proposalKey = stroke.format();
        }
        catch (ParseException e1) {
            JBossCentralActivator.log(e1);
        }
        stroke = null;
        ControlDecoration dec = new ControlDecoration((Control)this.textControl, 16512);
        FieldDecorationRegistry registry = FieldDecorationRegistry.getDefault();
        FieldDecoration fd = registry.getFieldDecoration("DEC_CONTENT_PROPOSAL");
        dec.setImage(fd.getImage());
        String description = proposalKey == null ? fd.getDescription() : String.valueOf(fd.getDescription()) + "(" + proposalKey + ")";
        dec.setDescriptionText(description);
        dec.setImage(FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_CONTENT_PROPOSAL").getImage());
        dec.setShowOnlyOnFocus(true);
        dec.setShowHover(true);
        ContentProposalAdapter adapter = new ContentProposalAdapter((Control)this.textControl, (IControlContentAdapter)new TextContentAdapter(), (IContentProposalProvider)new SearchContentProposalProvider(), null, null);
        adapter.setPropagateKeys(true);
        adapter.setProposalAcceptanceStyle(2);
        if (useNativeSearchField == null || !useNativeSearchField.booleanValue()) {
            this.findControl = this.createLabelButtonControl(this, JFaceResources.getImageRegistry().getDescriptor(FIND_ICON), Messages.TextControl_AccessibleListenerFindButton, Messages.TextControl_FindToolTip, 512);
            Point size = this.findControl.computeSize(-1, -1);
            GridData data = (GridData)this.textControl.getLayoutData();
            data.heightHint = size.y;
            this.clearControl = this.createLabelButtonControl(this, JFaceResources.getImageRegistry().getDescriptor(CLEAR_ICON), WorkbenchMessages.FilteredTree_ClearToolTip, WorkbenchMessages.FilteredTree_ClearToolTip, 256);
            this.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    TextSearchControl.this.updateButtonVisibilityAndEnablement();
                }
            });
            this.updateButtonVisibilityAndEnablement();
        }
        IDialogSettings section = this.getSearchSettings();
        this.proposals = section.getArray(SEARCH_KEY);
        if (this.proposals == null) {
            this.proposals = new String[0];
            section.put(SEARCH_KEY, this.proposals);
        }
        if ((message = section.get(INITIAL_MESSAGE)) == null || message.isEmpty()) {
            message = "Search JBoss Community";
        }
        this.setInitialMessage(message);
        this.registerListeners();
    }

    private void registerListeners() {
        this.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                if (TextSearchControl.this.textControl != null && !TextSearchControl.this.textControl.isDisposed()) {
                    TextSearchControl.this.addSearchSettings();
                }
            }
        });
        this.textControl.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                if (TextSearchControl.this.textControl != null && !TextSearchControl.this.textControl.isDisposed()) {
                    if (TextSearchControl.this.textControl.getText().isEmpty()) {
                        TextSearchControl.this.setInitialMessage(TextSearchControl.this.initialMessage);
                    }
                    TextSearchControl.this.updateButtonVisibilityAndEnablement();
                }
            }
        });
    }

    private static int getCompositeStyle(boolean automaticFind, Composite parent) {
        if (TextSearchControl.useNativeSearchField(automaticFind, parent)) {
            return 0;
        }
        return 2048;
    }

    private static boolean useNativeSearchField(boolean automaticFind, Composite parent) {
        if (parent != null) {
            if (useNativeSearchField == null) {
                useNativeSearchField = Boolean.FALSE;
                Text testText = null;
                try {
                    int style = 384;
                    if (automaticFind) {
                        style |= 0x200;
                    }
                    useNativeSearchField = new Boolean(((testText = new Text(parent, style)).getStyle() & 0x100) != 0 && (!automaticFind || (testText.getStyle() & 0x200) != 0));
                }
                finally {
                    if (testText != null) {
                        testText.dispose();
                    }
                }
            }
        } else {
            useNativeSearchField = Boolean.FALSE;
        }
        return useNativeSearchField;
    }

    private Control createLabelButtonControl(Composite parent, ImageDescriptor activeImageDescriptor, final String accessibilityText, String toolTipText, final int detail) {
        Image inactiveImage;
        final Image nativeImage = parent.getDisplay().getSystemImage(detail);
        final Image activeImage = nativeImage != null ? nativeImage : activeImageDescriptor.createImage();
        final Image pressedImage = inactiveImage = new Image((Device)parent.getDisplay(), activeImage, 2);
        final Label labelButton = new Label(parent, 0);
        labelButton.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        labelButton.setImage(inactiveImage);
        labelButton.setBackground(parent.getDisplay().getSystemColor(25));
        labelButton.setToolTipText(toolTipText);
        labelButton.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (nativeImage == null && activeImage != null && !activeImage.isDisposed()) {
                    activeImage.dispose();
                }
                if (inactiveImage != null && !inactiveImage.isDisposed()) {
                    inactiveImage.dispose();
                }
                if (pressedImage != null && !pressedImage.isDisposed()) {
                    pressedImage.dispose();
                }
            }
        });
        labelButton.addMouseListener((MouseListener)new MouseAdapter(){
            private MouseMoveListener fMoveListener;

            public void mouseDown(MouseEvent e) {
                labelButton.setImage(pressedImage);
                this.fMoveListener = new MouseMoveListener(){
                    private boolean fMouseInButton = true;

                    public void mouseMove(MouseEvent e) {
                        boolean mouseInButton = this.isMouseInButton(e);
                        if (mouseInButton != this.fMouseInButton) {
                            this.fMouseInButton = mouseInButton;
                            labelButton.setImage(mouseInButton ? pressedImage : inactiveImage);
                        }
                    }
                };
                labelButton.addMouseMoveListener(this.fMoveListener);
            }

            public void mouseUp(MouseEvent e) {
                if (this.fMoveListener != null) {
                    labelButton.removeMouseMoveListener(this.fMoveListener);
                    this.fMoveListener = null;
                    boolean mouseInButton = this.isMouseInButton(e);
                    labelButton.setImage(mouseInButton ? activeImage : inactiveImage);
                    if (mouseInButton && TextSearchControl.this.textControl != null && TextSearchControl.this.textControl.isEnabled() && TextSearchControl.this.textControl.getText().length() > 0) {
                        TextSearchControl.this.notifySelectionChanged(detail);
                    }
                }
            }

            private boolean isMouseInButton(MouseEvent e) {
                Point buttonSize = labelButton.getSize();
                return e.x >= 0 && e.x < buttonSize.x && e.y >= 0 && e.y < buttonSize.y;
            }
        });
        labelButton.addMouseTrackListener(new MouseTrackListener(){

            public void mouseEnter(MouseEvent e) {
                if (labelButton.getImage() != activeImage) {
                    labelButton.setImage(activeImage);
                }
            }

            public void mouseExit(MouseEvent e) {
                if (labelButton.getImage() != inactiveImage) {
                    labelButton.setImage(inactiveImage);
                }
            }

            public void mouseHover(MouseEvent e) {
            }
        });
        labelButton.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = accessibilityText;
            }
        });
        labelButton.getAccessible().addAccessibleControlListener((AccessibleControlListener)new AccessibleControlAdapter(){

            public void getRole(AccessibleControlEvent e) {
                e.detail = 43;
            }
        });
        return labelButton;
    }

    public void addTraverseListener(TraverseListener listener) {
        this.textControl.addTraverseListener(listener);
    }

    public void removeTraverseListener(TraverseListener listener) {
        this.textControl.removeTraverseListener(listener);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.textControl.addSelectionListener(listener);
        this.selectionListeners.add(listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.textControl.removeSelectionListener(listener);
        this.selectionListeners.remove(listener);
    }

    public void addModifyListener(ModifyListener listener) {
        this.textControl.addModifyListener(listener);
    }

    public void removeModifyListener(ModifyListener listener) {
        this.textControl.removeModifyListener(listener);
    }

    private void notifySelectionChanged(int detail) {
        if (useNativeSearchField != null && useNativeSearchField.booleanValue()) {
            return;
        }
        Event event = new Event();
        event.detail = detail;
        event.widget = this.textControl;
        event.display = this.textControl.getDisplay();
        SelectionEvent e = new SelectionEvent(event);
        for (SelectionListener element : this.selectionListeners) {
            element.widgetDefaultSelected(e);
        }
    }

    private void updateButtonVisibilityAndEnablement() {
        if (this.textControl != null && !this.textControl.isDisposed()) {
            boolean hasText = this.textControl.getText().length() > 0;
            this.setFindButtonVisibility(hasText);
            this.setClearButtonVisibility(hasText);
        }
    }

    private void setFindButtonVisibility(boolean visible) {
        if (this.findControl != null && !this.findControl.isDisposed()) {
            this.findControl.setVisible(visible);
            if (this.findControl.getLayoutData() instanceof GridData) {
                ((GridData)this.findControl.getLayoutData()).exclude = !visible;
                this.findControl.getParent().layout();
            }
        }
    }

    private void setClearButtonVisibility(boolean visible) {
        if (this.clearControl != null && !this.clearControl.isDisposed()) {
            this.clearControl.setVisible(visible);
            if (this.clearControl.getLayoutData() instanceof GridData) {
                ((GridData)this.clearControl.getLayoutData()).exclude = !visible;
                this.clearControl.getParent().layout();
            }
        }
    }

    public Text getTextControl() {
        return this.textControl;
    }

    public String getText() {
        if (this.textControl != null && !this.textControl.isDisposed()) {
            return this.textControl.getText();
        }
        return "";
    }

    public void setText(String text) {
        if (this.textControl != null && !this.textControl.isDisposed()) {
            this.textControl.setText(text);
        }
    }

    public void setBackground(Color color) {
        if (useNativeSearchField != null && useNativeSearchField.booleanValue()) {
            super.setBackground(color);
        }
    }

    public String getInitialMessage() {
        return this.initialMessage;
    }

    public void setInitialMessage(String initialMessage) {
        this.initialMessage = initialMessage;
        if (this.textControl != null && !this.textControl.isDisposed() && this.textControl.getText().isEmpty()) {
            this.textControl.setMessage(initialMessage);
            IDialogSettings section = this.getSearchSettings();
            section.put(INITIAL_MESSAGE, initialMessage);
        }
    }

    private IDialogSettings getSearchSettings() {
        IDialogSettings settings = JBossCentralActivator.getDefault().getDialogSettings();
        IDialogSettings section = settings.getSection(SEARCH_SECTION);
        if (section == null) {
            section = settings.addNewSection(SEARCH_SECTION);
        }
        return section;
    }

    private void addSearchSettings() {
        String text = this.textControl.getText().trim();
        if (!text.isEmpty()) {
            boolean found = false;
            String[] stringArray = this.proposals;
            int n = this.proposals.length;
            int n2 = 0;
            while (n2 < n) {
                String proposal = stringArray[n2];
                if (text.equals(proposal)) {
                    found = true;
                    break;
                }
                ++n2;
            }
            if (!found) {
                int length = this.proposals.length;
                if (length > 50) {
                    length = 50;
                }
                String[] newProposals = new String[length + 1];
                System.arraycopy(this.proposals, 0, newProposals, 1, length);
                newProposals[0] = text;
                this.proposals = newProposals;
                IDialogSettings section = this.getSearchSettings();
                section.put(SEARCH_KEY, this.proposals);
            }
        }
    }

    private class SearchContentProposalProvider
    implements IContentProposalProvider {
        private SearchContentProposalProvider() {
        }

        public IContentProposal[] getProposals(String contents, int position) {
            if (contents != null) {
                if (position > 0) {
                    contents = contents.substring(0, position);
                }
                contents = contents.trim();
            }
            ArrayList<ContentProposal> contentProposals = new ArrayList<ContentProposal>();
            String[] stringArray = TextSearchControl.this.proposals;
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String proposal = stringArray[n2];
                if (proposal != null && proposal.startsWith(contents)) {
                    contentProposals.add(new ContentProposal(proposal));
                }
                ++n2;
            }
            return contentProposals.toArray(new IContentProposal[0]);
        }
    }
}

