/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.central.editors;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.jboss.tools.central.JBossCentralActivator;
import org.osgi.framework.Bundle;

public class RefreshIndicator
extends Canvas {
    protected Image[] images;
    protected Image image;
    protected Thread busyThread;
    protected boolean stop;

    public RefreshIndicator(Composite parent, String imagePath, int style) throws IOException {
        super(parent, style);
        this.images = this.getImages(parent, imagePath);
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent event) {
                RefreshIndicator.this.onPaint(event);
            }
        });
        this.image = this.images[0];
    }

    private Image[] getImages(Composite parent, String imagePath) throws IOException {
        ImageLoader loader = new ImageLoader();
        Bundle bundle = JBossCentralActivator.getDefault().getBundle();
        URL entry = bundle.getEntry(imagePath);
        Image[] images = null;
        InputStream is = null;
        try {
            is = entry.openStream();
            ImageData[] datas = loader.load(is);
            images = new Image[datas.length];
            int i = 0;
            ImageData[] imageDataArray = datas;
            int n = datas.length;
            int n2 = 0;
            while (n2 < n) {
                ImageData data = imageDataArray[n2];
                images[i++] = new Image((Device)parent.getDisplay(), data);
                ++n2;
            }
        }
        catch (Throwable throwable) {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception exception) {}
            }
            throw throwable;
        }
        if (is != null) {
            try {
                is.close();
            }
            catch (Exception exception) {}
        }
        return images;
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        return new Point(25, 25);
    }

    protected synchronized void createBusyThread() {
        if (this.busyThread != null) {
            return;
        }
        this.stop = false;
        this.busyThread = new Thread(){
            protected int count;

            @Override
            public void run() {
                try {
                    final int maxCount = RefreshIndicator.this.images.length;
                    this.count = 1;
                    while (!RefreshIndicator.this.stop) {
                        Display.getDefault().syncExec(new Runnable(){

                            @Override
                            public void run() {
                                if (RefreshIndicator.this.isDisposed() || RefreshIndicator.this.getParent() == null || RefreshIndicator.this.getParent().isDisposed()) {
                                    RefreshIndicator.this.setBusy(false);
                                    return;
                                }
                                if (!RefreshIndicator.this.getParent().isVisible()) {
                                    return;
                                }
                                if (!(this).RefreshIndicator.this.stop) {
                                    if (count < maxCount) {
                                        RefreshIndicator.this.setImage((this).RefreshIndicator.this.images[count]);
                                    }
                                    ++count;
                                    if (count > maxCount - 1) {
                                        count = 1;
                                    }
                                }
                            }
                        });
                        try {
                            2.sleep(125L);
                        }
                        catch (Exception exception) {}
                    }
                    if (RefreshIndicator.this.busyThread == null) {
                        Display.getDefault().syncExec((Runnable)new Thread(){

                            @Override
                            public void run() {
                                RefreshIndicator.this.setImage((this).RefreshIndicator.this.images[0]);
                            }
                        });
                    }
                }
                catch (Exception e) {
                    JBossCentralActivator.log(e);
                }
            }
        };
        this.busyThread.setPriority(7);
        this.busyThread.setDaemon(true);
        this.busyThread.start();
    }

    public void dispose() {
        this.stop = true;
        this.busyThread = null;
        if (this.images != null) {
            Image[] imageArray = this.images;
            int n = this.images.length;
            int n2 = 0;
            while (n2 < n) {
                Image image = imageArray[n2];
                image.dispose();
                ++n2;
            }
        }
        super.dispose();
    }

    public Image getImage() {
        return this.image;
    }

    public boolean isBusy() {
        return this.busyThread != null;
    }

    protected void onPaint(PaintEvent event) {
        Rectangle rect = this.getClientArea();
        if (rect.width == 0 || rect.height == 0) {
            return;
        }
        GC gc = event.gc;
        if (this.image != null) {
            gc.drawImage(this.image, 2, 2);
        }
    }

    public synchronized void setBusy(boolean busy) {
        if (busy) {
            if (this.busyThread == null) {
                this.createBusyThread();
            }
        } else if (this.busyThread != null) {
            this.stop = true;
            this.busyThread = null;
        }
    }

    public void setImage(Image image) {
        if (image != this.image && !this.isDisposed()) {
            this.image = image;
            this.redraw();
        }
    }

    public void setVisible(boolean visible) {
        this.setBusy(visible);
        super.setVisible(visible);
    }
}

