/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.ws.creation.core.utils;

import java.io.File;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import javax.wsdl.Definition;
import javax.wsdl.WSDLException;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IParent;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.ModuleCoreNature;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IRuntimeType;
import org.eclipse.wst.server.core.ServerCore;
import org.jboss.ide.eclipse.as.core.util.IJBossToolingConstants;
import org.jboss.tools.ws.core.classpath.JBossWSRuntime;
import org.jboss.tools.ws.core.classpath.JBossWSRuntimeManager;
import org.jboss.tools.ws.core.facet.delegate.IJBossWSFacetDataModelProperties;
import org.jboss.tools.ws.core.utils.StatusUtils;
import org.jboss.tools.ws.creation.core.JBossWSCreationCorePlugin;
import org.jboss.tools.ws.creation.core.messages.JBossWSCreationCoreMessages;

public class JBossWSCreationUtils {
    static final String[] javaKeyWords = new String[]{"abstract", "assert", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "do", "double", "else", "extends", "false", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "null", "package", "private", "protected", "public", "return", "short", "static", "strictfp", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "true", "try", "void", "volatile", "while"};
    static final String WEBINF = "WEB-INF";
    private static String JAVA = ".java";

    public static boolean isJavaKeyword(String keyword) {
        if (JBossWSCreationUtils.hasUpperCase(keyword)) {
            return false;
        }
        return Arrays.binarySearch(javaKeyWords, keyword, Collator.getInstance(Locale.ENGLISH)) >= 0;
    }

    private static boolean hasUpperCase(String nodeName) {
        if (nodeName == null) {
            return false;
        }
        int i = 0;
        while (i < nodeName.length()) {
            if (Character.isUpperCase(nodeName.charAt(i))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static IProject getProjectByName(String project) {
        String projectString = JBossWSCreationUtils.replaceEscapecharactors(project);
        return ResourcesPlugin.getWorkspace().getRoot().getProject(JBossWSCreationUtils.getProjectNameFromFramewokNameString(projectString));
    }

    public static IPath getProjectRoot(String project) {
        String projectString = JBossWSCreationUtils.replaceEscapecharactors(project);
        return ResourcesPlugin.getWorkspace().getRoot().getProject(JBossWSCreationUtils.getProjectNameFromFramewokNameString(projectString)).getLocation();
    }

    private static String replaceEscapecharactors(String vulnarableString) {
        if (vulnarableString.indexOf("/") != -1) {
            vulnarableString = vulnarableString.replace('/', File.separator.charAt(0));
        }
        return vulnarableString;
    }

    private static String getProjectNameFromFramewokNameString(String frameworkProjectString) {
        if (frameworkProjectString.indexOf(JBossWSCreationUtils.getSplitCharactor()) == -1) {
            return frameworkProjectString;
        }
        return frameworkProjectString.split(JBossWSCreationUtils.getSplitCharactors())[1];
    }

    private static String getSplitCharactor() {
        if (File.separatorChar == '\\') {
            return "\\";
        }
        return File.separator;
    }

    private static String getSplitCharactors() {
        if (File.separatorChar == '\\') {
            return "\\" + File.separator;
        }
        return File.separator;
    }

    public static String classNameFromQualifiedName(String qualifiedCalssName) {
        String[] parts = (qualifiedCalssName = qualifiedCalssName.replace('.', ':')).split(":");
        if (parts.length == 0) {
            return "";
        }
        return parts[parts.length - 1];
    }

    public static IJavaProject getJavaProjectByName(String projectName) throws JavaModelException {
        IJavaProject[] projects;
        IJavaModel model = JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot());
        model.open(null);
        IJavaProject[] iJavaProjectArray = projects = model.getJavaProjects();
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaProject proj = iJavaProjectArray[n2];
            if (proj.getProject().getName().equals(projectName)) {
                return proj;
            }
            ++n2;
        }
        return null;
    }

    public static ICompilationUnit findUnitByFileName(IJavaElement javaElem, String filePath) throws Exception {
        ICompilationUnit unit = null;
        if (!javaElem.getOpenable().isOpen()) {
            javaElem.getOpenable().open(null);
        }
        IJavaElement[] elems = null;
        if (javaElem instanceof IParent) {
            IParent parent = (IParent)javaElem;
            elems = parent.getChildren();
        }
        if (elems == null) {
            return null;
        }
        IJavaElement[] iJavaElementArray = elems;
        int n = elems.length;
        int n2 = 0;
        while (n2 < n) {
            ICompilationUnit compUnit;
            IJavaElement elem = iJavaElementArray[n2];
            if (elem.getElementType() == 3) {
                IPackageFragmentRoot root = (IPackageFragmentRoot)elem;
                if (root.getKind() == 1 && (unit = JBossWSCreationUtils.findUnitByFileName(elem, filePath)) != null) {
                    return unit;
                }
            } else if (elem.getElementType() == 4 || elem.getElementType() == 2) {
                unit = JBossWSCreationUtils.findUnitByFileName(elem, filePath);
                if (unit != null) {
                    return unit;
                }
            } else if (elem.getElementType() == 5 && (compUnit = (ICompilationUnit)elem).getPath().toString().equals(filePath)) {
                compUnit.open(null);
                return compUnit;
            }
            ++n2;
        }
        return null;
    }

    public static ICompilationUnit getJavaUnitFromFile(IFile javaFile) {
        IJavaProject project;
        block3: {
            try {
                project = JBossWSCreationUtils.getJavaProjectByName(javaFile.getProject().getName());
                if (project != null) break block3;
                return null;
            }
            catch (Exception exception) {
                return null;
            }
        }
        return JBossWSCreationUtils.findUnitByFileName((IJavaElement)project, javaFile.getFullPath().toString());
    }

    public static String getJBossWSRuntimeLocation(IProject project) throws CoreException {
        IRuntime serverRuntime;
        String runtimeTypeId;
        String isServerSupplied = project.getPersistentProperty(IJBossWSFacetDataModelProperties.PERSISTENCE_PROPERTY_SERVER_SUPPLIED_RUNTIME);
        String jbwsRuntimeName = project.getPersistentProperty(IJBossWSFacetDataModelProperties.PERSISTENCE_PROPERTY_QNAME_RUNTIME_NAME);
        if (jbwsRuntimeName != null && !"".equals(jbwsRuntimeName) && !"true".equals(isServerSupplied)) {
            JBossWSRuntime jbws = JBossWSRuntimeManager.getInstance().findRuntimeByName(jbwsRuntimeName);
            if (jbws != null) {
                return jbws.getHomeDir();
            }
            String jbwsHomeDir = project.getPersistentProperty(IJBossWSFacetDataModelProperties.PERSISTENCE_PROPERTY_RNTIME_LOCATION);
            if (new File(jbwsHomeDir).exists()) {
                return jbwsHomeDir;
            }
        }
        IFacetedProject facetedPrj = ProjectFacetsManager.create((IProject)project);
        org.eclipse.wst.common.project.facet.core.runtime.IRuntime prjFacetRuntime = null;
        if (facetedPrj != null && (prjFacetRuntime = facetedPrj.getPrimaryRuntime()) != null && (runtimeTypeId = (serverRuntime = JBossWSCreationUtils.getRuntime(prjFacetRuntime)).getRuntimeType().getId()) != null && Arrays.asList(IJBossToolingConstants.ALL_JBOSS_RUNTIMES).contains(runtimeTypeId)) {
            String runtimeLocation = serverRuntime.getLocation().toOSString();
            if (runtimeLocation.endsWith("bin")) {
                return serverRuntime.getLocation().removeLastSegments(1).toOSString();
            }
            return runtimeLocation;
        }
        if (prjFacetRuntime == null) {
            JBossWSRuntime jbws = JBossWSRuntimeManager.getInstance().getDefaultRuntime();
            if (jbws != null) {
                return jbws.getHomeDir();
            }
            throw new CoreException(StatusUtils.errorStatus((String)JBossWSCreationCoreMessages.Error_Message_No_Runtime_Specified));
        }
        return "";
    }

    public static boolean supportSOAP12(String projectName) {
        JBossWSRuntime jbws;
        block8: {
            block6: {
                String runtimeVersion;
                IRuntime runtime;
                IRuntimeType rt;
                IFacetedProject facetedPrj;
                block7: {
                    IProject project;
                    block5: {
                        try {
                            project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
                            if (project != null) break block5;
                            return false;
                        }
                        catch (CoreException coreException) {}
                    }
                    facetedPrj = ProjectFacetsManager.create((IProject)project);
                    IProjectFacet jbossWSFacet = ProjectFacetsManager.getProjectFacet((String)"jbossws.core");
                    if (jbossWSFacet == null || facetedPrj == null) break block6;
                    IProjectFacetVersion fpVersion = facetedPrj.getProjectFacetVersion(jbossWSFacet);
                    if (fpVersion == null || fpVersion.getVersionString().compareTo("3.0") < 0) break block7;
                    return true;
                }
                org.eclipse.wst.common.project.facet.core.runtime.IRuntime targetRuntime = facetedPrj.getPrimaryRuntime();
                if (targetRuntime != null && (rt = (runtime = JBossWSCreationUtils.getRuntime(targetRuntime)).getRuntimeType()).getName().toUpperCase().indexOf("JBOSS") >= 0 && (runtimeVersion = rt.getVersion()) != null && runtimeVersion.compareTo("5.0") >= 0) {
                    return true;
                }
                break block8;
            }
            return false;
        }
        return (jbws = JBossWSRuntimeManager.getInstance().getDefaultRuntime()) != null && "3.0".compareTo(jbws.getVersion()) <= 0;
    }

    public static IRuntime getRuntime(org.eclipse.wst.common.project.facet.core.runtime.IRuntime runtime) {
        if (runtime == null) {
            throw new IllegalArgumentException();
        }
        String id = runtime.getProperty("id");
        if (id == null) {
            return null;
        }
        IRuntime[] runtimes = ServerCore.getRuntimes();
        int size = runtimes.length;
        int i = 0;
        while (i < size) {
            if (id.equals(runtimes[i].getId())) {
                return runtimes[i];
            }
            ++i;
        }
        return null;
    }

    public static String getCustomSrcLocation(String srcPath) throws JavaModelException {
        if (srcPath == null || "".equals(srcPath)) {
            return "";
        }
        IFolder srcFolder = ResourcesPlugin.getWorkspace().getRoot().getFolder((IPath)new Path(srcPath));
        return srcFolder.getLocation().toOSString();
    }

    public static String getJavaProjectSrcLocation(IProject project) throws JavaModelException {
        IJavaProject javaProject = JavaCore.create((IProject)project);
        IResource[] rs = JBossWSCreationUtils.getJavaSourceRoots(javaProject);
        if (rs == null || rs.length == 0) {
            rs = JBossWSCreationUtils.getJavaSourceRoots(javaProject, false);
        }
        String src = "";
        if (rs == null || rs.length == 0) {
            return src;
        }
        int i = 0;
        while (i < rs.length) {
            IPath p = rs[i].getLocation();
            if (p != null) {
                src = p.toOSString();
                return src;
            }
            ++i;
        }
        return src;
    }

    public static List<String> getJavaProjectSrcFolder(IProject project) throws JavaModelException {
        IPackageFragmentRoot[] packageFragmentRoots = JavaCore.create((IProject)project).getAllPackageFragmentRoots();
        if (packageFragmentRoots != null && packageFragmentRoots.length > 0) {
            ArrayList<String> list = new ArrayList<String>();
            int i = 0;
            while (i < packageFragmentRoots.length) {
                IPackageFragmentRoot packageFragmentRoot = packageFragmentRoots[i];
                if (packageFragmentRoot.getKind() == 1) {
                    list.add(packageFragmentRoot.getResource().getFullPath().toOSString());
                }
                ++i;
            }
            return list;
        }
        return null;
    }

    public static IResource[] getJavaSourceRoots(IJavaProject javaProject) throws JavaModelException {
        return JBossWSCreationUtils.getJavaSourceRoots(javaProject, true);
    }

    public static IResource[] getJavaSourceRoots(IJavaProject javaProject, boolean outputLocationIsNull) throws JavaModelException {
        if (javaProject == null) {
            return null;
        }
        ArrayList<IResource> resources = new ArrayList<IResource>();
        IClasspathEntry[] es = javaProject.getResolvedClasspath(true);
        int i = 0;
        while (i < es.length) {
            if (es[i].getEntryKind() == 3) {
                IPath outputLocation = es[i].getOutputLocation();
                IResource findMember = ResourcesPlugin.getWorkspace().getRoot().findMember(es[i].getPath());
                if (findMember != null && findMember.exists()) {
                    if (outputLocationIsNull && outputLocation == null) {
                        resources.add(findMember);
                    } else {
                        resources.add(findMember);
                    }
                }
            }
            ++i;
        }
        return resources.toArray(new IResource[resources.size()]);
    }

    public static IPath getWebContentRootPath(IProject project) {
        if (project == null) {
            return null;
        }
        if (!ModuleCoreNature.isFlexibleProject((IProject)project)) {
            return null;
        }
        IPath path = null;
        IVirtualComponent component = ComponentCore.createComponent((IProject)project);
        if (component != null && component.exists()) {
            path = component.getRootFolder().getWorkspaceRelativePath();
        }
        return path;
    }

    public static String composeSrcPackageClassPath(IProject project, String packageName, String className) {
        String classFilePath = null;
        try {
            String srcPath = JBossWSCreationUtils.getJavaProjectSrcLocation(project);
            if (srcPath != null && srcPath.trim().length() > 0) {
                String pathSeparator = "" + File.separatorChar;
                String packageToFolderPath = packageName.replace(".", pathSeparator);
                classFilePath = String.valueOf(srcPath) + pathSeparator + packageToFolderPath + pathSeparator + className + JAVA;
                return classFilePath;
            }
        }
        catch (JavaModelException javaModelException) {
            return null;
        }
        return null;
    }

    public static File findFileByPath(String path) {
        File file = new File(path);
        if (file.exists()) {
            return file;
        }
        return null;
    }

    public static File findFileByPath(String name, String path) {
        File ret = null;
        File folder = new File(path);
        if (folder.isDirectory()) {
            File[] files;
            File[] fileArray = files = folder.listFiles();
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                ret = JBossWSCreationUtils.findFileByPath(name, file.getAbsolutePath());
                if (ret == null) {
                    ++n2;
                    continue;
                }
                break;
            }
        } else if (name.equals(folder.getName())) {
            ret = folder;
        }
        return ret;
    }

    public static List<ICompilationUnit> findJavaUnitsByAnnotation(IJavaProject project, String annotation, String packageName) {
        LinkedList<ICompilationUnit> units = new LinkedList<ICompilationUnit>();
        try {
            IPath path = JBossWSCreationUtils.addPackagetoPath(project, packageName);
            if (path == null) {
                IResource[] resources = JBossWSCreationUtils.getJavaSourceRoots(project);
                if (resources != null && resources.length > 0) {
                    IJavaElement[] elements;
                    IJavaElement[] iJavaElementArray = elements = project.getPackageFragmentRoot(resources[0]).getChildren();
                    int n = elements.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IJavaElement element = iJavaElementArray[n2];
                        if (4 == element.getElementType()) {
                            JBossWSCreationUtils.findInPackageFragment(units, element.getPath(), project, annotation);
                        }
                        ++n2;
                    }
                }
            } else {
                JBossWSCreationUtils.findInPackageFragment(units, path, project, annotation);
            }
        }
        catch (JavaModelException e) {
            JBossWSCreationCorePlugin.getDefault().logError(e);
        }
        return units;
    }

    private static void findInPackageFragment(List<ICompilationUnit> units, IPath path, IJavaProject project, String annotation) {
        ICompilationUnit[] javaFiles = null;
        try {
            if (project.findPackageFragment(path) != null) {
                javaFiles = project.findPackageFragment(path).getCompilationUnits();
            }
            if (javaFiles != null && javaFiles.length > 0) {
                ICompilationUnit[] iCompilationUnitArray = javaFiles;
                int n = javaFiles.length;
                int n2 = 0;
                while (n2 < n) {
                    File file;
                    IType type;
                    ICompilationUnit unit = iCompilationUnitArray[n2];
                    if (unit.getTypes().length > 0 && (type = unit.getTypes()[0]).getAnnotation(annotation).exists() && (file = new File(unit.getResource().getLocation().toOSString())).lastModified() > JBossWSCreationCorePlugin.getDefault().getGenerateTime()) {
                        units.add(unit);
                    }
                    ++n2;
                }
            }
        }
        catch (JavaModelException e) {
            JBossWSCreationCorePlugin.getDefault().logError(e);
        }
    }

    public static IPath addPackagetoPath(IJavaProject project, String packageName) throws JavaModelException {
        String PACAKAGESPLIT = "\\.";
        if ("".equals(packageName)) {
            return null;
        }
        Path path = new Path(JBossWSCreationUtils.getJavaProjectSrcLocation(project.getProject()));
        String[] names = packageName.split(PACAKAGESPLIT);
        path = project.getPath().append(path.makeRelativeTo(project.getProject().getLocation()));
        if (names != null && names.length > 0) {
            String[] stringArray = names;
            int n = names.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                path = path.append(name);
                ++n2;
            }
        }
        return path;
    }

    public static Definition readWSDL(String wsdlURL) throws WSDLException {
        WSDLFactory factory = WSDLFactory.newInstance();
        WSDLReader wsdlReader = factory.newWSDLReader();
        Definition def = wsdlReader.readWSDL(wsdlURL);
        return def;
    }

    public static boolean isOptions(String str) {
        String[] isUsed = new String[]{"-k", "-s", "-o", "-p", "-b", "-c", "-t", "-e", "-v", "-h", "-w"};
        boolean boo = true;
        int i = 0;
        while (i < isUsed.length) {
            if (str.trim().startsWith(isUsed[i])) {
                boo = false;
                break;
            }
            ++i;
        }
        return boo;
    }

    public static IPackageFragmentRoot getPackageFragmentRoot(IJavaProject project, String src) throws JavaModelException {
        Path path = new Path(JBossWSCreationUtils.getCustomSrcLocation(src));
        String str = String.valueOf(project.getProject().getName()) + File.separator + path.makeRelativeTo(project.getProject().getLocation());
        Path path1 = new Path(str);
        IResource res = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)path1);
        return project.getPackageFragmentRoot(res);
    }
}

