/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.ws.creation.core.commands;

import java.io.File;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jst.j2ee.model.IModelProvider;
import org.eclipse.jst.j2ee.model.ModelProviderManager;
import org.eclipse.jst.j2ee.webapplication.Servlet;
import org.eclipse.jst.j2ee.webapplication.ServletType;
import org.eclipse.jst.j2ee.webapplication.WebType;
import org.eclipse.jst.j2ee.webapplication.WebapplicationFactory;
import org.eclipse.jst.javaee.core.DisplayName;
import org.eclipse.jst.javaee.core.JavaeeFactory;
import org.eclipse.jst.javaee.core.UrlPatternType;
import org.eclipse.jst.javaee.web.ServletMapping;
import org.eclipse.jst.javaee.web.WebApp;
import org.eclipse.jst.javaee.web.WebFactory;
import org.eclipse.jst.jee.project.facet.WebCreateDeploymentFilesDataModelProvider;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelOperation;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.jboss.tools.ws.core.utils.StatusUtils;
import org.jboss.tools.ws.creation.core.data.ServiceModel;
import org.jboss.tools.ws.creation.core.data.ServletDescriptor;
import org.jboss.tools.ws.creation.core.messages.JBossWSCreationCoreMessages;
import org.jboss.tools.ws.creation.core.utils.JBossWSCreationUtils;

public class MergeWebXMLCommand
extends AbstractDataModelOperation {
    private ServiceModel model;
    IStatus status;
    private IJavaProject project;
    private static String WEB_XML = "web.xml";

    public MergeWebXMLCommand(ServiceModel model) {
        this.model = model;
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        this.status = Status.OK_STATUS;
        if (!this.model.isUpdateWebxml()) {
            return this.status;
        }
        ServletDescriptor[] servletDescriptors = new ServletDescriptor[this.model.getServiceClasses().size()];
        List<String> serviceClasses = this.model.getServiceClasses();
        int i = 0;
        while (i < serviceClasses.size()) {
            servletDescriptors[i] = this.getServletDescriptor(serviceClasses.get(i));
            ++i;
        }
        this.project = this.model.getJavaProject();
        if (!this.hasWebXML(this.project.getProject())) {
            IVirtualComponent vc = ComponentCore.createComponent((IProject)this.project.getProject());
            IDataModel model = DataModelFactory.createDataModel((IDataModelProvider)new WebCreateDeploymentFilesDataModelProvider());
            model.setProperty("ICreateDeploymentFilesDataModelProperties.GENERATE_DD", (Object)vc);
            model.setProperty("ICreateDeploymentFilesDataModelProperties.TARGET_PROJECT", (Object)this.project.getProject());
            IDataModelOperation op = model.getDefaultOperation();
            try {
                op.execute((IProgressMonitor)new NullProgressMonitor(), null);
            }
            catch (ExecutionException executionException) {}
        }
        this.mergeWebXML(servletDescriptors);
        return this.status;
    }

    private void mergeWebXML(final ServletDescriptor[] servletDescriptors) {
        final IModelProvider provider = ModelProviderManager.getModelProvider((IProject)this.project.getProject());
        provider.modify(new Runnable(){

            @Override
            public void run() {
                int i;
                WebApp webApp;
                Object object = provider.getModelObject();
                if (object instanceof WebApp) {
                    webApp = (WebApp)object;
                    i = 0;
                    while (i < servletDescriptors.length) {
                        MergeWebXMLCommand.this.addjeeServlet(servletDescriptors[i], webApp);
                        ++i;
                    }
                }
                if (object instanceof org.eclipse.jst.j2ee.webapplication.WebApp) {
                    webApp = (org.eclipse.jst.j2ee.webapplication.WebApp)object;
                    i = 0;
                    while (i < servletDescriptors.length) {
                        MergeWebXMLCommand.this.addServlet(servletDescriptors[i], (org.eclipse.jst.j2ee.webapplication.WebApp)webApp);
                        ++i;
                    }
                }
            }
        }, null);
    }

    protected void addServlet(ServletDescriptor servletDescriptor, org.eclipse.jst.j2ee.webapplication.WebApp webapp) {
        EList theServlets = webapp.getServlets();
        boolean b = false;
        int i = 0;
        while (i < theServlets.size()) {
            Servlet aServlet = (Servlet)theServlets.get(i);
            if (aServlet.getServletName().equals(servletDescriptor.getName())) {
                if (b) {
                    theServlets.remove(aServlet);
                } else {
                    b = this.isOverrideServlet();
                    if (b) {
                        theServlets.remove(aServlet);
                        break;
                    }
                    this.status = StatusUtils.errorStatus((String)"");
                    return;
                }
            }
            ++i;
        }
        EList theServletMapplings = webapp.getServletMappings();
        int i2 = 0;
        while (i2 < theServletMapplings.size()) {
            org.eclipse.jst.j2ee.webapplication.ServletMapping aServletMapping = (org.eclipse.jst.j2ee.webapplication.ServletMapping)theServletMapplings.get(i2);
            if (aServletMapping.getServlet().getServletName().equals(servletDescriptor.getName()) || aServletMapping.getUrlPattern().equals(servletDescriptor.getMappings())) {
                if (b) {
                    theServletMapplings.remove(aServletMapping);
                } else {
                    b = this.isOverrideServlet();
                    if (b) {
                        theServletMapplings.remove(aServletMapping);
                        break;
                    }
                    this.status = StatusUtils.errorStatus((String)"");
                    return;
                }
            }
            ++i2;
        }
        WebapplicationFactory factory = WebapplicationFactory.eINSTANCE;
        Servlet servlet = factory.createServlet();
        ServletType servletType = factory.createServletType();
        servlet.setWebType((WebType)servletType);
        servlet.setServletName(servletDescriptor.getName());
        servletType.setClassName(servletDescriptor.getClassName());
        if (servletDescriptor.getDisplayName() != null) {
            servlet.setDisplayName(servletDescriptor.getDisplayName());
        }
        webapp.getServlets().add((Object)servlet);
        if (servletDescriptor.getMappings() != null) {
            org.eclipse.jst.j2ee.webapplication.ServletMapping servletMapping = factory.createServletMapping();
            servletMapping.setServlet(servlet);
            servletMapping.setUrlPattern(servletDescriptor.getMappings());
            webapp.getServletMappings().add((Object)servletMapping);
        }
    }

    public void addjeeServlet(ServletDescriptor servletDescriptor, WebApp webapp) {
        List theServlets = webapp.getServlets();
        boolean b = false;
        int i = 0;
        while (i < theServlets.size()) {
            org.eclipse.jst.javaee.web.Servlet aServlet = (org.eclipse.jst.javaee.web.Servlet)theServlets.get(i);
            if (aServlet.getServletName().equals(servletDescriptor.getName())) {
                b = this.isOverrideServlet();
                if (b) {
                    theServlets.remove(aServlet);
                    break;
                }
                this.status = StatusUtils.errorStatus((String)"");
                return;
            }
            ++i;
        }
        List theServletMapplings = webapp.getServletMappings();
        int i2 = 0;
        while (i2 < theServletMapplings.size()) {
            List list;
            ServletMapping aServletMapping = (ServletMapping)theServletMapplings.get(i2);
            if (aServletMapping.getServletName().equals(servletDescriptor.getName())) {
                if (b) {
                    theServletMapplings.remove(aServletMapping);
                } else {
                    b = this.isOverrideServlet();
                    if (b) {
                        theServletMapplings.remove(aServletMapping);
                        break;
                    }
                    this.status = StatusUtils.errorStatus((String)"");
                    return;
                }
            }
            if ((list = aServletMapping.getUrlPatterns()) != null) {
                int j = 0;
                while (j < list.size()) {
                    UrlPatternType url = (UrlPatternType)list.get(j);
                    if (url.getValue().equals(servletDescriptor.getMappings())) {
                        if (b) {
                            theServletMapplings.remove(aServletMapping);
                        } else {
                            if (this.isOverrideServlet()) {
                                theServletMapplings.remove(aServletMapping);
                                break;
                            }
                            this.status = StatusUtils.errorStatus((String)"");
                            return;
                        }
                    }
                    ++j;
                }
            }
            ++i2;
        }
        WebFactory factory = WebFactory.eINSTANCE;
        org.eclipse.jst.javaee.web.Servlet servlet = factory.createServlet();
        servlet.setServletName(servletDescriptor.getName());
        servlet.setServletClass(servletDescriptor.getClassName());
        if (servletDescriptor.getDisplayName() != null) {
            DisplayName displayNameObj = JavaeeFactory.eINSTANCE.createDisplayName();
            displayNameObj.setValue(servletDescriptor.getDisplayName());
            servlet.getDisplayNames().add(displayNameObj);
        }
        webapp.getServlets().add(servlet);
        if (servletDescriptor.getMappings() != null) {
            ServletMapping servletMapping = factory.createServletMapping();
            servletMapping.setServletName(servlet.getServletName());
            UrlPatternType url = JavaeeFactory.eINSTANCE.createUrlPatternType();
            url.setValue(servletDescriptor.getMappings());
            servletMapping.getUrlPatterns().add(url);
            webapp.getServletMappings().add(servletMapping);
        }
    }

    private ServletDescriptor getServletDescriptor(String clsName) {
        String servletName = this.model.getServiceName();
        if (servletName == null) {
            servletName = JBossWSCreationUtils.classNameFromQualifiedName(clsName);
        }
        if (servletName.endsWith("Impl") && servletName.length() > 4) {
            servletName = servletName.substring(0, servletName.length() - 4);
        }
        ServletDescriptor sd = new ServletDescriptor();
        sd.setName(servletName);
        sd.setDisplayName(sd.getName());
        sd.setClassName(clsName);
        sd.setMappings(String.valueOf(JBossWSCreationCoreMessages.Separator_Java) + sd.getName());
        return sd;
    }

    private boolean hasWebXML(IProject pro) {
        File file = JBossWSCreationUtils.findFileByPath(WEB_XML, pro.getLocation().toOSString());
        return file != null;
    }

    private boolean isOverrideServlet() {
        boolean b = MessageDialog.openConfirm((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)JBossWSCreationCoreMessages.Confirm_Override_Servlet, (String)JBossWSCreationCoreMessages.Error_JBossWS_GenerateWizard_WSName_Same);
        return b;
    }
}

