/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.seam.internal.core.refactoring;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.ltk.core.refactoring.Change;
import org.jboss.tools.seam.core.SeamCorePlugin;
import org.jboss.tools.seam.internal.core.refactoring.SeamProjectChange;
import org.osgi.service.prefs.BackingStoreException;

public class SeamProjectRenameChange
extends SeamProjectChange {
    protected String newName;
    protected String oldName;
    private List<String> relevantProjectNameProperties = new ArrayList<String>();
    private List<String> relevantSourceFolderProperties = new ArrayList<String>();

    public SeamProjectRenameChange(IProject project, String newName, String oldName) {
        super(project);
        this.newName = newName;
        this.oldName = oldName;
        IEclipsePreferences ps = this.getSeamPreferences();
        int i = 0;
        while (i < PROJECT_NAME_PROPERTIES.length) {
            if (oldName.equals(ps.get(PROJECT_NAME_PROPERTIES[i], null))) {
                this.relevantProjectNameProperties.add(PROJECT_NAME_PROPERTIES[i]);
            }
            ++i;
        }
        i = 0;
        while (i < FOLDER_PROPERTIES.length) {
            if (ps.get(FOLDER_PROPERTIES[i], "").startsWith("/" + oldName + "/")) {
                this.relevantSourceFolderProperties.add(FOLDER_PROPERTIES[i]);
            }
            ++i;
        }
        this.findPreferences(ps);
    }

    private void findPreferences(IEclipsePreferences ps) {
        for (String property : this.relevantProjectNameProperties) {
            if (!this.oldName.equals(ps.get(property, null))) continue;
            this.preferences.put(property, this.newName);
        }
        String oldPrefix = "/" + this.oldName + "/";
        for (String property : this.relevantSourceFolderProperties) {
            String oldProperty = ps.get(property, "");
            if (!oldProperty.startsWith(oldPrefix) || oldProperty.length() <= oldPrefix.length()) continue;
            this.preferences.put(property, "/" + this.newName + "/" + oldProperty.substring(oldPrefix.length()));
        }
    }

    @Override
    public boolean isRelevant() {
        return !this.relevantProjectNameProperties.isEmpty() || !this.relevantSourceFolderProperties.isEmpty();
    }

    public Change perform(IProgressMonitor pm) throws CoreException {
        if (!this.isRelevant()) {
            return null;
        }
        try {
            pm.beginTask(this.getName(), 1);
            if (this.project.getName().equals(this.oldName)) {
                IResource newProject = ResourcesPlugin.getWorkspace().getRoot().findMember(this.newName);
                if (!this.project.exists() && newProject instanceof IProject && newProject.exists()) {
                    this.project = (IProject)newProject;
                }
            }
            IEclipsePreferences ps = this.getSeamPreferences();
            for (String key : this.preferences.keySet()) {
                ps.put(key, (String)this.preferences.get(key));
            }
            try {
                ps.flush();
            }
            catch (BackingStoreException e) {
                SeamCorePlugin.getPluginLog().logError((Throwable)e);
            }
            SeamProjectRenameChange seamProjectRenameChange = new SeamProjectRenameChange(this.project, this.oldName, this.newName);
            return seamProjectRenameChange;
        }
        finally {
            pm.done();
        }
    }
}

