/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.seam.internal.core.project.facet;

import java.io.File;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jst.javaee.web.WebApp;
import org.eclipse.jst.jsf.core.JSFVersion;
import org.eclipse.jst.jsf.facesconfig.emf.ApplicationType;
import org.eclipse.jst.jsf.facesconfig.emf.DefaultLocaleType;
import org.eclipse.jst.jsf.facesconfig.emf.FacesConfigFactory;
import org.eclipse.jst.jsf.facesconfig.emf.FacesConfigType;
import org.eclipse.jst.jsf.facesconfig.emf.LocaleConfigType;
import org.eclipse.jst.jsf.facesconfig.emf.SupportedLocaleType;
import org.eclipse.jst.jsf.facesconfig.emf.ViewHandlerType;
import org.eclipse.jst.jsf.facesconfig.util.FacesConfigArtifactEdit;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.jboss.tools.seam.core.SeamCorePlugin;
import org.jboss.tools.seam.internal.core.project.facet.AntCopyUtils;
import org.jboss.tools.seam.internal.core.project.facet.Seam2ProjectCreator;
import org.jboss.tools.seam.internal.core.project.facet.SeamFacetAbstractInstallDelegate;
import org.jboss.tools.seam.internal.core.project.facet.SeamProjectCreator;
import org.w3c.dom.Element;

public class Seam2FacetInstallDelegate
extends SeamFacetAbstractInstallDelegate {
    public static final AntCopyUtils.FileSet JBOSS_EAR_CONTENT = new AntCopyUtils.FileSet().include("jboss-seam.jar");
    public static final AntCopyUtils.FileSet SEAM2_JBOSS_EAR_LIB = new AntCopyUtils.FileSet().include("antlr-runtime.jar").include("commons-beanutils.*\\.jar").include("drools-compiler.*\\.jar").include("drools-core.*\\.jar").include("drools-api.*\\.jar").include("jboss-el.*.jar").include("jboss-seam-remoting\\.jar").include("mvel.*\\.jar").include("jbpm-jpdl.*\\.jar").include("richfaces-api.*\\.jar");
    public static final AntCopyUtils.FileSet SEAM2_JBOSS_WAR_LIB_FILESET_WAR_CONFIG = new AntCopyUtils.FileSet().include("ajax4jsf.*\\.jar").include("richfaces.*\\.jar").include("antlr-runtime.*\\.jar").include("commons-beanutils.*\\.jar").include("commons-digester.*\\.jar").include("commons-jci-core.*\\.jar").include("commons-jci-janino.*\\.jar").include("drools-compiler.*\\.jar").include("drools-core.*\\.jar").include("drools-api.*\\.jar").include("core.jar").include("jboss-seam-debug\\.jar").include("jboss-seam-ioc\\.jar").include("jboss-seam-mail\\.jar").include("jboss-seam-pdf\\.jar").include("jboss-seam-remoting\\.jar").include("jboss-seam-ui\\.jar").include("jboss-seam-excel\\.jar").include("jboss-seam\\.jar").include("jbpm.*\\.jar").include("jsf-facelets\\.jar").include("oscache.*\\.jar").include("stringtemplate.*\\.jar").include("mvel.*\\.jar").include("jboss-el.jar").include("jxl\\.jar").include("itext.*\\.jar").include("jfreechart.*\\.jar").include("jcommon.*\\.jar");
    public static final AntCopyUtils.FileSet SEAM2_JBOSS_WAR_LIB_FILESET_EAR_CONFIG = new AntCopyUtils.FileSet().include("richfaces-impl\\.jar").include("richfaces-ui\\.jar").include("commons-digester\\.jar").include("jboss-seam-debug\\.jar").include("jboss-seam-ioc\\.jar").include("jboss-seam-mail\\.jar").include("jboss-seam-pdf\\.jar").include("jboss-seam-ui\\.jar").include("jboss-seam-excel\\.jar").include("jxl\\.jar").include("itext.*\\.jar").include("jfreechart.*\\.jar").include("jcommon.*\\.jar").include("jsf-facelets\\.jar");
    public static String DROOLS_LIB_SEAM_RELATED_PATH = "lib";

    @Override
    public AntCopyUtils.FileSet getEarLibFileSet() {
        return SEAM2_JBOSS_EAR_LIB;
    }

    @Override
    public AntCopyUtils.FileSet getWarLibFileSet() {
        return SEAM2_JBOSS_WAR_LIB_FILESET_WAR_CONFIG;
    }

    @Override
    public AntCopyUtils.FileSet getWarLibFileSetForEar() {
        return SEAM2_JBOSS_WAR_LIB_FILESET_EAR_CONFIG;
    }

    @Override
    protected void doExecuteForEjb(IProject project, IProjectFacetVersion fv, IDataModel model, IProgressMonitor monitor) throws CoreException {
        super.doExecuteForEjb(project, fv, model, monitor);
        IResource src = this.getSrcFolder(project);
        if (src != null && this.seamHomeFolder != null && this.shouldCopyLibrariesAndTemplates(model)) {
            File srcFile = src.getLocation().toFile();
            AntCopyUtils.copyFileToFolder(new File(this.seamGenResFolder, "security.drl"), srcFile, false);
        }
    }

    @Override
    protected void copyFilesToWarProject(IProject project, IProjectFacetVersion fv, IDataModel model, IProgressMonitor monitor) throws CoreException {
        if (!this.shouldCopyLibrariesAndTemplates(model)) {
            return;
        }
        super.copyFilesToWarProject(project, fv, model, monitor);
        File droolsLibFolder = new File(this.seamHomePath, DROOLS_LIB_SEAM_RELATED_PATH);
        if (Seam2FacetInstallDelegate.isWarConfiguration(model)) {
            if (!SeamCorePlugin.getDefault().hasM2Facet(project) && this.shouldCopyLibraries(model)) {
                AntCopyUtils.copyFiles(this.seamHomeFolder, this.webLibFolder, new AntCopyUtils.FileSetFileFilter(new AntCopyUtils.FileSet(this.getWarLibFileSet()).dir(this.seamHomeFolder)));
                AntCopyUtils.copyFiles(this.seamLibFolder, this.webLibFolder, new AntCopyUtils.FileSetFileFilter(new AntCopyUtils.FileSet(this.getWarLibFileSet()).dir(this.seamLibFolder)));
            }
            IContainer source = this.warActionSrcRootFolder.getUnderlyingFolder();
            File actionsSrc = new File(project.getLocation().toFile(), source.getFullPath().removeFirstSegments(1).toString());
            AntCopyUtils.copyFileToFolder(new File(this.seamGenResFolder, "seam.properties"), actionsSrc, true);
            if (!SeamCorePlugin.getDefault().hasM2Facet(project) && this.shouldCopyLibraries(model)) {
                AntCopyUtils.copyFiles(droolsLibFolder, this.webLibFolder, new AntCopyUtils.FileSetFileFilter(new AntCopyUtils.FileSet(this.getWarLibFileSet()).dir(droolsLibFolder)));
            }
        } else if (!SeamCorePlugin.getDefault().hasM2Facet(project) && this.shouldCopyLibraries(model)) {
            AntCopyUtils.copyFiles(this.seamHomeFolder, this.webLibFolder, new AntCopyUtils.FileSetFileFilter(new AntCopyUtils.FileSet(this.getWarLibFileSetForEar()).dir(this.seamHomeFolder)));
            AntCopyUtils.copyFiles(this.seamLibFolder, this.webLibFolder, new AntCopyUtils.FileSetFileFilter(new AntCopyUtils.FileSet(this.getWarLibFileSetForEar()).dir(this.seamLibFolder)));
            AntCopyUtils.copyFiles(droolsLibFolder, this.webLibFolder, new AntCopyUtils.FileSetFileFilter(new AntCopyUtils.FileSet(this.getWarLibFileSetForEar()).dir(droolsLibFolder)));
        }
    }

    @Override
    protected void fillEarContents(IProject project, IDataModel model) {
        if (!this.shouldCopyLibrariesAndTemplates(model)) {
            return;
        }
        if (!SeamCorePlugin.getDefault().hasM2Facet(project)) {
            File droolsLibFolder = new File(this.seamHomePath, DROOLS_LIB_SEAM_RELATED_PATH);
            AntCopyUtils.copyFiles(this.seamHomeFolder, this.earContentsFolder, new AntCopyUtils.FileSetFileFilter(new AntCopyUtils.FileSet(JBOSS_EAR_CONTENT).dir(this.seamHomeFolder)), false);
            if (this.shouldCopyLibraries(model)) {
                AntCopyUtils.copyFiles(this.seamLibFolder, this.earContentsFolder, new AntCopyUtils.FileSetFileFilter(new AntCopyUtils.FileSet(JBOSS_EAR_CONTENT).dir(this.seamLibFolder)), false);
                AntCopyUtils.copyFiles(this.seamLibFolder, this.earLibFolder, new AntCopyUtils.FileSetFileFilter(new AntCopyUtils.FileSet(this.getEarLibFileSet()).dir(this.seamLibFolder)), false);
                AntCopyUtils.copyFiles(droolsLibFolder, this.earContentsFolder, new AntCopyUtils.FileSetFileFilter(new AntCopyUtils.FileSet(JBOSS_EAR_CONTENT).dir(droolsLibFolder)), false);
            }
            AntCopyUtils.copyFiles(this.seamGenResFolder, this.earContentsFolder, new AntCopyUtils.FileSetFileFilter(new AntCopyUtils.FileSet(JBOSS_EAR_CONTENT).dir(this.seamGenResFolder)), false);
        }
    }

    @Override
    protected void configureFacesConfigXml(IProject project, IProgressMonitor monitor, String webConfigName) {
        FacesConfigArtifactEdit facesConfigEdit = null;
        try {
            Element facesConfigElement;
            facesConfigEdit = FacesConfigArtifactEdit.getFacesConfigArtifactEditForWrite((IProject)project, (String)webConfigName);
            FacesConfigType facesConfig = facesConfigEdit.getFacesConfig();
            EList applications = facesConfig.getApplication();
            ApplicationType applicationType = null;
            boolean applicationExists = false;
            if (applications.size() <= 0) {
                applicationType = FacesConfigFactory.eINSTANCE.createApplicationType();
            } else {
                applicationType = (ApplicationType)applications.get(0);
                applicationExists = true;
            }
            boolean localeConfigExists = false;
            for (ApplicationType application : applications) {
                EList localeConfigs = application.getLocaleConfig();
                if (localeConfigs.isEmpty()) continue;
                localeConfigExists = true;
                break;
            }
            if (!localeConfigExists) {
                LocaleConfigType locale = FacesConfigFactory.eINSTANCE.createLocaleConfigType();
                DefaultLocaleType defaultLocale = FacesConfigFactory.eINSTANCE.createDefaultLocaleType();
                defaultLocale.setTextContent("en");
                locale.setDefaultLocale(defaultLocale);
                SupportedLocaleType supportedLocale = FacesConfigFactory.eINSTANCE.createSupportedLocaleType();
                supportedLocale.setTextContent("bg");
                locale.getSupportedLocale().add((Object)supportedLocale);
                supportedLocale = FacesConfigFactory.eINSTANCE.createSupportedLocaleType();
                supportedLocale.setTextContent("de");
                locale.getSupportedLocale().add((Object)supportedLocale);
                supportedLocale = FacesConfigFactory.eINSTANCE.createSupportedLocaleType();
                supportedLocale.setTextContent("en");
                locale.getSupportedLocale().add((Object)supportedLocale);
                supportedLocale = FacesConfigFactory.eINSTANCE.createSupportedLocaleType();
                supportedLocale.setTextContent("fr");
                locale.getSupportedLocale().add((Object)supportedLocale);
                supportedLocale = FacesConfigFactory.eINSTANCE.createSupportedLocaleType();
                supportedLocale.setTextContent("tr");
                locale.getSupportedLocale().add((Object)supportedLocale);
                applicationType.getLocaleConfig().add((Object)locale);
            }
            boolean viewHandlerExists = false;
            IDOMModel domModel = facesConfigEdit.getIDOMModel();
            if (domModel != null && (facesConfigElement = domModel.getDocument().getDocumentElement()) != null) {
                if (facesConfigElement.getAttribute("version").startsWith("1")) {
                    block4: for (ApplicationType application : applications) {
                        EList viewHandlers = application.getViewHandler();
                        for (ViewHandlerType viewHandlerType : viewHandlers) {
                            if (!"com.sun.facelets.FaceletViewHandler".equals(viewHandlerType.getTextContent().trim())) continue;
                            viewHandlerExists = true;
                            continue block4;
                        }
                    }
                } else {
                    viewHandlerExists = true;
                }
            }
            if (!viewHandlerExists) {
                ViewHandlerType viewHandler = FacesConfigFactory.eINSTANCE.createViewHandlerType();
                viewHandler.setTextContent("com.sun.facelets.FaceletViewHandler");
                applicationType.getViewHandler().add((Object)viewHandler);
            }
            if (!applicationExists) {
                facesConfig.getApplication().add((Object)applicationType);
            }
            facesConfigEdit.save(monitor);
        }
        finally {
            if (facesConfigEdit != null) {
                facesConfigEdit.dispose();
            }
        }
    }

    protected String getSkinParamName() {
        return ORG_RICHFACES_SKIN;
    }

    @Override
    protected void configure(WebApp webApp, IProject project) {
        JSFVersion jsfVersion = JSFVersion.valueOfProject((IProject)project);
        if (JSFVersion.V2_0.compareTo((Enum)jsfVersion) > 0) {
            this.createOrUpdateContextParam(webApp, "org.jboss.jbossfaces.JSF_CONFIG_NAME", "Mojarra-1.2");
        }
        this.createOrUpdateContextParam(webApp, this.getSkinParamName(), ORG_RICHFACES_SKIN_VALUE);
        this.createOrUpdateListener(webApp, ORG_JBOSS_SEAM_SERVLET_SEAMLISTENER);
        this.createOrUpdateFilter(webApp, ORG_JBOSS_SEAM_SERVLET_SEAMFILTER_NAME, ORG_JBOSS_SEAM_SERVLET_SEAMFILTER);
        this.createOrUpdateFilterMapping(webApp, ORG_JBOSS_SEAM_SERVLET_SEAMFILTER_NAME, ORG_JBOSS_SEAM_SERVLET_SEAMFILTER_MAPPING_VALUE);
        this.createOrUpdateServlet(webApp, ORG_JBOSS_SEAM_SERVLET_SEAMRESOURCESERVLET, ORG_JBOSS_SEAM_SERVLET_SEAMRESOURCESERVLET_NAME);
        this.createOrUpdateServletMapping(webApp, ORG_JBOSS_SEAM_SERVLET_SEAMRESOURCESERVLET_NAME, ORG_JBOSS_SEAM_SERVLET_SEAMRESOURCESERVLET_VALUE);
        this.createOrUpdateContextParam(webApp, FACELETS_DEVELOPMENT, "true");
        this.createOrUpdateContextParam(webApp, JAVAX_FACES_DEFAULT_SUFFIX, JAVAX_FACES_DEFAULT_SUFFIX_VALUE);
        this.addSecurityConstraint(webApp);
    }

    @Override
    protected SeamProjectCreator getProjectCreator(IDataModel model, IProject project, SeamFacetAbstractInstallDelegate seamFacetInstallDelegate) {
        return new Seam2ProjectCreator(model, project, this);
    }
}

