/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.seam.core.project.facet;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.preference.IPersistentPreferenceStore;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.jboss.tools.seam.core.ISeamProject;
import org.jboss.tools.seam.core.SeamCorePlugin;
import org.jboss.tools.seam.core.project.facet.SeamProjectPreferences;
import org.jboss.tools.seam.core.project.facet.SeamRuntime;
import org.jboss.tools.seam.core.project.facet.SeamRuntimeListConverter;
import org.jboss.tools.seam.core.project.facet.SeamVersion;
import org.jboss.tools.seam.internal.core.SeamProject;
import org.jboss.tools.seam.internal.core.project.facet.SeamFacetPreferenceInitializer;
import org.osgi.service.prefs.BackingStoreException;

public class SeamRuntimeManager {
    private static SeamRuntimeListConverter converter = new SeamRuntimeListConverter();
    private Map<String, SeamRuntime> runtimes = new HashMap<String, SeamRuntime>();

    private SeamRuntimeManager() {
        SeamProjectPreferences.getStringPreference("org.jboss.tools.seam.core.runtime.config.format.version");
        String runtimeListString = SeamProjectPreferences.getStringPreference("org.jboss.tools.seam.core.runtime.list");
        this.runtimes = converter.getMap(runtimeListString);
        SeamCorePlugin.getDefault().getPreferenceStore().addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                String property = event.getProperty();
                if ("org.jboss.tools.seam.core.runtime.list".equals(property)) {
                    String runtimeListString = SeamProjectPreferences.getStringPreference("org.jboss.tools.seam.core.runtime.list");
                    Map<String, SeamRuntime> newRuntimes = converter.getMap(runtimeListString);
                    for (SeamRuntime seamRuntime : newRuntimes.values()) {
                        SeamRuntime runtime;
                        String name = seamRuntime.getName();
                        if (name == null || (runtime = (SeamRuntime)SeamRuntimeManager.this.runtimes.get(name)) != null) continue;
                        SeamRuntimeManager.this.addRuntime(seamRuntime);
                    }
                }
            }
        });
    }

    public static SeamRuntimeManager getInstance() {
        return SeamRuntimeManagerHolder.INSTANCE;
    }

    public SeamRuntime[] getRuntimes() {
        Collection<SeamRuntime> c = this.runtimes.values();
        return c.toArray(new SeamRuntime[this.runtimes.size()]);
    }

    public SeamRuntime getLatestSeamRuntime() {
        SeamRuntime[] runtimes;
        SeamRuntime runtime2;
        SeamVersion latestVersion = this.runtimes.isEmpty() ? SeamVersion.getLatestDefaultVersion() : SeamVersion.SEAM_1_2;
        for (SeamRuntime runtime2 : this.runtimes.values()) {
            if (runtime2.getVersion().compareTo(latestVersion) < 0) continue;
            latestVersion = runtime2.getVersion();
        }
        runtime2 = this.getDefaultRuntime(latestVersion);
        if (runtime2 == null && (runtimes = this.getRuntimes(latestVersion)).length > 0) {
            runtime2 = runtimes[0];
        }
        return runtime2;
    }

    public SeamRuntime[] getRuntimes(SeamVersion version) {
        Collection<SeamRuntime> c = this.runtimes.values();
        ArrayList<SeamRuntime> rts = new ArrayList<SeamRuntime>();
        for (SeamRuntime seamRuntime : c) {
            if (seamRuntime.getVersion() != version) continue;
            rts.add(seamRuntime);
        }
        return rts.toArray(new SeamRuntime[rts.size()]);
    }

    public void addRuntime(SeamRuntime runtime) {
        SeamRuntime oldDefaultRuntime = this.getDefaultRuntime(runtime.getVersion());
        if (oldDefaultRuntime != null) {
            if (runtime.isDefault()) {
                oldDefaultRuntime.setDefault(false);
            }
        } else {
            runtime.setDefault(true);
        }
        this.runtimes.put(runtime.getName(), runtime);
        this.updateProjectsForRuntime(runtime);
        this.save();
    }

    public SeamRuntime addRuntime(String name, String path, SeamVersion version, boolean defaultRt) {
        SeamRuntime seamRt = new SeamRuntime();
        seamRt.setVersion(version);
        seamRt.setHomeDir(path);
        seamRt.setName(name);
        seamRt.setDefault(defaultRt);
        this.addRuntime(seamRt);
        return seamRt;
    }

    public SeamRuntime findRuntimeByName(String name) {
        for (SeamRuntime seamRuntime : this.runtimes.values()) {
            if (!seamRuntime.getName().equals(name)) continue;
            return seamRuntime;
        }
        return null;
    }

    public void removeRuntime(SeamRuntime rt) {
        this.runtimes.remove(rt.getName());
        this.updateProjectsForRuntime(rt);
    }

    private void updateProjectsForRuntime(SeamRuntime rt) {
        IProject[] ps = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int i = 0;
        while (i < ps.length) {
            ISeamProject sp = SeamCorePlugin.getSeamProject(ps[i], false);
            if (sp != null) {
                String tmpName = null;
                try {
                    tmpName = sp.getRuntimeName();
                }
                catch (IllegalStateException ex) {
                    SeamCorePlugin.getDefault().logWarning(ex);
                }
                if (rt.getName().equals(tmpName)) {
                    IEclipsePreferences prefs = ((SeamProject)sp).getSeamPreferences();
                    prefs.remove("seam.runtime.name");
                    prefs.put("seam.runtime.name", rt.getName());
                    try {
                        prefs.flush();
                    }
                    catch (BackingStoreException e) {
                        SeamCorePlugin.getPluginLog().logError((Throwable)e);
                    }
                }
            }
            ++i;
        }
    }

    public SeamRuntime getRuntimeForProject(IProject project) {
        ISeamProject seamProject = SeamCorePlugin.getSeamProject(project, false);
        return seamProject == null ? null : seamProject.getRuntime();
    }

    public void save() {
        SeamCorePlugin.getDefault().getPluginPreferences().setValue("org.jboss.tools.seam.core.runtime.list", converter.getString(this.runtimes));
        IPreferenceStore store = SeamCorePlugin.getDefault().getPreferenceStore();
        if (store instanceof IPersistentPreferenceStore) {
            try {
                ((IPersistentPreferenceStore)store).save();
            }
            catch (IOException e) {
                SeamCorePlugin.getPluginLog().logError("Seam Runtime List was not saved", (Throwable)e);
            }
        }
    }

    public void setDefaultRuntime(SeamRuntime runtime) {
        SeamRuntime[] runtimes = this.getRuntimes(runtime.getVersion());
        int i = 0;
        while (i < runtimes.length) {
            runtimes[i].setDefault(false);
            ++i;
        }
        runtime.setDefault(true);
    }

    public SeamRuntime getDefaultRuntime() {
        for (SeamRuntime rt : this.runtimes.values()) {
            if (!rt.isDefault()) continue;
            return rt;
        }
        return null;
    }

    public static SeamRuntime getDefaultRuntimeForProject(IProject project) {
        block5: {
            IProjectFacetVersion facetVersion;
            block6: {
                if (project == null) {
                    throw new IllegalArgumentException("Project must not be null.");
                }
                IProjectFacet facet = ProjectFacetsManager.getProjectFacet((String)"jst.seam");
                IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)project);
                if (facetedProject == null) break block5;
                facetVersion = facetedProject.getInstalledVersion(facet);
                if (facetVersion != null) break block6;
                return null;
            }
            try {
                SeamVersion seamVersion = SeamVersion.parseFromString(facetVersion.getVersionString());
                return SeamRuntimeManager.getInstance().getDefaultRuntime(seamVersion);
            }
            catch (CoreException e) {
                SeamCorePlugin.getPluginLog().logError((Throwable)e);
            }
            catch (IllegalArgumentException e) {
                SeamCorePlugin.getPluginLog().logError((Throwable)e);
            }
        }
        return SeamRuntimeManager.getInstance().getDefaultRuntime();
    }

    public SeamRuntime getDefaultRuntime(SeamVersion version) {
        for (SeamRuntime rt : this.runtimes.values()) {
            if (!rt.isDefault() || rt.getVersion() != version) continue;
            return rt;
        }
        return null;
    }

    public String getConfigurationVersion() {
        return SeamFacetPreferenceInitializer.RUNTIME_CONFIG_FORMAT_VERSION;
    }

    public List<String> getAllRuntimeNames() {
        SeamRuntime[] rts = this.getRuntimes();
        ArrayList<String> result = new ArrayList<String>();
        SeamRuntime[] seamRuntimeArray = rts;
        int n = rts.length;
        int n2 = 0;
        while (n2 < n) {
            SeamRuntime seamRuntime = seamRuntimeArray[n2];
            result.add(seamRuntime.getName());
            ++n2;
        }
        return result;
    }

    public void changeRuntimeName(String oldName, String newName) {
        SeamRuntime o = this.findRuntimeByName(oldName);
        if (o == null) {
            return;
        }
        o.setName(newName);
        this.runtimes.remove(oldName);
        this.runtimes.put(newName, o);
        this.onRuntimeNameChanged(oldName, newName);
    }

    private void onRuntimeNameChanged(String oldName, String newName) {
        IProject[] ps = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int i = 0;
        while (i < ps.length) {
            ISeamProject sp = SeamCorePlugin.getSeamProject(ps[i], false);
            if (sp != null && oldName.equals(sp.getRuntimeName())) {
                sp.setRuntimeName(newName);
            }
            ++i;
        }
    }

    /* synthetic */ SeamRuntimeManager(SeamRuntimeManager seamRuntimeManager) {
        this();
    }

    static class SeamRuntimeManagerHolder {
        private static final SeamRuntimeManager INSTANCE = new SeamRuntimeManager(null);

        SeamRuntimeManagerHolder() {
        }
    }
}

