/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate.jpt.ui.internal.persistence.details;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.wizards.TypedElementSelectionValidator;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jpt.common.ui.internal.swt.listeners.SWTListenerTools;
import org.eclipse.jpt.common.ui.internal.widgets.Pane;
import org.eclipse.jpt.common.utility.internal.model.value.PropertyAspectAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.SimpleListValueModel;
import org.eclipse.jpt.common.utility.internal.transformer.TransformerTools;
import org.eclipse.jpt.common.utility.model.event.PropertyChangeEvent;
import org.eclipse.jpt.common.utility.model.listener.PropertyChangeListener;
import org.eclipse.jpt.common.utility.model.value.ListValueModel;
import org.eclipse.jpt.common.utility.model.value.ModifiablePropertyValueModel;
import org.eclipse.jpt.common.utility.model.value.PropertyValueModel;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.views.navigator.ResourceComparator;
import org.hibernate.eclipse.console.FileFilter;
import org.hibernate.eclipse.console.HibernateConsoleMessages;
import org.hibernate.eclipse.console.utils.DriverClassHelpers;
import org.hibernate.eclipse.console.wizards.NewConfigurationWizard;
import org.hibernate.eclipse.console.wizards.NewConfigurationWizardPage;
import org.jboss.tools.hibernate.jpt.core.internal.context.basic.BasicHibernateProperties;

public class HibernatePropertiesComposite
extends Pane<BasicHibernateProperties> {
    private Text cfgFile;
    DriverClassHelpers helper;

    public HibernatePropertiesComposite(Pane<BasicHibernateProperties> parentPane, Composite parent) {
        super(parentPane, parent);
    }

    protected void initializeLayout(Composite container) {
        GridLayout gl = new GridLayout(3, false);
        container.setLayout((Layout)gl);
        this.helper = new DriverClassHelpers();
        SimpleListValueModel lvmDialect = new SimpleListValueModel(Arrays.asList(this.helper.getDialectNames()));
        PropertyValueModel p = this.getSubjectHolder();
        ArrayList<String> drivers = new ArrayList<String>();
        BasicHibernateProperties props = (BasicHibernateProperties)p.getValue();
        if (props != null) {
            String dialectClass = this.helper.getDialectClass(props.getDialect());
            String[] driverClasses = this.helper.getDriverClasses(dialectClass);
            drivers.addAll(Arrays.asList(driverClasses));
        }
        final SimpleListValueModel lvmDriver = new SimpleListValueModel(drivers);
        ArrayList<String> urls = new ArrayList<String>();
        if (props != null) {
            String driverClass = props.getDriver();
            String[] connectionURLS = this.helper.getConnectionURLS(driverClass);
            urls.addAll(Arrays.asList(connectionURLS));
        }
        final SimpleListValueModel lvmUrl = new SimpleListValueModel(urls);
        ModifiablePropertyValueModel<String> dialectHolder = this.buildDialectHolder();
        final ModifiablePropertyValueModel<String> driverHolder = this.buildDriverHolder();
        final ModifiablePropertyValueModel<String> urlHolder = this.buildUrlHolder();
        GridData gd = new GridData(768);
        this.addLabel(container, String.valueOf(HibernateConsoleMessages.ConsoleConfigurationPropertySource_config_file) + ':');
        this.cfgFile = this.addText(container, this.buildConfigFileHolder());
        this.addButton(container, HibernateConsoleMessages.CodeGenerationSettingsTab_setup, this.createSetupAction());
        this.cfgFile.setLayoutData((Object)gd);
        gd = new GridData(768);
        this.addLabel(container, HibernateConsoleMessages.NewConfigurationWizardPage_database_dialect);
        Combo c = this.addEditableCombo(container, (ListValueModel)lvmDialect, dialectHolder, TransformerTools.objectToStringTransformer(), null);
        gd.horizontalSpan = 2;
        c.setLayoutData((Object)gd);
        this.addLabel(container, HibernateConsoleMessages.NewConfigurationWizardPage_driver_class);
        c = this.addEditableCombo(container, (ListValueModel)lvmDriver, driverHolder, TransformerTools.objectToStringTransformer(), null);
        c.setLayoutData((Object)gd);
        this.addLabel(container, HibernateConsoleMessages.NewConfigurationWizardPage_connection_url);
        c = this.addEditableCombo(container, (ListValueModel)lvmUrl, urlHolder, TransformerTools.objectToStringTransformer(), null);
        c.setLayoutData((Object)gd);
        dialectHolder.addPropertyChangeListener("value", SWTListenerTools.wrap((PropertyChangeListener)new PropertyChangeListener(){

            public void propertyChanged(PropertyChangeEvent event) {
                String dialectClass = HibernatePropertiesComposite.this.helper.getDialectClass((String)event.getNewValue());
                String[] driverClasses = HibernatePropertiesComposite.this.helper.getDriverClasses(dialectClass);
                String driver = (String)driverHolder.getValue();
                lvmDriver.clear();
                lvmDriver.addAll(Arrays.asList(driverClasses));
                driverHolder.setValue((Object)driver);
            }
        }));
        driverHolder.addPropertyChangeListener("value", SWTListenerTools.wrap((PropertyChangeListener)new PropertyChangeListener(){

            public void propertyChanged(PropertyChangeEvent event) {
                String driverClass = (String)event.getNewValue();
                String[] connectionURLS = HibernatePropertiesComposite.this.helper.getConnectionURLS(driverClass);
                String url = (String)urlHolder.getValue();
                lvmUrl.clear();
                lvmUrl.addAll(Arrays.asList(connectionURLS));
                urlHolder.setValue((Object)url);
            }
        }));
        this.addLabel(container, HibernateConsoleMessages.NewConfigurationWizardPage_default_schema);
        c = this.addText(container, this.buildSchemaDefaultHolder());
        c.setLayoutData((Object)gd);
        this.addLabel(container, HibernateConsoleMessages.NewConfigurationWizardPage_default_catalog);
        c = this.addText(container, this.buildCatalogDefaultHolder());
        c.setLayoutData((Object)gd);
        this.addLabel(container, HibernateConsoleMessages.NewConfigurationWizardPage_user_name);
        c = this.addText(container, this.buildUsernameHolder());
        c.setLayoutData((Object)gd);
        this.addLabel(container, HibernateConsoleMessages.NewConfigurationWizardPage_password);
        c = this.addText(container, this.buildPasswordHolder());
        c.setLayoutData((Object)gd);
    }

    private IPath getConfigurationFilePath() {
        String filePath = this.cfgFile.getText().trim();
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IFile[] files = root.findFilesForLocation((IPath)new Path(filePath));
        IPath path = null;
        if (files != null && files.length > 0) {
            path = new Path(files[0].getProject().getName()).append(files[0].getProjectRelativePath());
            filePath = path.toString();
        }
        if (filePath.length() > 0) {
            IPackageFragmentRoot[] allPackageFragmentRoots;
            IPackageFragmentRoot[] iPackageFragmentRootArray = allPackageFragmentRoots = this.getSourcePackageFragmentRoots();
            int n = allPackageFragmentRoots.length;
            int n2 = 0;
            while (n2 < n) {
                IContainer folder;
                IPackageFragmentRoot iPackageFragmentRoot = iPackageFragmentRootArray[n2];
                IResource sourceFolder = iPackageFragmentRoot.getResource();
                if (sourceFolder instanceof IContainer && (folder = (IContainer)sourceFolder).findMember(filePath) != null) {
                    return folder.findMember(filePath).getFullPath();
                }
                ++n2;
            }
        }
        return path;
    }

    public IPackageFragmentRoot[] getSourcePackageFragmentRoots() {
        IProject project;
        IJavaProject jProject;
        BasicHibernateProperties props = (BasicHibernateProperties)this.getSubject();
        if (props != null && (jProject = JavaCore.create((IProject)(project = props.getJpaProject().getProject()))) != null) {
            try {
                IPackageFragmentRoot[] allPackageFragmentRoots = jProject.getAllPackageFragmentRoots();
                LinkedList<IPackageFragmentRoot> sources = new LinkedList<IPackageFragmentRoot>();
                IPackageFragmentRoot[] iPackageFragmentRootArray = allPackageFragmentRoots;
                int n = allPackageFragmentRoots.length;
                int n2 = 0;
                while (n2 < n) {
                    IPackageFragmentRoot iPackageFragmentRoot = iPackageFragmentRootArray[n2];
                    if (!iPackageFragmentRoot.isArchive() && iPackageFragmentRoot.isOpen()) {
                        sources.add(iPackageFragmentRoot);
                    }
                    ++n2;
                }
                return sources.toArray(new IPackageFragmentRoot[0]);
            }
            catch (JavaModelException javaModelException) {}
        }
        return new IPackageFragmentRoot[0];
    }

    private Runnable createSetupAction() {
        return new Runnable(){

            @Override
            public void run() {
                IPath initialPath = HibernatePropertiesComposite.this.getConfigurationFilePath();
                int defaultChoice = 0;
                if (initialPath != null) {
                    defaultChoice = 1;
                }
                MessageDialog dialog = this.createSetupDialog(HibernateConsoleMessages.ConsoleConfigurationMainTab_setup_configuration_file, HibernateConsoleMessages.ConsoleConfigurationMainTab_do_you_want_to_create_new_cfgxml, defaultChoice);
                int answer = dialog.open();
                IPath cfgFile = null;
                if (answer == 0) {
                    cfgFile = this.handleConfigurationFileCreate();
                } else if (answer == 1) {
                    cfgFile = this.handleConfigurationFileBrowse();
                }
                if (cfgFile != null) {
                    HibernatePropertiesComposite.this.cfgFile.setText(this.makeClassPathRelative(cfgFile).toString());
                }
            }

            protected IPath makeClassPathRelative(IPath cfgFile) {
                IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
                IResource res = root.findMember(cfgFile);
                if (res != null && res.exists() && res.getType() == 1) {
                    IPackageFragmentRoot[] allPackageFragmentRoots;
                    IPackageFragmentRoot[] iPackageFragmentRootArray = allPackageFragmentRoots = HibernatePropertiesComposite.this.getSourcePackageFragmentRoots();
                    int n = allPackageFragmentRoots.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IPackageFragmentRoot iPackageFragmentRoot = iPackageFragmentRootArray[n2];
                        if (iPackageFragmentRoot.getResource().getFullPath().isPrefixOf(cfgFile)) {
                            cfgFile = cfgFile.removeFirstSegments(iPackageFragmentRoot.getResource().getFullPath().segmentCount());
                            return cfgFile;
                        }
                        ++n2;
                    }
                }
                return res.getLocation();
            }

            private MessageDialog createSetupDialog(String title, String question, int defaultChoice) {
                return new MessageDialog(HibernatePropertiesComposite.this.getShell(), title, null, question, 3, new String[]{HibernateConsoleMessages.ConsoleConfigurationMainTab_create_new, HibernateConsoleMessages.ConsoleConfigurationMainTab_use_existing, IDialogConstants.CANCEL_LABEL}, defaultChoice);
            }

            private IPath handleConfigurationFileBrowse() {
                IPath[] paths = this.chooseFileEntries();
                if (paths != null && paths.length == 1) {
                    return paths[0];
                }
                return null;
            }

            public IPath[] chooseFileEntries() {
                TypedElementSelectionValidator validator = new TypedElementSelectionValidator(new Class[]{IFile.class}, false);
                IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
                IResource focus = HibernatePropertiesComposite.this.getConfigurationFilePath() != null ? root.findMember(HibernatePropertiesComposite.this.getConfigurationFilePath()) : null;
                ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(HibernatePropertiesComposite.this.getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider(){

                    public Object[] getElements(Object element) {
                        IPackageFragmentRoot[] sourcePackageFragmentRoots = HibernatePropertiesComposite.this.getSourcePackageFragmentRoots();
                        Object[] ress = new IResource[sourcePackageFragmentRoots.length];
                        int i = 0;
                        while (i < sourcePackageFragmentRoots.length) {
                            ress[i] = sourcePackageFragmentRoots[i].getResource();
                            ++i;
                        }
                        return ress;
                    }
                });
                dialog.setValidator((ISelectionStatusValidator)validator);
                dialog.setAllowMultiple(false);
                dialog.setTitle(HibernateConsoleMessages.ConsoleConfigurationMainTab_select_hibernate_cfg_xml_file);
                dialog.setMessage(HibernateConsoleMessages.ConsoleConfigurationMainTab_choose_file_to_use_as_hibernate_cfg_xml);
                dialog.addFilter((ViewerFilter)new FileFilter(new String[]{HibernateConsoleMessages.ConsoleConfigurationMainTab_cfg_xml}, null, true, false));
                dialog.setInput((Object)root);
                dialog.setComparator((ViewerComparator)new ResourceComparator(1));
                dialog.setInitialSelection((Object)focus);
                if (dialog.open() == 0) {
                    Object[] elements = dialog.getResult();
                    IPath[] res = new IPath[elements.length];
                    int i = 0;
                    while (i < res.length) {
                        IResource elem = (IResource)elements[i];
                        res[i] = elem.getFullPath();
                        ++i;
                    }
                    return res;
                }
                return null;
            }

            private IPath handleConfigurationFileCreate() {
                WizardNewFileCreationPage createdFilePath;
                NewConfigurationWizard wizard = new NewConfigurationWizard();
                wizard.init(PlatformUI.getWorkbench(), (IStructuredSelection)StructuredSelection.EMPTY);
                IWorkbenchWindow win = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                WizardDialog wdialog = new WizardDialog(win.getShell(), (IWizard)wizard);
                wdialog.create();
                IWizardPage configPage = wizard.getPage(HibernateConsoleMessages.ConsoleConfigurationMainTab_wizard_page);
                if (configPage != null && configPage instanceof NewConfigurationWizardPage) {
                    ((NewConfigurationWizardPage)configPage).setCreateConsoleConfigurationVisible(false);
                }
                if (wdialog.open() == 0 && (createdFilePath = (WizardNewFileCreationPage)wizard.getStartingPage()) != null) {
                    return createdFilePath.createNewFile().getFullPath();
                }
                return null;
            }
        };
    }

    private ModifiablePropertyValueModel<String> buildConfigFileHolder() {
        return new PropertyAspectAdapter<BasicHibernateProperties, String>(this.getSubjectHolder(), new String[]{"confFileProperty"}){

            protected String buildValue_() {
                return ((BasicHibernateProperties)this.subject).getConfigurationFile();
            }

            protected void setValue_(String value) {
                if ("".equals(value)) {
                    value = null;
                }
                ((BasicHibernateProperties)this.subject).setConfigurationFile(value);
            }
        };
    }

    private ModifiablePropertyValueModel<String> buildDialectHolder() {
        return new PropertyAspectAdapter<BasicHibernateProperties, String>(this.getSubjectHolder(), new String[]{"dialectProperty"}){

            protected String buildValue_() {
                return HibernatePropertiesComposite.this.helper.getShortDialectName(((BasicHibernateProperties)this.subject).getDialect());
            }

            protected void setValue_(String value) {
                if ("".equals(value)) {
                    value = null;
                }
                ((BasicHibernateProperties)this.subject).setDialect(HibernatePropertiesComposite.this.helper.getDialectClass(value));
            }
        };
    }

    private ModifiablePropertyValueModel<String> buildDriverHolder() {
        return new PropertyAspectAdapter<BasicHibernateProperties, String>(this.getSubjectHolder(), new String[]{"driverProperty"}){

            protected String buildValue_() {
                return ((BasicHibernateProperties)this.subject).getDriver();
            }

            protected void setValue_(String value) {
                if ("".equals(value)) {
                    value = null;
                }
                ((BasicHibernateProperties)this.subject).setDriver(value);
            }
        };
    }

    private ModifiablePropertyValueModel<String> buildUrlHolder() {
        return new PropertyAspectAdapter<BasicHibernateProperties, String>(this.getSubjectHolder(), new String[]{"urlProperty"}){

            protected String buildValue_() {
                return ((BasicHibernateProperties)this.subject).getUrl();
            }

            protected void setValue_(String value) {
                if ("".equals(value)) {
                    value = null;
                }
                ((BasicHibernateProperties)this.subject).setUrl(value);
            }
        };
    }

    private ModifiablePropertyValueModel<String> buildSchemaDefaultHolder() {
        return new PropertyAspectAdapter<BasicHibernateProperties, String>(this.getSubjectHolder(), new String[]{"schemaDefaultProperty"}){

            protected String buildValue_() {
                return ((BasicHibernateProperties)this.subject).getSchemaDefault();
            }

            protected void setValue_(String value) {
                if ("".equals(value)) {
                    value = null;
                }
                ((BasicHibernateProperties)this.subject).setSchemaDefault(value);
            }
        };
    }

    private ModifiablePropertyValueModel<String> buildCatalogDefaultHolder() {
        return new PropertyAspectAdapter<BasicHibernateProperties, String>(this.getSubjectHolder(), new String[]{"catalogDefaultProperty"}){

            protected String buildValue_() {
                return ((BasicHibernateProperties)this.subject).getCatalogDefault();
            }

            protected void setValue_(String value) {
                if ("".equals(value)) {
                    value = null;
                }
                ((BasicHibernateProperties)this.subject).setCatalogDefault(value);
            }
        };
    }

    private ModifiablePropertyValueModel<String> buildUsernameHolder() {
        return new PropertyAspectAdapter<BasicHibernateProperties, String>(this.getSubjectHolder(), new String[]{"usernameProperty"}){

            protected String buildValue_() {
                return ((BasicHibernateProperties)this.subject).getUsername();
            }

            protected void setValue_(String value) {
                if ("".equals(value)) {
                    value = null;
                }
                ((BasicHibernateProperties)this.subject).setUsername(value);
            }
        };
    }

    private ModifiablePropertyValueModel<String> buildPasswordHolder() {
        return new PropertyAspectAdapter<BasicHibernateProperties, String>(this.getSubjectHolder(), new String[]{"passwordProperty"}){

            protected String buildValue_() {
                return ((BasicHibernateProperties)this.subject).getPassword();
            }

            protected void setValue_(String value) {
                if ("".equals(value)) {
                    value = null;
                }
                ((BasicHibernateProperties)this.subject).setPassword(value);
            }
        };
    }

    public Image getPageImage() {
        return null;
    }
}

