/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.freemarker.model;

import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.source.ISourceViewer;
import org.jboss.ide.eclipse.freemarker.configuration.ConfigurationManager;
import org.jboss.ide.eclipse.freemarker.configuration.MacroLibrary;
import org.jboss.ide.eclipse.freemarker.model.AbstractDirective;
import org.jboss.ide.eclipse.freemarker.model.AbstractItem;
import org.jboss.ide.eclipse.freemarker.model.Item;
import org.jboss.ide.eclipse.freemarker.model.ItemSet;
import org.jboss.ide.eclipse.freemarker.model.MacroDirective;
import org.jboss.ide.eclipse.freemarker.model.MacroEndInstance;

public class MacroInstance
extends AbstractDirective {
    private MacroEndInstance endInstance;
    private String name;
    private Item[] relatedItems;

    public MacroInstance(ItemSet itemSet) {
        super(itemSet);
    }

    @Override
    protected void init(ITypedRegion region, ISourceViewer viewer, IResource resource) throws Exception {
        this.name = this.getSplitValue(0);
    }

    @Override
    public boolean isStartItem() {
        return true;
    }

    @Override
    public void relateItem(Item directive) {
        if (directive instanceof MacroEndInstance) {
            this.endInstance = (MacroEndInstance)directive;
        }
    }

    @Override
    public boolean relatesToItem(Item directive) {
        if (directive instanceof MacroEndInstance) {
            MacroEndInstance endDirective = (MacroEndInstance)directive;
            return endDirective.getName() == null || endDirective.getName().length() == 0 || endDirective.getName().equals(this.getName());
        }
        return false;
    }

    public MacroEndInstance getEndDirective() {
        return this.endInstance;
    }

    @Override
    public Item[] getRelatedItems() {
        if (this.relatedItems == null) {
            ArrayList<MacroEndInstance> l = new ArrayList<MacroEndInstance>();
            if (this.getEndDirective() != null) {
                l.add(this.getEndDirective());
            }
            this.relatedItems = l.toArray(new Item[l.size()]);
        }
        return this.relatedItems;
    }

    @Override
    public String getTreeImage() {
        return "macro_instance.png";
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public ICompletionProposal[] getCompletionProposals(int offset, Map<String, Class<?>> context) {
        AbstractItem.ContentWithOffset contentWithOffset = this.splitContents(offset);
        int index = contentWithOffset.getIndex();
        int subOffset = contentWithOffset.getOffsetInIndex();
        String[] contents = contentWithOffset.getContents();
        if (index == 0 && !contentWithOffset.wasLastCharSpace()) {
            String prefix = contents[index].substring(0, subOffset);
            ArrayList<ICompletionProposal> l = new ArrayList<ICompletionProposal>();
            for (MacroDirective macro : this.getItemSet().getMacroDefinitions()) {
                if (!macro.getName().startsWith(prefix)) continue;
                l.add(this.getCompletionProposal(offset, subOffset, macro.getName(), contents[0]));
            }
            MacroLibrary[] libraries = ConfigurationManager.getInstance(this.getResource().getProject()).getMacroLibraries();
            int i = 0;
            while (i < libraries.length) {
                int j = 0;
                while (j < libraries[i].getMacros().length) {
                    MacroDirective macro = libraries[i].getMacros()[j];
                    if (macro.getName().startsWith(prefix)) {
                        l.add(this.getCompletionProposal(offset, subOffset, macro.getName(), contents[0]));
                    }
                    ++j;
                }
                ++i;
            }
            return this.completionProposals(l);
        }
        if (contentWithOffset.wasLastCharSpace() || !contents[index - 1].equals("=")) {
            String name = contents[0];
            MacroDirective match = null;
            for (MacroDirective macro : this.getItemSet().getMacroDefinitions()) {
                if (!macro.getName().equals(name)) continue;
                match = macro;
                break;
            }
            if (match == null) {
                MacroLibrary[] libraries = ConfigurationManager.getInstance(this.getResource().getProject()).getMacroLibraries();
                int i = 0;
                while (i < libraries.length) {
                    int j = 0;
                    while (j < libraries[i].getMacros().length) {
                        MacroDirective macro = libraries[i].getMacros()[j];
                        if (macro.getName().equals(name)) {
                            match = macro;
                            break;
                        }
                        ++j;
                    }
                    if (match != null) break;
                    ++i;
                }
            }
            if (match != null) {
                String prefix = null;
                prefix = contentWithOffset.wasLastCharSpace() || contents.length < index + 1 ? "" : contents[index].substring(0, subOffset);
                ArrayList<ICompletionProposal> l = new ArrayList<ICompletionProposal>();
                int i = 0;
                while (i < match.getAttributes().length) {
                    if (match.getAttributes()[i].startsWith(prefix)) {
                        l.add(this.getCompletionProposal(offset, subOffset, match.getAttributes()[i], contentWithOffset.isNextCharSpace() || contents.length < index + 1 ? "" : contents[index]));
                    }
                    ++i;
                }
                return this.completionProposals(l);
            }
        }
        return null;
    }
}

