/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.freemarker.model;

import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.source.ISourceViewer;
import org.jboss.ide.eclipse.freemarker.model.AbstractDirective;
import org.jboss.ide.eclipse.freemarker.model.AbstractItem;
import org.jboss.ide.eclipse.freemarker.model.CompletionInterpolation;
import org.jboss.ide.eclipse.freemarker.model.Item;
import org.jboss.ide.eclipse.freemarker.model.ItemSet;
import org.jboss.ide.eclipse.freemarker.model.ListEndDirective;

public class ListDirective
extends AbstractDirective {
    private ListEndDirective endDirective;

    public ListDirective(ItemSet itemSet) {
        super(itemSet);
    }

    @Override
    protected void init(ITypedRegion region, ISourceViewer viewer, IResource resource) throws Exception {
    }

    @Override
    public boolean isStartItem() {
        return true;
    }

    @Override
    public void relateItem(Item directive) {
        if (directive instanceof ListEndDirective) {
            this.endDirective = (ListEndDirective)directive;
        }
    }

    @Override
    public boolean relatesToItem(Item directive) {
        return directive instanceof ListEndDirective;
    }

    @Override
    public boolean isNestable() {
        return true;
    }

    public ListEndDirective getEndDirective() {
        return this.endDirective;
    }

    @Override
    public Item getRelatedItem() {
        return this.getEndDirective();
    }

    @Override
    public String getTreeImage() {
        return "list.png";
    }

    @Override
    public ICompletionProposal[] getCompletionProposals(int offset, Map<String, Class<?>> context) {
        AbstractItem.ContentWithOffset contentWithOffset;
        int index;
        ICompletionProposal[] proposals = super.getCompletionProposals(offset, context);
        if (proposals == null && ((index = (contentWithOffset = this.splitContents(offset)).getIndex()) == 1 || index == 0 && contentWithOffset.wasLastCharSpace())) {
            String value = "";
            if (contentWithOffset.getContents().length >= 2) {
                value = contentWithOffset.getContents()[1];
            }
            CompletionInterpolation completionInterpolation = new CompletionInterpolation(this.getItemSet(), "${" + value, offset - contentWithOffset.getOffsetInIndex() - 2, this.getResource());
            proposals = completionInterpolation.getCompletionProposals(offset, context);
        }
        return proposals;
    }

    @Override
    public void addToContext(Map<String, Class<?>> context) {
        String[] contents = this.splitContents();
        if (contents.length == 4) {
            String key = contents[3];
            CompletionInterpolation completionInterpolation = new CompletionInterpolation(this.getItemSet(), "${" + contents[1], 0, this.getResource());
            context.put(key, completionInterpolation.getSingularReturnClass(context));
        }
    }

    @Override
    public void removeFromContext(Map<String, Class<?>> context) {
        String[] contents = this.splitContents();
        if (contents.length == 4) {
            String key = contents[3];
            context.remove(key);
        }
    }

    @Override
    public Item getEndItem() {
        return this.endDirective;
    }
}

