/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.freemarker.model;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.source.ISourceViewer;
import org.jboss.ide.eclipse.freemarker.model.AbstractDirective;
import org.jboss.ide.eclipse.freemarker.model.Item;
import org.jboss.ide.eclipse.freemarker.model.ItemSet;
import org.jboss.ide.eclipse.freemarker.model.interpolation.BuiltInFragment;
import org.jboss.ide.eclipse.freemarker.model.interpolation.Fragment;
import org.jboss.ide.eclipse.freemarker.model.interpolation.NameFragment;
import org.jboss.ide.eclipse.freemarker.model.interpolation.NullFragment;
import org.jboss.ide.eclipse.freemarker.model.interpolation.ParametersFragment;
import org.jboss.ide.eclipse.freemarker.model.interpolation.StringFragment;

public class Interpolation
extends AbstractDirective {
    private List<Fragment> fragments;

    public Interpolation(ItemSet itemSet) {
        super(itemSet);
    }

    @Override
    protected void init(ITypedRegion region, ISourceViewer viewer, IResource resource) throws Exception {
    }

    @Override
    public String getTreeImage() {
        return "interpolation.png";
    }

    @Override
    public synchronized ICompletionProposal[] getCompletionProposals(int offset, Map<String, Class<?>> context) {
        Item parent = this.getParentItem();
        ArrayList<Item> parents = new ArrayList<Item>();
        Item tempItem = this.getParentItem();
        while (parent != null) {
            parents.add(0, parent);
            parent = parent.getParentItem();
            if (parent == null) continue;
            tempItem = parent;
        }
        if (tempItem == null) {
            tempItem = this;
        }
        Item[] items = this.getItemSet().getRootItems();
        int i = 0;
        while (i < items.length) {
            Item item = items[i];
            if (tempItem.equals(item)) break;
            if (item.isStartItem()) {
                item.addToContext(context);
                if (item.getEndItem() != null && item.getEndItem().getRegion().getOffset() < offset - 1) {
                    item.removeFromContext(context);
                }
            } else {
                item.addToContext(context);
            }
            ++i;
        }
        for (Item item : parents) {
            for (Item item2 : item.getChildItems()) {
                if (parents.contains(item2)) break;
                item2.addToContext(context);
            }
            item.addToContext(context);
        }
        this.initFragments();
        int subOffset = offset - this.getOffset() - 2;
        if (subOffset < 0) {
            return null;
        }
        Fragment fragment = null;
        for (Fragment fragmentSub : this.fragments) {
            if (fragmentSub.getOffset() > subOffset) break;
            fragment = fragmentSub;
        }
        if (fragment != null) {
            Class<?> parentClass = null;
            for (Fragment fragmentSub : this.fragments) {
                if (fragmentSub.equals(fragment)) break;
                parentClass = fragmentSub.getReturnClass(parentClass, this.fragments, context, this.getResource(), this.getResource().getProject());
            }
            return fragment.getCompletionProposals(subOffset - fragment.getOffset(), offset, parentClass, this.fragments, this.getViewer(), context, this.getResource(), this.getResource().getProject());
        }
        if (this.getContents().length() == 0 && subOffset == 0) {
            return new NullFragment().getCompletionProposals(subOffset, offset, null, this.fragments, this.getViewer(), context, this.getResource(), this.getResource().getProject());
        }
        return null;
    }

    private synchronized void initFragments() {
        if (this.fragments != null) {
            return;
        }
        this.fragments = new ArrayList<Fragment>();
        StringBuilder sb = new StringBuilder();
        String contents = this.getFullContents();
        contents = contents.substring(2, contents.length() - 1);
        int offsetStart = 0;
        boolean inString = false;
        boolean inBuiltIn = false;
        boolean inNameFragment = false;
        boolean inParameters = false;
        boolean escape = false;
        boolean doEscape = false;
        int i = 0;
        while (i < contents.length()) {
            doEscape = false;
            char c = contents.charAt(i);
            if (!(!Character.isLetterOrDigit(c) || inString || inBuiltIn || inNameFragment || inParameters)) {
                inNameFragment = true;
            }
            if (inNameFragment) {
                if (c == '?') {
                    this.fragments.add(new NameFragment(offsetStart, sb.toString()));
                    offsetStart = i;
                    sb.delete(0, sb.length());
                    inNameFragment = false;
                    inBuiltIn = true;
                } else if (c == '(') {
                    this.fragments.add(new NameFragment(offsetStart, sb.toString()));
                    offsetStart = i;
                    sb.delete(0, sb.length());
                    inNameFragment = false;
                    inParameters = true;
                } else if (c == '.') {
                    this.fragments.add(new NameFragment(offsetStart, sb.toString()));
                    offsetStart = i;
                    sb.delete(0, sb.length());
                    inNameFragment = true;
                    sb.append(c);
                } else if (c == ')') {
                    this.fragments.add(new NameFragment(offsetStart, sb.toString()));
                    offsetStart = i + 1;
                    sb.delete(0, sb.length());
                    inNameFragment = false;
                } else {
                    sb.append(c);
                }
            } else if (inBuiltIn) {
                if (c == '?') {
                    this.fragments.add(new BuiltInFragment(offsetStart, sb.toString()));
                    offsetStart = i;
                    sb.delete(0, sb.length());
                } else if (c == ')') {
                    this.fragments.add(new BuiltInFragment(offsetStart, sb.toString()));
                    offsetStart = i + 1;
                    sb.delete(0, sb.length());
                    inBuiltIn = false;
                } else if (c == '.') {
                    this.fragments.add(new BuiltInFragment(offsetStart, sb.toString()));
                    inNameFragment = true;
                    offsetStart = i;
                    sb.delete(0, sb.length());
                    inBuiltIn = false;
                    sb.append(c);
                } else {
                    sb.append(c);
                }
            } else if (inParameters) {
                if (inString && !escape && c == '\"') {
                    inString = false;
                }
                if (!inString && c == ')') {
                    this.fragments.add(new ParametersFragment(offsetStart, sb.toString()));
                    offsetStart = i + 1;
                    sb.delete(0, sb.length());
                } else {
                    sb.append(c);
                }
            } else if (inString) {
                if (escape) {
                    sb.append(c);
                } else if (c == '\"') {
                    this.fragments.add(new StringFragment(offsetStart, sb.toString()));
                    offsetStart = i + 1;
                    sb.delete(0, sb.length());
                } else if (c == '\\') {
                    doEscape = true;
                    sb.append(c);
                } else {
                    sb.append(c);
                }
            } else if (c == '.') {
                if (sb.length() > 0) {
                    if (inBuiltIn) {
                        this.fragments.add(new BuiltInFragment(offsetStart, sb.toString()));
                    } else {
                        this.fragments.add(new NameFragment(offsetStart, sb.toString()));
                    }
                }
                inNameFragment = true;
                offsetStart = i;
                sb.delete(0, sb.length());
            } else if (c == '?') {
                if (inBuiltIn) {
                    this.fragments.add(new BuiltInFragment(offsetStart, sb.toString()));
                } else {
                    this.fragments.add(new NameFragment(offsetStart, sb.toString()));
                }
                inBuiltIn = true;
                offsetStart = i;
                sb.delete(0, sb.length());
            } else if (c == '(') {
                if (this.fragments.size() != 0) {
                    if (sb.length() > 0 && !inBuiltIn) {
                        this.fragments.add(new NameFragment(offsetStart, sb.toString()));
                    }
                    inParameters = true;
                    offsetStart = i;
                    sb.delete(0, sb.length());
                }
            } else if (c == '\"') {
                if (sb.length() > 0) {
                    this.fragments.add(new NameFragment(offsetStart, sb.toString()));
                }
                inString = true;
                offsetStart = i;
                sb.delete(0, sb.length());
            } else {
                sb.append(c);
            }
            escape = doEscape;
            ++i;
        }
        if (sb.length() > 0 || inBuiltIn) {
            if (inBuiltIn) {
                this.fragments.add(new BuiltInFragment(offsetStart, sb.toString()));
            } else {
                this.fragments.add(new NameFragment(offsetStart, sb.toString()));
            }
        }
    }

    @Override
    public boolean isNestable() {
        return false;
    }

    public Class<?> getReturnClass(Map<String, Class<?>> context) {
        this.initFragments();
        Class<?> returnClass = null;
        for (Fragment fragment : this.fragments) {
            returnClass = fragment.getReturnClass(returnClass, this.fragments, context, this.getResource(), this.getResource().getProject());
        }
        return returnClass;
    }

    public Class<?> getSingularReturnClass(Map<String, Class<?>> context) {
        this.initFragments();
        Class<?> returnClass = null;
        Iterator<Fragment> i = this.fragments.iterator();
        while (i.hasNext()) {
            Fragment fragment = i.next();
            returnClass = i.hasNext() ? fragment.getReturnClass(returnClass, this.fragments, context, this.getResource(), this.getResource().getProject()) : fragment.getSingularReturnClass(returnClass, this.fragments, context, this.getResource(), this.getResource().getProject());
        }
        return returnClass;
    }
}

