/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.freemarker.model;

import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.TypedRegion;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.source.ISourceViewer;
import org.jboss.ide.eclipse.freemarker.Plugin;
import org.jboss.ide.eclipse.freemarker.model.AbstractDirective;
import org.jboss.ide.eclipse.freemarker.model.IfDirective;
import org.jboss.ide.eclipse.freemarker.model.ItemSet;
import org.jboss.ide.eclipse.freemarker.model.ListDirective;

public class CompletionDirective
extends AbstractDirective {
    private String contents;
    private int offset;
    private int length;
    private AbstractDirective directive = this;

    public CompletionDirective(ItemSet itemSet, int offset, int length, ISourceViewer viewer, IResource resource) throws BadLocationException {
        super(itemSet);
        this.contents = viewer.getDocument().get(offset, length);
        TypedRegion region = new TypedRegion(offset, this.contents.length(), "default");
        this.offset = offset;
        this.length = length;
        String[] arr = this.splitContents();
        if (arr != null && arr.length > 0) {
            String s = arr[0];
            try {
                if (s.equals("list")) {
                    this.directive = new ListDirective(itemSet);
                    this.directive.load((ITypedRegion)new TypedRegion(offset, this.contents.length(), "list"), viewer, resource);
                } else if (s.equals("if")) {
                    this.directive = new IfDirective(itemSet);
                    this.directive.load((ITypedRegion)new TypedRegion(offset, this.contents.length(), "if"), viewer, resource);
                }
            }
            catch (Exception e) {
                Plugin.log(e);
                this.directive = this;
            }
        }
        try {
            this.load((ITypedRegion)region, viewer, resource);
        }
        catch (Exception e) {
            Plugin.log(e);
        }
    }

    @Override
    public int getOffset() {
        return this.offset;
    }

    @Override
    public String getFullContents() {
        return this.contents;
    }

    @Override
    public int getLength() {
        return this.length;
    }

    @Override
    public ICompletionProposal[] getCompletionProposals(int offset, Map<String, Class<?>> context) {
        if (this.directive.equals(this)) {
            return super.getCompletionProposals(offset, context);
        }
        return this.directive.getCompletionProposals(offset, context);
    }

    @Override
    protected void init(ITypedRegion region, ISourceViewer viewer, IResource resource) throws Exception {
    }
}

