/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.freemarker.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.jboss.ide.eclipse.freemarker.model.AbstractItem;
import org.jboss.ide.eclipse.freemarker.model.CompletionInterpolation;
import org.jboss.ide.eclipse.freemarker.model.ItemSet;

public abstract class AbstractDirective
extends AbstractItem {
    String contents;
    public static String[] directives = new String[]{"if", "else", "elseif", "switch", "case", "default", "break", "list", "break", "include", "import", "noparse", "compress", "escape", "noescape", "assign", "global", "local", "setting", "macro", "nested", "return", "flush", "function", "stop", "ftl", "t", "lt", "rt", "nt", "attempt", "recover", "visit", "recurse", "fallback"};
    private static final Comparator<ICompletionProposal> COMPLETION_PROPOSAL_COMPARATOR = new Comparator<ICompletionProposal>(){

        @Override
        public int compare(ICompletionProposal arg0, ICompletionProposal arg1) {
            return arg0.getDisplayString().compareTo(arg1.getDisplayString());
        }
    };

    public AbstractDirective(ItemSet itemSet) {
        super(itemSet);
    }

    @Override
    public String getContents() {
        if (this.contents == null) {
            this.contents = super.getContents();
            if (this.contents != null) {
                try {
                    this.contents = this.contents.substring(2, this.contents.length() - 1);
                }
                catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {}
            }
        }
        return this.contents;
    }

    @Override
    public ICompletionProposal[] getCompletionProposals(int offset, Map<String, Class<?>> context) {
        if (offset < 2) {
            return null;
        }
        AbstractItem.ContentWithOffset contentWithOffset = this.splitContents(offset);
        int index = contentWithOffset.getIndex();
        if (index == 0) {
            int subOffset = contentWithOffset.getOffsetInIndex();
            String[] contentWithOffsetContents = contentWithOffset.getContents();
            if (contentWithOffset.wasLastCharSpace()) {
                if (contentWithOffsetContents.length == 1) {
                    CompletionInterpolation completionInterpolation = new CompletionInterpolation(this.getItemSet(), "${", offset - contentWithOffset.getOffsetInIndex() - 2, this.getResource());
                    return completionInterpolation.getCompletionProposals(offset, context);
                }
                return null;
            }
            String prefix = contentWithOffsetContents[index].substring(0, subOffset);
            ArrayList<ICompletionProposal> l = new ArrayList<ICompletionProposal>();
            int i = 0;
            while (i < directives.length) {
                String name = directives[i];
                if (name.startsWith(prefix)) {
                    l.add(this.getCompletionProposal(offset, subOffset, name, contentWithOffsetContents[0]));
                }
                ++i;
            }
            return this.completionProposals(l);
        }
        if (index == 1 && !contentWithOffset.wasLastCharSpace()) {
            String value = "";
            try {
                value = contentWithOffset.getContents()[index].substring(0, contentWithOffset.getOffsetInIndex());
            }
            catch (Exception exception) {}
            CompletionInterpolation completionInterpolation = new CompletionInterpolation(this.getItemSet(), "${" + value, offset - contentWithOffset.getOffsetInIndex() - 2, this.getResource());
            return completionInterpolation.getCompletionProposals(offset, context);
        }
        return null;
    }

    public ICompletionProposal[] completionProposals(List<ICompletionProposal> l) {
        Collections.sort(l, COMPLETION_PROPOSAL_COMPARATOR);
        return l.toArray(new ICompletionProposal[l.size()]);
    }

    public ICompletionProposal getCompletionProposal(int offset, int subOffset, String replacementString, String replacingString) {
        return new CompletionProposal(replacementString, offset - subOffset, replacingString.length(), replacementString.length());
    }
}

