/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.freemarker.editor.partitions;

import java.util.ArrayList;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.jface.text.rules.IPredicateRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.RuleBasedPartitionScanner;
import org.eclipse.jface.text.rules.Token;
import org.jboss.ide.eclipse.freemarker.editor.DocumentProvider;
import org.jboss.ide.eclipse.freemarker.editor.SyntaxModeListener;
import org.jboss.ide.eclipse.freemarker.editor.partitions.PartitionType;
import org.jboss.ide.eclipse.freemarker.lang.SyntaxMode;

public class PartitionScanner
implements IPartitionTokenScanner,
SyntaxModeListener {
    private SyntaxMode syntaxMode = SyntaxMode.getDefault();
    private ScannerState nextState;
    private ScannerState currentState;
    private final RuleBasedPartitionScanner delegate = new RuleBasedPartitionScanner();
    private final IToken defaultReturnToken;
    private IPredicateRule[] predicateRules;

    public PartitionScanner() {
        PartitionType[] partitionTypes = PartitionType.values();
        ArrayList<IPredicateRule> rules = new ArrayList<IPredicateRule>(partitionTypes.length);
        PartitionType[] partitionTypeArray = partitionTypes;
        int n = partitionTypes.length;
        int n2 = 0;
        while (n2 < n) {
            PartitionType partitionType = partitionTypeArray[n2];
            IPredicateRule rule = partitionType.createPartitioningRule();
            if (rule != null) {
                rules.add(rule);
            }
            ++n2;
        }
        this.setPredicateRules(rules.toArray(new IPredicateRule[rules.size()]));
        this.defaultReturnToken = new Token((Object)PartitionType.TEXT.name());
        this.delegate.setDefaultReturnToken(this.defaultReturnToken);
    }

    private void setPredicateRules(IPredicateRule[] rules) {
        this.predicateRules = rules;
        this.delegate.setPredicateRules(rules);
    }

    public void setPartialRange(IDocument document, int offset, int length, String contentType, int partitionOffset) {
        SyntaxMode newMode;
        if (offset == 0 && (newMode = DocumentProvider.findMode(document)) != this.syntaxMode) {
            this.syntaxModeChanged(newMode);
        }
        this.delegate.setPartialRange(document, offset, length, contentType, partitionOffset);
    }

    @Override
    public void syntaxModeChanged(SyntaxMode syntaxMode) {
        if (this.predicateRules != null) {
            IPredicateRule[] iPredicateRuleArray = this.predicateRules;
            int n = this.predicateRules.length;
            int n2 = 0;
            while (n2 < n) {
                IPredicateRule rule = iPredicateRuleArray[n2];
                if (rule instanceof SyntaxModeListener) {
                    ((SyntaxModeListener)rule).syntaxModeChanged(syntaxMode);
                }
                ++n2;
            }
        }
        this.syntaxMode = syntaxMode;
    }

    public IToken nextToken() {
        this.currentState = this.nextState;
        IToken nextToken = this.delegate.nextToken();
        while (this.currentState.token == this.defaultReturnToken && nextToken == this.defaultReturnToken) {
            int newOffset = this.delegate.getTokenOffset();
            int newLength = this.delegate.getTokenLength();
            this.currentState.length = newOffset - this.currentState.offset + newLength;
            nextToken = this.delegate.nextToken();
        }
        this.nextState = new ScannerState(this.delegate.getTokenOffset(), this.delegate.getTokenLength(), nextToken);
        return this.currentState.getToken();
    }

    public int getTokenOffset() {
        return this.currentState.getOffset();
    }

    public int getTokenLength() {
        return this.currentState.getLength();
    }

    public void setRange(IDocument document, int offset, int length) {
        this.delegate.setRange(document, offset, length);
        IToken nextToken = this.delegate.nextToken();
        this.nextState = new ScannerState(this.delegate.getTokenOffset(), this.delegate.getTokenLength(), nextToken);
    }

    private static class ScannerState {
        private final int offset;
        private int length;
        private final IToken token;

        public ScannerState(int offset, int length, IToken token) {
            this.offset = offset;
            this.length = length;
            this.token = token;
        }

        public int getOffset() {
            return this.offset;
        }

        public int getLength() {
            return this.length;
        }

        public IToken getToken() {
            return this.token;
        }
    }
}

