/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.freemarker.editor;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.Token;
import org.jboss.ide.eclipse.freemarker.editor.partitions.PartitionType;
import org.jboss.ide.eclipse.freemarker.lang.ParserUtils;
import org.jboss.ide.eclipse.freemarker.preferences.Preferences;
import org.jboss.ide.eclipse.freemarker.util.RobustStack;

public class ContentScanner
implements ITokenScanner {
    private IDocument document;
    private int endOffset;
    private RobustStack<ColoringStyle> styleStack = new RobustStack<ColoringStyle>(ColoringStyle.UNKNOWN);
    private IToken defaultToken;
    private int tokenOffset;
    private int tokenLength;
    private RobustStack<Character> expressionStack = new RobustStack<Character>(Character.valueOf('\u0000'));
    private int currentOffset;

    public static IToken createColoredToken(Preferences.PreferenceKey preferenceKey) {
        return new Token((Object)new TextAttribute(Preferences.getInstance().getColor(preferenceKey)));
    }

    public ContentScanner(IToken defaultToken) {
        this.defaultToken = defaultToken;
    }

    public void setRange(IDocument document, int offset, int length) {
        this.document = document;
        this.currentOffset = offset;
        this.endOffset = offset + length;
        this.styleStack.clear();
        this.expressionStack.clear();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IToken nextToken() {
        int offsetStart = this.currentOffset;
        int i = this.currentOffset;
        boolean escape = false;
        boolean doEscape = false;
        try {
            char c = this.document.getChar(i);
            char cNext = '\u0000';
            if (this.document.getLength() > i + 2) {
                cNext = this.document.getChar(i + 1);
            }
            if (i >= this.endOffset) {
                return Token.EOF;
            }
            while (i < this.endOffset) {
                block24: {
                    char expressionStackPeek;
                    block31: {
                        ColoringStyle type;
                        block30: {
                            block29: {
                                block28: {
                                    block27: {
                                        block26: {
                                            block25: {
                                                doEscape = false;
                                                if (escape) break block24;
                                                type = this.styleStack.peek();
                                                if (c != '\\') break block25;
                                                if (type.equals((Object)ColoringStyle.STRING)) {
                                                    doEscape = true;
                                                }
                                                break block24;
                                            }
                                            if (c != '\"' && c != '\'') break block26;
                                            if (type == ColoringStyle.STRING) {
                                                if (c == this.expressionStack.peek().charValue()) {
                                                    this.tokenOffset = offsetStart;
                                                    this.tokenLength = i - offsetStart + 1;
                                                    this.currentOffset = i + 1;
                                                    this.styleStack.pop();
                                                    return type.getToken();
                                                }
                                                break block24;
                                            } else {
                                                if (i != offsetStart) {
                                                    this.tokenOffset = offsetStart;
                                                    this.tokenLength = i - offsetStart;
                                                    this.currentOffset = i;
                                                    return type.getToken();
                                                }
                                                this.styleStack.push(ColoringStyle.STRING);
                                                this.expressionStack.push(Character.valueOf(c));
                                            }
                                            break block24;
                                        }
                                        if (c != '$') break block27;
                                        if (cNext == '{') {
                                            this.tokenOffset = offsetStart;
                                            this.tokenLength = i - offsetStart;
                                            this.currentOffset = i;
                                            if (i != offsetStart) {
                                                return type.getToken();
                                            }
                                            this.styleStack.push(ColoringStyle.INTERPOLATION);
                                        }
                                        break block24;
                                    }
                                    if (c != '}') break block28;
                                    if (type == ColoringStyle.INTERPOLATION) {
                                        this.tokenOffset = offsetStart;
                                        this.tokenLength = i - offsetStart + 1;
                                        this.currentOffset = i + 1;
                                        this.styleStack.pop();
                                        return type.getToken();
                                    }
                                    break block24;
                                }
                                if (c != '(') break block29;
                                if (type == ColoringStyle.INTERPOLATION) {
                                    this.styleStack.push(ColoringStyle.BRACKET_EXPRESSION);
                                }
                                break block24;
                            }
                            if (c != ')') break block30;
                            if (type == ColoringStyle.BRACKET_EXPRESSION) {
                                this.styleStack.pop();
                            }
                            break block24;
                        }
                        if (c != '<' && c != '[' || (this.styleStack.contains(ColoringStyle.DIRECTIVE) || this.styleStack.contains(ColoringStyle.INTERPOLATION)) && this.styleStack.contains(ColoringStyle.STRING)) break block31;
                        if (cNext == '#') {
                            if (i != offsetStart) {
                                this.tokenOffset = offsetStart;
                                this.tokenLength = i - offsetStart - 1;
                                this.currentOffset = i;
                                return type.getToken();
                            }
                            this.expressionStack.push(Character.valueOf(c));
                            this.styleStack.push(ColoringStyle.DIRECTIVE);
                            break block24;
                        } else if (cNext == '@') {
                            if (i != offsetStart) {
                                this.tokenOffset = offsetStart;
                                this.tokenLength = i - offsetStart - 1;
                                this.currentOffset = i;
                                return type.getToken();
                            }
                            this.expressionStack.push(Character.valueOf(c));
                            this.styleStack.push(ColoringStyle.DIRECTIVE);
                        }
                        break block24;
                    }
                    if (!(!ParserUtils.isClosingDirectiveBracket(c) || (this.styleStack.contains(ColoringStyle.DIRECTIVE) || this.styleStack.contains(ColoringStyle.INTERPOLATION)) && this.styleStack.contains(ColoringStyle.STRING) || (expressionStackPeek = this.expressionStack.peek().charValue()) != ParserUtils.getMatchingLeftBracket(c) && expressionStackPeek != '\u0000')) {
                        this.tokenOffset = offsetStart;
                        this.tokenLength = i - offsetStart + 1;
                        this.currentOffset = i + 1;
                        if (expressionStackPeek != '\u0000') {
                            this.styleStack.pop();
                            return ColoringStyle.DIRECTIVE.getToken();
                        }
                        return ColoringStyle.UNKNOWN.getToken();
                    }
                }
                c = this.document.getChar(++i);
                cNext = '\u0000';
                if (this.document.getLength() > i + 2) {
                    cNext = this.document.getChar(i + 1);
                }
                escape = doEscape;
            }
        }
        catch (BadLocationException badLocationException) {
            this.currentOffset = i;
            this.tokenOffset = offsetStart;
            this.tokenLength = this.endOffset - this.tokenOffset;
            if (this.tokenLength > 0) {
                return this.defaultToken;
            }
            return Token.EOF;
        }
        this.currentOffset = i + 1;
        this.tokenOffset = offsetStart;
        this.tokenLength = this.endOffset - this.tokenOffset;
        return this.styleStack.peek().getToken();
    }

    public int getTokenOffset() {
        return this.tokenOffset;
    }

    public int getTokenLength() {
        return this.tokenLength;
    }

    static enum ColoringStyle {
        UNKNOWN(PartitionType.createColoringToken(Preferences.PreferenceKey.COLOR_TEXT)),
        INTERPOLATION(PartitionType.createColoringToken(Preferences.PreferenceKey.COLOR_INTERPOLATION)),
        DIRECTIVE(PartitionType.createColoringToken(Preferences.PreferenceKey.COLOR_DIRECTIVE)),
        STRING(PartitionType.createColoringToken(Preferences.PreferenceKey.COLOR_STRING)),
        BRACKET_EXPRESSION(PartitionType.createColoringToken(Preferences.PreferenceKey.COLOR_INTERPOLATION));

        private final IToken token;

        private ColoringStyle(IToken token) {
            this.token = token;
        }

        public IToken getToken() {
            return this.token;
        }
    }
}

