/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.freemarker.dialogs;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.window.ApplicationWindow;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.jboss.ide.eclipse.freemarker.Messages;
import org.jboss.ide.eclipse.freemarker.configuration.ConfigurationManager;
import org.jboss.ide.eclipse.freemarker.configuration.ContextValue;

public class ContextValueDialog
extends Dialog {
    private IResource resource;
    private ContextValue contextValue;
    private Text keyText;
    private Text valueText;
    private Text singleValueText;
    private Label singleLabel;
    private Button singleBrowse;

    public ContextValueDialog(Shell parentShell, ContextValue contextValue, IResource resource) {
        super(parentShell);
        this.resource = resource;
        this.contextValue = contextValue;
    }

    protected void configureShell(Shell newShell) {
        newShell.setText(Messages.ContextValueDialog_SHELL_CONTEXT_VALUE_CONFIG);
        super.configureShell(newShell);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(3, false));
        Label label = new Label(composite, 0);
        label.setText(Messages.ContextValueDialog_LABEL_NAME);
        this.keyText = new Text(composite, 2048);
        if (this.contextValue != null) {
            this.keyText.setText(this.contextValue.name);
            this.keyText.setEnabled(false);
        }
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        gd.widthHint = 200;
        this.keyText.setLayoutData((Object)gd);
        label = new Label(composite, 0);
        label.setText(Messages.ContextValueDialog_LABEL_TYPE);
        this.valueText = new Text(composite, 2048);
        this.valueText.setEnabled(false);
        this.valueText.setBackground(new Color(null, 255, 255, 255));
        gd = new GridData(768);
        gd.widthHint = 250;
        this.valueText.setLayoutData((Object)gd);
        if (this.contextValue != null && this.contextValue.objClass != null) {
            this.valueText.setText(this.contextValue.objClass.getName());
        }
        Button browse = new Button(composite, 8);
        browse.setText(Messages.ContextValueDialog_BUTTON_BROWSE);
        browse.addMouseListener(new MouseListener(){

            public void mouseDown(MouseEvent e) {
                try {
                    IJavaProject javaProject = JavaCore.create((IProject)ContextValueDialog.this.resource.getProject());
                    if (javaProject != null) {
                        IJavaSearchScope searchScope = SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{javaProject});
                        SelectionDialog sd = JavaUI.createTypeDialog((Shell)ContextValueDialog.this.getShell(), (IRunnableContext)new ApplicationWindow(ContextValueDialog.this.getShell()), (IJavaSearchScope)searchScope, (int)2, (boolean)false);
                        sd.open();
                        Object[] objects = sd.getResult();
                        if (objects != null && objects.length > 0) {
                            IType type = (IType)objects[0];
                            String fullyQualifiedName = type.getFullyQualifiedName('.');
                            ContextValueDialog.this.valueText.setText(type.getFullyQualifiedName());
                            String[] interfaces = type.getSuperInterfaceNames();
                            boolean isList = false;
                            if ("java.lang.Object".equals(fullyQualifiedName)) {
                                isList = true;
                            } else {
                                int i = 0;
                                while (i < interfaces.length) {
                                    if (interfaces[i].equals("java.util.Collection") || interfaces[i].equals("java.util.List") || interfaces[i].equals("java.util.Set")) {
                                        isList = true;
                                        break;
                                    }
                                    ++i;
                                }
                            }
                            if (isList) {
                                ContextValueDialog.this.singleBrowse.setEnabled(true);
                                ContextValueDialog.this.singleLabel.setEnabled(true);
                                ContextValueDialog.this.singleValueText.setEnabled(true);
                            } else {
                                ContextValueDialog.this.singleBrowse.setEnabled(false);
                                ContextValueDialog.this.singleLabel.setEnabled(false);
                                ContextValueDialog.this.singleValueText.setEnabled(false);
                                ContextValueDialog.this.singleValueText.setText("");
                            }
                        }
                    } else {
                        MessageDialog.openError((Shell)ContextValueDialog.this.getShell(), (String)Messages.ContextValueDialog_JAVA_PROJECT_ERROR, (String)Messages.ContextValueDialog_MUST_BE_JAVA_PROJECT);
                    }
                }
                catch (JavaModelException javaModelException) {}
            }

            public void mouseDoubleClick(MouseEvent mouseevent) {
            }

            public void mouseUp(MouseEvent mouseevent) {
            }
        });
        boolean enabled = false;
        if (this.contextValue != null && this.contextValue.singularClass != null) {
            enabled = true;
        }
        this.singleLabel = new Label(composite, 0);
        this.singleLabel.setEnabled(enabled);
        this.singleLabel.setText(Messages.ContextValueDialog_LABEL_LIST_ENTRY_TYPE);
        this.singleValueText = new Text(composite, 2048);
        this.singleValueText.setEnabled(enabled);
        this.singleValueText.setBackground(new Color(null, 255, 255, 255));
        gd = new GridData(768);
        gd.widthHint = 250;
        this.singleValueText.setLayoutData((Object)gd);
        if (enabled) {
            this.singleValueText.setText(this.contextValue.singularClass.getName());
        }
        this.singleBrowse = new Button(composite, 8);
        this.singleBrowse.setEnabled(enabled);
        this.singleBrowse.setText(Messages.ContextValueDialog_BUTTON_BROWSE);
        this.singleBrowse.addMouseListener(new MouseListener(){

            public void mouseDown(MouseEvent e) {
                try {
                    IJavaProject javaProject = JavaCore.create((IProject)ContextValueDialog.this.resource.getProject());
                    if (javaProject != null) {
                        IJavaSearchScope searchScope = SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{javaProject});
                        SelectionDialog sd = JavaUI.createTypeDialog((Shell)ContextValueDialog.this.getShell(), (IRunnableContext)new ApplicationWindow(ContextValueDialog.this.getShell()), (IJavaSearchScope)searchScope, (int)2, (boolean)false);
                        sd.open();
                        Object[] objects = sd.getResult();
                        if (objects != null && objects.length > 0) {
                            IType type = (IType)objects[0];
                            ContextValueDialog.this.singleValueText.setText(type.getFullyQualifiedName());
                        }
                    } else {
                        MessageDialog.openError((Shell)ContextValueDialog.this.getShell(), (String)Messages.ContextValueDialog_JAVA_PROJECT_ERROR, (String)Messages.ContextValueDialog_MUST_BE_JAVA_PROJECT);
                    }
                }
                catch (JavaModelException javaModelException) {}
            }

            public void mouseDoubleClick(MouseEvent mouseevent) {
            }

            public void mouseUp(MouseEvent mouseevent) {
            }
        });
        return parent;
    }

    protected void okPressed() {
        try {
            String className;
            String name = this.keyText.getText().trim();
            while (name.startsWith("$")) {
                name = name.substring(1, name.length());
            }
            if (name.length() == 0) {
                MessageDialog.openError((Shell)this.getShell(), (String)Messages.ContextValueDialog_ERROR, (String)Messages.ContextValueDialog_MUST_CHOOSE_REFERENCE);
            }
            if ((className = this.valueText.getText().trim()).length() == 0) {
                MessageDialog.openError((Shell)this.getShell(), (String)Messages.ContextValueDialog_ERROR, (String)Messages.ContextValueDialog_MUST_CHOOSE_CLASS);
            }
            String singularClassName = this.singleValueText.getText().trim();
            Class<?> singularClass = null;
            if (singularClassName != null && singularClassName.trim().length() > 0) {
                singularClass = ConfigurationManager.getInstance(this.resource.getProject()).getClass(singularClassName);
            }
            if (className.length() == 0) {
                singularClassName = null;
            }
            this.contextValue = new ContextValue(name, ConfigurationManager.getInstance(this.resource.getProject()).getClass(className), singularClass);
            ConfigurationManager.getInstance(this.resource.getProject()).addContextValue(this.contextValue, this.resource);
        }
        catch (Exception e) {
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.ContextValueDialog_ERROR, (String)e.getMessage());
        }
        super.okPressed();
    }
}

