/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.freemarker.configuration;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.jboss.ide.eclipse.freemarker.Plugin;
import org.jboss.ide.eclipse.freemarker.lang.Keyword;
import org.jboss.ide.eclipse.freemarker.lang.ParserUtils;
import org.jboss.ide.eclipse.freemarker.model.LibraryMacroDirective;
import org.jboss.ide.eclipse.freemarker.model.MacroDirective;
import org.jboss.ide.eclipse.freemarker.util.StringUtil;
import org.w3c.dom.Element;

public class MacroLibrary {
    private static final String HASH_MACRO_SPACE = new StringBuilder(7).append('#').append(Keyword.macro.toString()).append(' ').toString();
    public static final String TYPE_FILE = "file";
    public static final String TYPE_JAR_ENTRY = "jarEntry";
    private long lastUpdatedTime;
    private IFile file;
    private String content;
    private String path;
    private String namespace;
    private String type;
    private MacroDirective[] macros;

    public MacroLibrary(String namespace, IFile file) throws IOException, CoreException {
        this.namespace = namespace;
        this.file = file;
        this.content = StringUtil.getStringFromStream(file.getContents(true));
        this.type = TYPE_FILE;
    }

    public MacroLibrary(String namespace, InputStream is, String path, String type) throws IOException {
        this.namespace = namespace;
        this.content = StringUtil.getStringFromStream(is);
        this.type = type;
        this.path = path;
        if (this.type == null) {
            this.type = TYPE_FILE;
        }
    }

    public synchronized MacroDirective[] getMacros() {
        if (this.macros == null || this.isStale()) {
            this.load();
        }
        return this.macros;
    }

    public boolean isStale() {
        return this.file != null && this.file.getModificationStamp() > this.lastUpdatedTime;
    }

    public IFile getFile() {
        return this.file;
    }

    private void load() {
        try {
            int index;
            ArrayList<LibraryMacroDirective> macroDirectives = new ArrayList<LibraryMacroDirective>();
            int startIndex = index = this.content.indexOf(HASH_MACRO_SPACE);
            char startChar = this.content.charAt(index - 1);
            char endChar = ParserUtils.getMatchingRightBracket(startChar);
            while (startIndex > 0) {
                int stackCount = 0;
                boolean inString = false;
                int endIndex = Integer.MIN_VALUE;
                boolean escape = false;
                while (this.content.length() > index && index >= 0) {
                    boolean doEscape = false;
                    char c = this.content.charAt(index++);
                    if (!escape) {
                        if (c == '\"') {
                            inString = !inString;
                        } else if (c == '\\' && inString) {
                            doEscape = true;
                        } else if (c == startChar) {
                            ++stackCount;
                        } else if (c == endChar) {
                            if (stackCount > 0) {
                                --stackCount;
                            } else {
                                endIndex = index - 1;
                                break;
                            }
                        }
                    }
                    escape = doEscape;
                }
                if (endIndex <= 0) break;
                String sub = this.content.substring(startIndex, endIndex);
                LibraryMacroDirective macroDirective = new LibraryMacroDirective(null, this.namespace, sub, startIndex - 1, endIndex - index + 2);
                macroDirectives.add(macroDirective);
                index = this.content.indexOf(String.valueOf(startChar) + HASH_MACRO_SPACE, endIndex);
                if (index >= 0) {
                    // empty if block
                }
                startIndex = ++index;
                endIndex = Integer.MIN_VALUE;
            }
            this.macros = macroDirectives.toArray(new MacroDirective[macroDirectives.size()]);
            if (this.file != null) {
                this.lastUpdatedTime = this.file.getModificationStamp();
            }
        }
        catch (Exception e) {
            this.macros = new MacroDirective[0];
            Plugin.log(e);
        }
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void toXML(StringBuilder sb) {
        sb.append("<entry namespace=\"").append(this.getNamespace()).append("\" ");
        sb.append("path=\"").append(this.getPath()).append("\" ");
        if (this.file != null) {
            sb.append("project=\"").append(this.file.getProject().getName()).append("\" ");
        }
        sb.append("type=\"").append(this.getType()).append("\"/>");
    }

    public String getPath() {
        if (this.file != null) {
            return this.file.getProjectRelativePath().toString();
        }
        return this.path;
    }

    public static MacroLibrary fromXML(IProject project, Element node, ClassLoader classLoader) throws CoreException, IOException {
        String namespace = node.getAttribute("namespace");
        String path = node.getAttribute("path");
        String projectName = node.getAttribute("project");
        String type = node.getAttribute("type");
        if (type == null || type.length() == 0 || type.equals(TYPE_FILE)) {
            IFile file;
            if (projectName != null && projectName.length() > 0) {
                project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
            }
            if ((file = project.getFile((IPath)new Path(path))) == null || !file.exists()) {
                return null;
            }
            return new MacroLibrary(namespace, file);
        }
        if (type.equals(TYPE_JAR_ENTRY)) {
            InputStream is = null;
            try {
                is = classLoader.getResourceAsStream(path);
                if (is != null) {
                    MacroLibrary macroLibrary = new MacroLibrary(namespace, is, path, TYPE_JAR_ENTRY);
                    return macroLibrary;
                }
                return null;
            }
            finally {
                if (is != null) {
                    is.close();
                }
            }
        }
        return null;
    }
}

