/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.freemarker.configuration;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJarEntryResource;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.swt.widgets.Shell;
import org.jboss.ide.eclipse.freemarker.Messages;
import org.jboss.ide.eclipse.freemarker.Plugin;
import org.jboss.ide.eclipse.freemarker.configuration.ContextValue;
import org.jboss.ide.eclipse.freemarker.configuration.MacroLibrary;
import org.jboss.ide.eclipse.freemarker.configuration.ProjectClassLoader;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ConfigurationManager {
    private static final Map<String, ConfigurationManager> instances = new HashMap<String, ConfigurationManager>();
    private IProject project;
    private ProjectClassLoader projectClassLoader;
    private Map<String, ContextValue[]> contextValues = new HashMap<String, ContextValue[]>();
    private Map<String, MacroLibrary> macroLibrary = new HashMap<String, MacroLibrary>();
    private MacroLibrary[] macroLibraryArr;

    private ConfigurationManager() {
    }

    public static final synchronized ConfigurationManager getInstance(IProject project) {
        ConfigurationManager configuration = instances.get(project.getName());
        if (configuration == null) {
            configuration = new ConfigurationManager();
            configuration.project = project;
            configuration.reload();
            instances.put(project.getName(), configuration);
        }
        return configuration;
    }

    public MacroLibrary[] getMacroLibraries() {
        return this.macroLibraryArr;
    }

    public void associateMappingLibraries(List<?> libraries, Shell shell) {
        for (Object obj : libraries) {
            InputDialog inputDialog;
            int rtn;
            int index;
            String namespace;
            if (obj instanceof IFile) {
                IFile file = (IFile)obj;
                namespace = file.getName();
                index = namespace.indexOf(".");
                if (index >= 0) {
                    namespace = namespace.substring(0, index);
                }
                if ((rtn = (inputDialog = new InputDialog(shell, Messages.ConfigurationManager_TITLE_CHOOSE_NAMESPACE, MessageFormat.format(Messages.ConfigurationManager_CHOOSE_NAMESPACE_FOR, file.getName()), namespace, null)).open()) != 0) continue;
                namespace = inputDialog.getValue();
                try {
                    this.macroLibrary.put(namespace, new MacroLibrary(namespace, file));
                }
                catch (CoreException e) {
                    Plugin.error(e);
                }
                catch (IOException e) {
                    Plugin.error(e);
                }
                continue;
            }
            if (!(obj instanceof IJarEntryResource) || !((IJarEntryResource)obj).isFile()) continue;
            IJarEntryResource jef = (IJarEntryResource)obj;
            namespace = jef.getName();
            index = namespace.indexOf(".");
            if (index >= 0) {
                namespace = namespace.substring(0, index);
            }
            if ((rtn = (inputDialog = new InputDialog(shell, Messages.ConfigurationManager_TITLE_CHOOSE_NAMESPACE, MessageFormat.format(Messages.ConfigurationManager_CHOOSE_NAMESPACE_FOR, jef.getName()), namespace, null)).open()) != 0) continue;
            namespace = inputDialog.getValue();
            try {
                InputStream is = null;
                try {
                    is = this.getProjectClassLoader().getResourceAsStream(jef.getFullPath().toString());
                    if (is == null) continue;
                    this.macroLibrary.put(namespace, new MacroLibrary(namespace, is, jef.getFullPath().toString(), "jarEntry"));
                }
                finally {
                    if (is != null) {
                        is.close();
                    }
                }
            }
            catch (CoreException e) {
                Plugin.error(e);
            }
            catch (IOException e) {
                Plugin.error(e);
            }
        }
        this.save();
    }

    public MacroLibrary getMacroLibrary(String namespace) {
        return this.macroLibrary.get(namespace);
    }

    private void writeMacroLibrary(StringBuilder sb) {
        for (MacroLibrary ml : this.macroLibrary.values()) {
            sb.append('\t').append('\t');
            ml.toXML(sb);
            sb.append('\n');
        }
    }

    private Map<String, MacroLibrary> loadMacroTemplates(Element element) {
        HashMap<String, MacroLibrary> map = new HashMap<String, MacroLibrary>();
        try {
            NodeList nl = element.getElementsByTagName("entry");
            int i = 0;
            while (i < nl.getLength()) {
                try {
                    Node n = nl.item(i);
                    MacroLibrary ml = MacroLibrary.fromXML(this.project, (Element)n, this.getProjectClassLoader());
                    if (ml != null) {
                        map.put(ml.getNamespace(), ml);
                    }
                }
                catch (Exception e) {
                    Plugin.log(e);
                }
                ++i;
            }
        }
        catch (Exception e) {
            Plugin.log(e);
        }
        return map;
    }

    private Map<String, ContextValue[]> loadContextValues(Element element) {
        HashMap<String, ContextValue[]> map = new HashMap<String, ContextValue[]>();
        try {
            NodeList nl = element.getElementsByTagName("resource");
            int i = 0;
            while (i < nl.getLength()) {
                try {
                    Node n = nl.item(i);
                    String path = ((Element)n).getAttribute("path");
                    ArrayList<ContextValue> contextVals = new ArrayList<ContextValue>();
                    NodeList nl2 = ((Element)n).getElementsByTagName("value");
                    int j = 0;
                    while (j < nl2.getLength()) {
                        Node n2 = nl2.item(j);
                        String key = ((Element)n2).getAttribute("key");
                        Class<?> value = this.getClass(((Element)n2).getAttribute("object-class"));
                        String singularName = ((Element)n2).getAttribute("item-class");
                        Class<?> singularClass = null;
                        if (singularName != null && singularName.trim().length() > 0) {
                            singularClass = this.getClass(singularName);
                        }
                        contextVals.add(new ContextValue(key, value, singularClass));
                        ++j;
                    }
                    map.put(path, contextVals.toArray(new ContextValue[contextVals.size()]));
                }
                catch (Exception e) {
                    Plugin.log(e);
                }
                ++i;
            }
        }
        catch (Exception e) {
            Plugin.log(e);
        }
        return map;
    }

    public synchronized Class<?> getClass(String className) throws JavaModelException, ClassNotFoundException {
        return this.getProjectClassLoader().loadClass(className);
    }

    public synchronized ClassLoader getProjectClassLoader() throws JavaModelException {
        if (this.projectClassLoader == null) {
            this.projectClassLoader = new ProjectClassLoader(JavaCore.create((IProject)this.project));
        }
        return this.projectClassLoader;
    }

    private void save() {
        StringBuilder sb = new StringBuilder();
        sb.append("<config>\n");
        sb.append("\t<context-values>\n");
        this.writeContextValues(sb);
        sb.append("\t</context-values>\n");
        sb.append("\t<macro-library>\n");
        this.writeMacroLibrary(sb);
        sb.append("\t</macro-library>\n");
        sb.append("</config>");
        IFile file = this.project.getFile(".freemarker-ide.xml");
        try {
            if (file.exists()) {
                file.setContents((InputStream)new ByteArrayInputStream(sb.toString().getBytes()), true, true, null);
            } else {
                file.create((InputStream)new ByteArrayInputStream(sb.toString().getBytes()), true, null);
            }
        }
        catch (Exception e) {
            Plugin.error(e);
        }
        this.reload();
    }

    public void reload() {
        this.projectClassLoader = null;
        IFile file = this.project.getFile(".freemarker-ide.xml");
        if (file.exists()) {
            try {
                file.refreshLocal(1, null);
            }
            catch (CoreException coreException) {}
            try {
                Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(file.getContents());
                NodeList nl = document.getDocumentElement().getElementsByTagName("context-values");
                this.contextValues = nl.getLength() > 0 ? this.loadContextValues((Element)nl.item(0)) : new HashMap<String, ContextValue[]>();
                nl = document.getDocumentElement().getElementsByTagName("macro-library");
                ArrayList<MacroLibrary> libraries = new ArrayList<MacroLibrary>();
                if (nl.getLength() > 0) {
                    this.macroLibrary = this.loadMacroTemplates((Element)nl.item(0));
                    Iterator<MacroLibrary> i = this.macroLibrary.values().iterator();
                    while (i.hasNext()) {
                        libraries.add(i.next());
                    }
                } else {
                    this.macroLibrary = new HashMap<String, MacroLibrary>();
                }
                this.macroLibraryArr = libraries.toArray(new MacroLibrary[libraries.size()]);
            }
            catch (Exception e) {
                Plugin.error(e);
            }
        }
    }

    private void writeContextValues(StringBuilder sb) {
        for (Map.Entry<String, ContextValue[]> entry : this.contextValues.entrySet()) {
            String fileName = entry.getKey();
            ContextValue[] values = entry.getValue();
            if (values == null || values.length <= 0) continue;
            sb.append("\t\t<resource path=\"" + fileName + "\">\n");
            int j = 0;
            while (j < values.length) {
                sb.append("\t\t\t<value key=\"" + values[j].name + "\" object-class=\"" + values[j].objClass.getName() + "\"");
                if (values[j].singularClass != null) {
                    sb.append(" item-class=\"" + values[j].singularClass.getName() + "\"");
                }
                sb.append("/>\n");
                ++j;
            }
            sb.append("\t\t</resource>\n");
        }
    }

    public ContextValue[] getContextValues(IResource resource, boolean recurse) {
        HashMap<String, ContextValue> newValues = new HashMap<String, ContextValue>();
        this.addRootContextValues(resource, newValues, recurse);
        return newValues.values().toArray(new ContextValue[newValues.size()]);
    }

    private void addRootContextValues(IResource resource, Map<String, ContextValue> newValues, boolean recurse) {
        ContextValue[] values;
        String key = null;
        if (resource.getParent() != null) {
            key = resource.getProjectRelativePath().toString();
            if (recurse) {
                this.addRootContextValues((IResource)resource.getParent(), newValues, true);
            }
        } else {
            key = "";
        }
        if (resource.getProject() != null && (values = this.contextValues.get(key)) != null) {
            int i = 0;
            while (i < values.length) {
                newValues.put(values[i].name, values[i]);
                ++i;
            }
        }
    }

    public ContextValue getContextValue(String name, IResource resource, boolean recurse) {
        ContextValue[] values = this.getContextValues(resource, recurse);
        int i = 0;
        while (i < values.length) {
            if (values[i].name.equals(name)) {
                return values[i];
            }
            ++i;
        }
        return null;
    }

    public void addContextValue(ContextValue contextValue, IResource resource) {
        ContextValue[] contextValues = this.getContextValues(resource, false);
        boolean found = false;
        int i = 0;
        while (i < contextValues.length) {
            if (contextValues[i].name.equals(contextValue.name)) {
                found = true;
                contextValues[i] = contextValue;
                this.contextValues.put(resource.getProjectRelativePath().toString(), contextValues);
                break;
            }
            ++i;
        }
        if (!found) {
            ContextValue[] newContextValues = new ContextValue[contextValues.length + 1];
            int index = 0;
            while (index < contextValues.length) {
                newContextValues[index] = contextValues[index++];
            }
            newContextValues[index] = contextValue;
            this.contextValues.put(resource.getProjectRelativePath().toString(), newContextValues);
        }
        this.save();
    }

    public void updateContextValue(ContextValue contextValue, IFile file) {
        this.addContextValue(contextValue, (IResource)file);
    }

    public void removeContextValue(String name, IResource resource) {
        ContextValue[] values = this.getContextValues(resource, false);
        int index = -1;
        int i = 0;
        while (i < values.length) {
            if (values[i].name.equals(name)) {
                index = i;
                break;
            }
            ++i;
        }
        if (index >= 0) {
            ContextValue[] newValues = new ContextValue[values.length - 1];
            int j = 0;
            int i2 = 0;
            while (i2 < values.length) {
                if (i2 != index) {
                    newValues[j++] = values[i2];
                }
                ++i2;
            }
            this.contextValues.put(resource.getProjectRelativePath().toString(), newValues);
            this.save();
        }
    }
}

