/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.freemarker;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.jboss.ide.eclipse.freemarker.preferences.Preferences;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class Plugin
extends AbstractUIPlugin {
    public static final String ID = "org.jboss.ide.eclipse.freemarker";
    private static Plugin plugin;
    private ResourceBundle resourceBundle;

    public Plugin() {
        plugin = this;
        try {
            this.resourceBundle = ResourceBundle.getBundle("org.jboss.ide.eclipse.freemarker.resources");
        }
        catch (MissingResourceException missingResourceException) {
            this.resourceBundle = null;
        }
    }

    public static Plugin getDefault() {
        return plugin;
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public static Plugin getInstance() {
        return plugin;
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public static void error(Throwable t) {
        StringWriter sw = new StringWriter();
        t.printStackTrace(new PrintWriter(sw));
        MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)t.getMessage(), (String)sw.toString());
        Plugin.log(t);
    }

    public static void log(Throwable t) {
        Status status = new Status(4, ID, t.getMessage(), t);
        Plugin.getDefault().getLog().log((IStatus)status);
    }

    public static void log(String s) {
        Status status = new Status(4, ID, s);
        Plugin.getDefault().getLog().log((IStatus)status);
    }

    public Image getImage(String key) {
        ImageDescriptor descriptor;
        ImageRegistry imageRegistry = this.getImageRegistry();
        Image image = imageRegistry.get(key);
        if ((image == null || image.isDisposed()) && (descriptor = this.getImageDescriptor(key)) != null) {
            image = descriptor.createImage();
            imageRegistry.put(key, image);
        }
        return image;
    }

    public ImageDescriptor getImageDescriptor(String key) {
        ImageDescriptor imageDescriptor = null;
        URL gifImageURL = this.getImageURL(key);
        if (gifImageURL != null) {
            imageDescriptor = ImageDescriptor.createFromURL((URL)gifImageURL);
        }
        return imageDescriptor;
    }

    private URL getImageURL(String key) {
        IPath path;
        Bundle bundle = this.getBundle();
        if (FileLocator.find((Bundle)bundle, (IPath)(path = new Path("icons").append(key)), null) == null) {
            return null;
        }
        try {
            return new URL(bundle.getEntry("/"), path.toString());
        }
        catch (MalformedURLException exception) {
            Plugin.log(exception);
            return null;
        }
    }

    public void stop(BundleContext context) throws Exception {
        try {
            Preferences.getInstance().dispose();
        }
        finally {
            super.stop(context);
        }
    }
}

