/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.runtime.ui.internal.wizard;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Table;
import org.jboss.tools.foundation.ui.util.BrowserUtility;
import org.jboss.tools.foundation.ui.xpl.taskwizard.IWizardHandle;
import org.jboss.tools.foundation.ui.xpl.taskwizard.WizardFragment;
import org.jboss.tools.runtime.core.RuntimeCoreActivator;
import org.jboss.tools.runtime.core.model.DownloadRuntime;
import org.jboss.tools.runtime.ui.RuntimeUIActivator;
import org.jboss.tools.runtime.ui.RuntimeUIExtensionManager;
import org.jboss.tools.runtime.ui.internal.Messages;
import org.jboss.tools.runtime.ui.internal.dialogs.AutoResizeTableLayout;

public class SelectDownloadRuntimeFragment
extends WizardFragment {
    private Map<String, DownloadRuntime> downloadRuntimes;
    private TableViewer viewer;
    private Link urlLink;
    private Link projectLink;
    private Label restrictionsLabel;
    private DownloadRuntime selectedRuntime;
    private String projectLinkText = null;
    private String urlLinkText = null;
    private String restrictionsLabelText = null;
    private IWizardHandle handle;
    private HashMap<DownloadRuntime, WizardFragment[]> fragmentMap;

    public SelectDownloadRuntimeFragment() {
        this(RuntimeCoreActivator.getDefault().getDownloadRuntimes());
    }

    public SelectDownloadRuntimeFragment(Map<String, DownloadRuntime> downloadRuntimes) {
        this.downloadRuntimes = downloadRuntimes;
    }

    public boolean hasComposite() {
        return true;
    }

    public Composite createComposite(Composite parent, IWizardHandle handle) {
        this.handle = handle;
        this.getPage().setTitle(Messages.DownloadRuntimesWizardFirstPage_Download_Runtimes);
        this.getPage().setDescription(Messages.DownloadRuntimesWizardFirstPage_Please_select_a_runtime);
        Composite contentsWrapper = new Composite(parent, 2048);
        GridData gd = new GridData(4, 4, true, true);
        contentsWrapper.setLayoutData((Object)gd);
        contentsWrapper.setLayout((Layout)new FormLayout());
        SashForm contents = new SashForm(contentsWrapper, 512);
        contents.setLayout((Layout)new FormLayout());
        FormData contentsData = new FormData();
        contentsData.top = new FormAttachment(0, 0);
        contentsData.bottom = new FormAttachment(100, 0);
        contentsData.left = new FormAttachment(0, 0);
        contentsData.right = new FormAttachment(100, 0);
        contentsData.width = 200;
        contentsData.height = 400;
        contents.setLayoutData((Object)contentsData);
        if (this.downloadRuntimes == null || this.downloadRuntimes.isEmpty()) {
            new Label((Composite)contents, 0).setText(Messages.DownloadRuntimesWizardFirstPage_No_available_runtime);
            this.setComplete(false);
            return contents;
        }
        this.viewer = this.createTable((Composite)contents, parent.getFont());
        Group g = new Group((Composite)contents, -1);
        g.setText("Selected Runtime Details");
        g.setLayout((Layout)new GridLayout(2, false));
        Label pUrlLabel = new Label((Composite)g, 0);
        pUrlLabel.setText("Project URL: ");
        this.projectLink = new Link((Composite)g, 0);
        Label dUrlLabel = new Label((Composite)g, 0);
        dUrlLabel.setText("Download URL: ");
        this.urlLink = new Link((Composite)g, 0);
        GridData plGD = new GridData(4, 4, true, false);
        GridData dlGD = new GridData(4, 4, true, true);
        GridData lGD = new GridData(4, 4, false, false);
        pUrlLabel.setLayoutData((Object)lGD);
        dUrlLabel.setLayoutData((Object)lGD);
        this.urlLink.setLayoutData((Object)dlGD);
        this.projectLink.setLayoutData((Object)plGD);
        this.restrictionsLabel = new Label((Composite)g, 64);
        GridData restrictionLabelGD = new GridData(4, 4, true, true);
        restrictionLabelGD.horizontalSpan = 2;
        this.restrictionsLabel.setLayoutData((Object)restrictionLabelGD);
        this.urlLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                new BrowserUtility().checkedCreateExternalBrowser(SelectDownloadRuntimeFragment.this.selectedRuntime.getUrl(), "org.jboss.tools.runtime.ui", RuntimeUIActivator.getDefault().getLog());
            }
        });
        this.projectLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                new BrowserUtility().checkedCreateExternalBrowser(SelectDownloadRuntimeFragment.this.selectedRuntime.getHumanUrl(), "org.jboss.tools.runtime.ui", RuntimeUIActivator.getDefault().getLog());
            }
        });
        FormData fd = new FormData();
        fd.top = new FormAttachment(0, 5);
        fd.left = new FormAttachment(0, 5);
        fd.right = new FormAttachment(100, -5);
        fd.bottom = new FormAttachment((Control)g, -5);
        this.viewer.getTable().setLayoutData((Object)fd);
        fd = new FormData();
        fd.left = new FormAttachment(0, 5);
        fd.right = new FormAttachment(100, -5);
        fd.bottom = new FormAttachment(100, -5);
        fd.height = 140;
        fd.width = 200;
        g.setLayoutData((Object)fd);
        StructuredSelection ss = new StructuredSelection();
        this.viewer.setSelection((ISelection)ss);
        return contentsWrapper;
    }

    protected TableViewer createTable(Composite contents, Font font) {
        TableViewer viewer = new TableViewer(contents, 68356);
        Table table = viewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        table.setFont(font);
        viewer.setContentProvider((IContentProvider)new DownloadRuntimesContentProvider());
        String[] columnHeaders = new String[]{Messages.DownloadRuntimesWizardFirstPage_Name, Messages.DownloadRuntimesWizardFirstPage_Version};
        int i = 0;
        while (i < columnHeaders.length) {
            TableViewerColumn column = new TableViewerColumn(viewer, 0);
            column.setLabelProvider((CellLabelProvider)new DownloadRuntimesLabelProvider(i));
            column.getColumn().setText(columnHeaders[i]);
            column.getColumn().setResizable(true);
            column.getColumn().setMoveable(true);
            ++i;
        }
        ColumnLayoutData[] runtimePathsLayouts = new ColumnLayoutData[]{new ColumnWeightData(100, 100), new ColumnWeightData(50, 50)};
        AutoResizeTableLayout layout = new AutoResizeTableLayout(table);
        int i2 = 0;
        while (i2 < runtimePathsLayouts.length) {
            layout.addColumnData(runtimePathsLayouts[i2]);
            ++i2;
        }
        viewer.setInput(this.downloadRuntimes);
        viewer.getTable().setLayout((Layout)layout);
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection sel = event.getSelection();
                SelectDownloadRuntimeFragment.this.selectRuntime(sel);
            }
        });
        return viewer;
    }

    public List<WizardFragment> getChildFragments() {
        ArrayList<WizardFragment> list = new ArrayList<WizardFragment>();
        if (this.selectedRuntime != null) {
            WizardFragment[] frags;
            if (this.fragmentMap == null) {
                this.fragmentMap = new HashMap();
            }
            if ((frags = this.fragmentMap.get(this.selectedRuntime)) == null) {
                frags = RuntimeUIExtensionManager.createFragmentsForRuntime(this.selectedRuntime);
                this.fragmentMap.put(this.selectedRuntime, frags);
            }
            WizardFragment[] nullSafe = frags == null ? new WizardFragment[]{} : frags;
            list.addAll(Arrays.asList(nullSafe));
        }
        return list;
    }

    private void selectRuntime(ISelection sel, boolean updateWidgets) {
        this.selectedRuntime = null;
        this.setComplete(false);
        if (sel instanceof IStructuredSelection) {
            this.selectedRuntime = (DownloadRuntime)((IStructuredSelection)sel).getFirstElement();
            if (this.selectedRuntime != null) {
                String projectUrl = this.selectedRuntime.getHumanUrl();
                String dlUrl = this.selectedRuntime.getUrl();
                if (this.projectLink != null) {
                    String string = this.projectLinkText = projectUrl == null ? "None" : "<a>" + projectUrl + "</a>";
                }
                if (this.urlLink != null) {
                    String string = this.urlLinkText = dlUrl == null ? "None" : "<a>" + dlUrl + "</a>";
                }
                if (this.restrictionsLabel != null) {
                    Object subscription = this.selectedRuntime.getProperty("requiresCredentials");
                    this.restrictionsLabelText = subscription != null && Boolean.parseBoolean(subscription.toString()) ? "Registration required. Downloads require accepting the terms and conditions of the JBoss Developer Program which provides $0 subscriptions for development use only." : "";
                }
            }
        }
        this.setComplete(this.selectedRuntime != null);
        this.getTaskModel().putObject("dl.runtime.prop", (Object)this.selectedRuntime);
        this.handle.update();
        if (updateWidgets) {
            this.projectLink.setText(this.projectLinkText == null ? "" : this.projectLinkText);
            this.urlLink.setText(this.urlLinkText == null ? "" : this.urlLinkText);
            this.restrictionsLabel.setText(this.restrictionsLabelText == null ? "" : this.restrictionsLabelText);
        }
    }

    private void selectRuntime(ISelection sel) {
        this.selectRuntime(sel, true);
    }

    class DownloadRuntimesContentProvider
    implements IStructuredContentProvider {
        DownloadRuntimesContentProvider() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            Object[] runtimes = SelectDownloadRuntimeFragment.this.downloadRuntimes.values().toArray(new DownloadRuntime[0]);
            Arrays.sort(runtimes, new Comparator<DownloadRuntime>(){

                @Override
                public int compare(DownloadRuntime o1, DownloadRuntime o2) {
                    if (o1 == null && o2 == null) {
                        return 0;
                    }
                    if (o1 == null) {
                        return 1;
                    }
                    if (o2 == null) {
                        return -1;
                    }
                    String s1 = o1.getName();
                    String s2 = o2.getName();
                    if (s1 == null && s2 == null) {
                        return 0;
                    }
                    if (s1 == null) {
                        return 1;
                    }
                    if (s2 == null) {
                        return -1;
                    }
                    return s1.compareTo(s2);
                }
            });
            return runtimes;
        }

        public void dispose() {
        }
    }

    class DownloadRuntimesLabelProvider
    extends ColumnLabelProvider {
        private int columnIndex;

        public DownloadRuntimesLabelProvider(int i) {
            this.columnIndex = i;
        }

        public String getText(Object element) {
            if (element instanceof DownloadRuntime) {
                DownloadRuntime downloadRuntime = (DownloadRuntime)element;
                switch (this.columnIndex) {
                    case 0: {
                        return downloadRuntime.getName();
                    }
                    case 1: {
                        return downloadRuntime.getVersion();
                    }
                    case 2: {
                        return downloadRuntime.getUrl();
                    }
                }
            }
            return null;
        }
    }
}

