/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.browsersim.ui.skin;

import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.jboss.tools.vpe.browsersim.ui.skin.ios.ButtonDescriptor;
import org.jboss.tools.vpe.browsersim.util.BrowserSimImageList;

public class ImageButtonComposite
extends Composite {
    private MouseTrackListener mouseTrackListener;
    private Image enabledImage;
    private Image disabledImage;
    private Image selectedImage;
    protected boolean enabled;

    public ImageButtonComposite(Composite parent, Image enabledImage, Image disabledImage, Image selectedImage) {
        super(parent, 0);
        this.enabledImage = enabledImage;
        this.disabledImage = disabledImage;
        this.selectedImage = selectedImage;
        this.setEnabled(true);
        this.addMouseTrackListener(this.getMouseTrackListener());
    }

    public ImageButtonComposite(Composite parent, BrowserSimImageList imageList, ButtonDescriptor buttonDescriptor) {
        this(parent, imageList.getImage(buttonDescriptor.getEnabledImageName()), imageList.getImage(buttonDescriptor.getDisabledImageName()), imageList.getImage(buttonDescriptor.getSelectedImageName()));
        FormData formData = buttonDescriptor.getFormData();
        FormData actualFormData = new FormData();
        actualFormData.left = formData.left;
        actualFormData.top = formData.top;
        actualFormData.right = formData.right;
        actualFormData.bottom = formData.bottom;
        Rectangle size = this.enabledImage.getBounds();
        actualFormData.width = size.width;
        actualFormData.height = size.height;
        this.setLayoutData(actualFormData);
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        if (enabled) {
            this.setBackgroundImage(this.enabledImage);
        } else {
            this.setBackgroundImage(this.disabledImage);
        }
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    protected void checkSubclass() {
    }

    private MouseTrackListener getMouseTrackListener() {
        if (this.mouseTrackListener == null) {
            this.mouseTrackListener = new MouseTrackListener(){

                public void mouseHover(MouseEvent e) {
                }

                public void mouseExit(MouseEvent e) {
                    if (ImageButtonComposite.this.enabled) {
                        ImageButtonComposite.this.setBackgroundImage(ImageButtonComposite.this.enabledImage);
                    }
                }

                public void mouseEnter(MouseEvent e) {
                    if (ImageButtonComposite.this.enabled) {
                        ImageButtonComposite.this.setBackgroundImage(ImageButtonComposite.this.selectedImage);
                    }
                }
            };
        }
        return this.mouseTrackListener;
    }
}

