/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.browsersim.ui;

import org.jboss.tools.vpe.browsersim.browser.IBrowser;
import org.jboss.tools.vpe.browsersim.model.preferences.SpecificPreferences;
import org.jboss.tools.vpe.browsersim.ui.ControlHandler;

public class BrowserSimControlHandler
implements ControlHandler {
    protected IBrowser browser;
    protected SpecificPreferences specificPreferences;
    protected String homeUrl;

    public BrowserSimControlHandler(IBrowser browser, String homeUrl, SpecificPreferences specificPreferences) {
        this.browser = browser;
        this.specificPreferences = specificPreferences;
        this.homeUrl = homeUrl;
    }

    @Override
    public void goBack() {
        this.browser.back();
        this.browser.setFocus();
    }

    @Override
    public void goForward() {
        this.browser.forward();
        this.browser.setFocus();
    }

    @Override
    public void goHome() {
        this.browser.setUrl(this.homeUrl);
        this.browser.setFocus();
    }

    @Override
    public void goToAddress(String address) {
        this.browser.setUrl(address);
        this.browser.setFocus();
    }

    @Override
    public void showContextMenu() {
    }

    @Override
    public void rotate(boolean counterclockwise) {
        int orientationAngle = this.specificPreferences.getOrientationAngle();
        orientationAngle = counterclockwise ? (orientationAngle += 90) : (orientationAngle -= 90);
        orientationAngle = (orientationAngle - 180) % 360 + 180;
        orientationAngle = (orientationAngle + 90) % 360 - 90;
        this.specificPreferences.setOrientationAngle(orientationAngle);
        this.specificPreferences.notifyObservers(false);
    }

    @Override
    public void stop() {
        this.browser.stop();
        this.browser.setFocus();
    }

    @Override
    public void refresh() {
        this.browser.refresh();
        this.browser.setFocus();
    }
}

