/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.browsersim.devtools;

import java.io.IOException;
import javax.servlet.ServletContext;
import org.eclipse.jetty.websocket.WebSocket;
import org.jboss.tools.vpe.browsersim.devtools.DevToolsDebuggerServer;

public class DevToolsWebSocket
implements WebSocket.OnTextMessage {
    private WebSocket.Connection connection;
    private ServletContext context;

    public DevToolsWebSocket(ServletContext context) {
        this.context = context;
    }

    public void onOpen(WebSocket.Connection connection) {
        this.connection = connection;
        if (this.context.getAttribute("org.jboss.tools.vpe.browsersim.devtools.DevToolsWebSocket") != null) {
            connection.close();
            System.out.println("Another client is already connected. Connection refused.");
        } else {
            this.context.setAttribute("org.jboss.tools.vpe.browsersim.devtools.DevToolsWebSocket", (Object)this);
            System.out.println("Client connected.");
        }
    }

    public void onClose(int closeCode, String message) {
        DevToolsWebSocket mainSocket = (DevToolsWebSocket)this.context.getAttribute("org.jboss.tools.vpe.browsersim.devtools.DevToolsWebSocket");
        if (mainSocket == this) {
            this.context.removeAttribute("org.jboss.tools.vpe.browsersim.devtools.DevToolsWebSocket");
            System.out.println("Client disconnected.");
        }
    }

    public void onMessage(String data) {
        DevToolsDebuggerServer.sendMessageToBrowser(data);
    }

    public void sendMessage(String data) throws IOException {
        this.connection.sendMessage(data);
    }
}

