/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.browsersim.devtools;

import com.sun.javafx.scene.web.Debugger;
import java.io.IOException;
import javafx.application.Platform;
import javafx.util.Callback;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.HandlerList;
import org.eclipse.jetty.server.handler.ResourceHandler;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.jboss.tools.vpe.browsersim.BrowserSimArgs;
import org.jboss.tools.vpe.browsersim.devtools.DevToolsWebSocket;
import org.jboss.tools.vpe.browsersim.devtools.DevToolsWebSocketServlet;

public class DevToolsDebuggerServer {
    private static Debugger debugger;
    private static Server server;

    public static void startDebugServer(Debugger debugger) throws Exception {
        server = new Server(BrowserSimArgs.debuggerPort);
        debugger.setEnabled(true);
        final ServletContextHandler servletHandler = new ServletContextHandler(1);
        servletHandler.addServlet(DevToolsWebSocketServlet.class, "/devtools/page/dtdb");
        ResourceHandler resourceHandler = new ResourceHandler();
        resourceHandler.setDirectoriesListed(true);
        String devToolsPath = DevToolsDebuggerServer.class.getClassLoader().getResource("inspector-front-end").toExternalForm();
        resourceHandler.setResourceBase(devToolsPath);
        HandlerList handlerList = new HandlerList();
        handlerList.setHandlers(new Handler[]{servletHandler, resourceHandler});
        server.setHandler((Handler)handlerList);
        server.start();
        DevToolsDebuggerServer.debugger = debugger;
        debugger.setMessageCallback((Callback)new Callback<String, Void>(){

            public Void call(String data) {
                DevToolsWebSocket mainSocket = (DevToolsWebSocket)servletHandler.getServletContext().getAttribute("org.jboss.tools.vpe.browsersim.devtools.DevToolsWebSocket");
                if (mainSocket != null) {
                    try {
                        mainSocket.sendMessage(data);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                return null;
            }
        });
    }

    public static void stopDebugServer() throws Exception {
        if (server != null) {
            server.stop();
            server.join();
        }
    }

    public static void sendMessageToBrowser(final String data) {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                debugger.sendMessage(data);
            }
        });
    }

    public static String getServerState() {
        return server == null ? null : server.getState();
    }
}

