/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.project.examples.wizard;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.ui.IWorkingSet;
import org.jboss.tools.project.examples.model.ProjectExample;
import org.jboss.tools.project.examples.wizard.IWizardContextChangeListener;

public class WizardContext {
    private Map<String, Object> context = new HashMap<String, Object>();
    private Set<IWizardContextChangeListener> listeners = new LinkedHashSet<IWizardContextChangeListener>();

    public void addListener(IWizardContextChangeListener newListener) {
        this.listeners.add(newListener);
    }

    public void removeListener(IWizardContextChangeListener listener) {
        this.listeners.remove(listener);
    }

    public void setProperty(String key, Object value) {
        Object previousValue = this.context.get(key);
        if (previousValue != null && !previousValue.equals(value) || previousValue == null && value != null) {
            this.context.put(key, value);
            this.fireChangeEvent(key, value);
        }
    }

    public ProjectExample getProjectExample() {
        return (ProjectExample)this.context.get("project.example");
    }

    public void setProjectExample(ProjectExample example) {
        this.context.put("project.example", example);
    }

    public Object getProperty(String key) {
        return this.context.get(key);
    }

    private void fireChangeEvent(String key, Object value) {
        for (IWizardContextChangeListener listener : this.listeners) {
            listener.onWizardContextChange(key, value);
        }
    }

    public List<IWorkingSet> getWorkingSets() {
        return (List)this.context.get("workingSets");
    }

    public void setWorkingSets(List<IWorkingSet> workingSets) {
        this.context.put("workingSets", workingSets);
    }

    public Map<String, Object> getProperties() {
        return Collections.unmodifiableMap(this.context);
    }
}

