/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.project.examples.wizard;

import java.util.List;
import java.util.Set;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.wst.server.core.IRuntimeType;
import org.jboss.tools.project.examples.Messages;
import org.jboss.tools.project.examples.ProjectExamplesActivator;
import org.jboss.tools.project.examples.fixes.WTPRuntimeFix;
import org.jboss.tools.project.examples.model.ProjectExample;
import org.jboss.tools.project.examples.model.ProjectExampleCategory;
import org.jboss.tools.project.examples.model.ProjectModelElement;

public class RuntimeTypeFilter
extends ViewerFilter {
    private String runtimeType = Messages.ProjectExamplesActivator_All;

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        if (!(element instanceof ProjectModelElement)) {
            return false;
        }
        if (this.runtimeType.equals(ProjectExamplesActivator.ALL_RUNTIMES)) {
            return true;
        }
        if (element instanceof ProjectExampleCategory) {
            ProjectExampleCategory category = (ProjectExampleCategory)element;
            List<ProjectExample> projects = category.getProjects();
            for (ProjectExample project : projects) {
                if (!this.hasServer(project)) continue;
                return true;
            }
            return false;
        }
        boolean select = false;
        if (element instanceof ProjectExample) {
            select = this.hasServer((ProjectExample)element);
        }
        return select;
    }

    private boolean hasServer(ProjectExample project) {
        Set<IRuntimeType> runtimes = WTPRuntimeFix.getTargetedServerRuntimes(project);
        for (IRuntimeType r : runtimes) {
            if (!this.runtimeType.equals(r.getName())) continue;
            return true;
        }
        return false;
    }

    public void setRuntimeType(String runtimeType) {
        this.runtimeType = runtimeType;
    }
}

