/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.project.examples.wizard;

import java.util.List;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.jboss.tools.project.examples.ProjectExamplesActivator;
import org.jboss.tools.project.examples.model.ProjectExample;
import org.jboss.tools.project.examples.model.ProjectExampleWorkingCopy;
import org.jboss.tools.project.examples.wizard.IProjectExamplesWizardPage;
import org.jboss.tools.project.examples.wizard.NewProjectExamplesWizard2;

public class NewProjectExamplesReadyPage
extends WizardPage {
    private static final String SHOW_THE_QUICK_FIX_DIALOG = "Show the Quick Fix dialog";
    private static final String SHOW_README_FILE_FOR_FURTHER_INSTRUCTIONS = "Show readme file for further instructions";
    private Button showReadme;
    private List<ProjectExampleWorkingCopy> projectExamples;
    private Button showQuickFix;
    private IResourceChangeListener resourceChangeListener;

    public NewProjectExamplesReadyPage(List<ProjectExampleWorkingCopy> projectExamples) {
        super("org.jboss.tools.project.examples.ready");
        this.projectExamples = projectExamples;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        GridData gd = new GridData(4, 4, true, true);
        composite.setLayoutData((Object)gd);
        Dialog.applyDialogFont((Control)composite);
        this.setControl((Control)composite);
        this.showQuickFix = new Button(composite, 32);
        gd = new GridData(4, 4, true, false);
        this.showQuickFix.setLayoutData((Object)gd);
        this.showQuickFix.setText(SHOW_THE_QUICK_FIX_DIALOG);
        this.showQuickFix.setSelection(false);
        this.showQuickFix.setEnabled(false);
        this.showReadme = new Button(composite, 32);
        gd = new GridData(4, 4, true, false);
        this.showReadme.setLayoutData((Object)gd);
        this.showReadme.setText(SHOW_README_FILE_FOR_FURTHER_INSTRUCTIONS);
        this.showReadme.setSelection(false);
        this.showReadme.setEnabled(false);
        final Button showMe = new Button(composite, 32);
        gd = new GridData(4, 4, true, true);
        gd.verticalAlignment = 1024;
        showMe.setLayoutData((Object)gd);
        showMe.setText("Do not show this page again");
        final IPreferenceStore store = ProjectExamplesActivator.getDefault().getPreferenceStore();
        showMe.setSelection(!store.getBoolean("showProjectRadyWizard"));
        showMe.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                store.setValue("showProjectRadyWizard", !showMe.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        if (this.projectExamples != null && this.projectExamples.size() > 0) {
            this.configure(this.projectExamples);
        }
        this.setPageComplete(true);
        if (this.showReadme.isEnabled()) {
            this.showReadme.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    store.setValue("showReadme", NewProjectExamplesReadyPage.this.showReadme.getSelection());
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
        }
        if (this.showQuickFix.isEnabled()) {
            this.showQuickFix.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    store.setValue("showQuickFix", NewProjectExamplesReadyPage.this.showQuickFix.getSelection());
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
        }
        this.resourceChangeListener = new IResourceChangeListener(){

            public void resourceChanged(IResourceChangeEvent event) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        NewProjectExamplesReadyPage.this.configure(NewProjectExamplesReadyPage.this.projectExamples);
                    }
                });
            }
        };
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.resourceChangeListener);
    }

    public void configure(List<ProjectExampleWorkingCopy> projectExamples) {
        if (this.getControl() == null || this.getControl().isDisposed()) {
            return;
        }
        if (this.showQuickFix != null) {
            this.showQuickFix.setSelection(false);
            this.showQuickFix.setEnabled(false);
        }
        if (this.showReadme != null) {
            this.showReadme.setSelection(false);
            this.showReadme.setEnabled(false);
        }
        ProjectExampleWorkingCopy projectExample = projectExamples.get(0);
        IPreferenceStore store = ProjectExamplesActivator.getDefault().getPreferenceStore();
        if (projectExample != null) {
            List<IMarker> markers;
            this.setTitle(projectExample.getShortDescription());
            this.setDescription("'" + projectExample.getShortDescription() + "' Project is now ready");
            if (this.showReadme != null) {
                ProjectExamplesActivator.fixWelcome(projectExample);
                if (projectExample.isWelcome()) {
                    this.showReadme.setEnabled(true);
                    this.showReadme.setSelection(store.getBoolean("showReadme"));
                    String urlString = projectExample.getWelcomeURL();
                    String welcomeURL = ProjectExamplesActivator.replace(urlString, projectExample);
                    this.showReadme.setText("Show '" + welcomeURL + "' for further instructions");
                } else {
                    this.showReadme.setEnabled(false);
                    this.showReadme.setSelection(false);
                    this.showReadme.setText(SHOW_README_FILE_FOR_FURTHER_INSTRUCTIONS);
                }
            }
            if ((markers = ProjectExamplesActivator.getMarkers(projectExamples)) != null && markers.size() > 0) {
                this.showQuickFix.setEnabled(true);
                this.showQuickFix.setSelection(store.getBoolean("showQuickFix"));
            }
        }
    }

    public IWizardPage getPreviousPage() {
        IWizard wizard = this.getWizard();
        if (wizard instanceof NewProjectExamplesWizard2) {
            ProjectExample projectExample = ((NewProjectExamplesWizard2)wizard).getSelectedProjectExample();
            if (projectExample != null && projectExample.getImportType() != null) {
                List<IProjectExamplesWizardPage> pages = ((NewProjectExamplesWizard2)wizard).getContributedPages();
                IProjectExamplesWizardPage previousPage = null;
                for (IProjectExamplesWizardPage page : pages) {
                    if (!projectExample.getImportType().equals(page.getProjectExampleType())) continue;
                    previousPage = page;
                }
                if (previousPage != null) {
                    return previousPage;
                }
            }
            return ((NewProjectExamplesWizard2)wizard).getLocationsPage();
        }
        return super.getPreviousPage();
    }

    public Button getShowReadme() {
        return this.showReadme;
    }

    public Button getShowQuickFix() {
        return this.showQuickFix;
    }

    public void dispose() {
        if (this.resourceChangeListener != null) {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.resourceChangeListener);
            this.resourceChangeListener = null;
        }
        super.dispose();
    }
}

