/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.project.examples.preferences;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Set;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.jboss.tools.project.examples.Messages;
import org.jboss.tools.project.examples.ProjectExamplesActivator;
import org.jboss.tools.project.examples.model.IProjectExampleSite;
import org.jboss.tools.project.examples.model.ProjectExampleSite;
import org.jboss.tools.project.examples.preferences.Sites;

public class SiteDialog
extends TitleAreaDialog {
    private static final String ADD_PROJECT_EXAMPLE_SITE = Messages.SiteDialog_Add_Project_Example_Site;
    private static final String EDIT_PROJECT_EXAMPLE_SITE = Messages.SiteDialog_Edit_Project_Example_Site;
    private Image dlgTitleImage;
    private ProjectExampleSite selectedSite;
    private String name;
    private URL url;
    private Text nameText;
    private Text urlText;
    private Button okButton;
    private Sites sites;

    protected SiteDialog(Shell parentShell, ProjectExampleSite site, Sites sites) {
        super(parentShell);
        this.selectedSite = site;
        this.sites = sites;
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        if (this.selectedSite == null) {
            this.setTitle(ADD_PROJECT_EXAMPLE_SITE);
            this.setMessage(ADD_PROJECT_EXAMPLE_SITE);
        } else {
            this.setTitle(EDIT_PROJECT_EXAMPLE_SITE);
            this.setMessage(EDIT_PROJECT_EXAMPLE_SITE);
        }
        ImageDescriptor descriptor = ProjectExamplesActivator.imageDescriptorFromPlugin((String)"org.jboss.tools.project.examples", (String)"icons/SiteWizBan.png");
        if (descriptor != null) {
            this.dlgTitleImage = descriptor.createImage();
            this.setTitleImage(this.dlgTitleImage);
        }
        return contents;
    }

    public boolean close() {
        if (this.dlgTitleImage != null) {
            this.dlgTitleImage.dispose();
        }
        return super.close();
    }

    protected Control createDialogArea(Composite parent) {
        Composite parentComposite = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(parentComposite, 4);
        GridLayout layout = new GridLayout(3, false);
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        container.setLayout((Layout)layout);
        GridData gd = new GridData(1808);
        container.setLayoutData((Object)gd);
        Label nameLabel = new Label(container, 0);
        nameLabel.setText(Messages.SiteDialog_Name);
        this.nameText = new Text(container, 2052);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.nameText.setLayoutData((Object)gd);
        this.nameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SiteDialog.this.validatePage();
            }
        });
        Label urlLabel = new Label(container, 0);
        urlLabel.setText(Messages.SiteDialog_URL);
        this.urlText = new Text(container, 2052);
        gd = new GridData(768);
        this.urlText.setLayoutData((Object)gd);
        this.urlText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SiteDialog.this.validatePage();
            }
        });
        if (this.selectedSite != null) {
            this.urlText.setText(this.selectedSite.getUrl().toString());
            this.nameText.setText(this.selectedSite.getName());
        }
        Button browse = new Button(container, 8);
        browse.setText(Messages.Browse);
        browse.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(SiteDialog.this.getShell(), 4);
                dialog.setFilterExtensions(new String[]{"*.xml"});
                String result = dialog.open();
                if (result == null || result.trim().length() == 0) {
                    return;
                }
                try {
                    String urlString = new File(result).toURL().toString();
                    SiteDialog.this.urlText.setText(urlString);
                }
                catch (MalformedURLException malformedURLException) {
                    SiteDialog.this.urlText.setText("file:///" + result);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        return parentComposite;
    }

    private boolean validatePage() {
        this.name = null;
        this.url = null;
        if (this.nameText.getText().trim().length() <= 0) {
            this.setErrorMessage(Messages.SiteDialog_The_name_field_is_required);
            return this.updateButton(false);
        }
        Set<IProjectExampleSite> siteList = this.sites.getSites();
        for (IProjectExampleSite site : siteList) {
            if (site == this.selectedSite || !this.nameText.getText().equals(site.getName())) continue;
            this.setErrorMessage(Messages.SiteDialog_The_site_already_exists);
            return this.updateButton(false);
        }
        if (this.urlText.getText().trim().length() <= 0) {
            this.setErrorMessage(Messages.SiteDialog_The_url_field_is_required);
            return this.updateButton(false);
        }
        try {
            new URL(this.urlText.getText());
        }
        catch (MalformedURLException malformedURLException) {
            this.setErrorMessage(Messages.SiteDialog_Invalid_URL);
            return this.updateButton(false);
        }
        this.setErrorMessage(null);
        this.name = this.nameText.getText();
        try {
            this.url = new URL(this.urlText.getText());
        }
        catch (MalformedURLException malformedURLException) {}
        return this.updateButton(true);
    }

    private boolean updateButton(boolean enabled) {
        if (this.okButton != null) {
            this.okButton.setEnabled(enabled);
        }
        return false;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.okButton = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.okButton.setEnabled(this.selectedSite != null);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    public String getName() {
        return this.name;
    }

    public URL getURL() {
        return this.url;
    }
}

