/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.project.examples.model;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jboss.tools.project.examples.model.ArchetypeModel;
import org.jboss.tools.project.examples.model.ProjectExample;
import org.jboss.tools.project.examples.model.ProjectFix;

public class ProjectExampleWorkingCopy
extends ProjectExample {
    private List<ProjectFix> unsatisfiedFixes;
    private String exampleId;

    public ProjectExampleWorkingCopy() {
    }

    public ProjectExampleWorkingCopy(ProjectExample projectExample) {
        this();
        this.exampleId = projectExample.getName();
        this.setCategory(projectExample.getCategory());
        this.setDefaultProfiles(projectExample.getDefaultProfiles());
        this.setDescription(projectExample.getDescription());
        if (projectExample.getEssentialEnterpriseDependencyGavs() != null) {
            this.setEssentialEnterpriseDependencyGavs(new LinkedHashSet<String>(projectExample.getEssentialEnterpriseDependencyGavs()));
        }
        this.setFile(projectExample.getFile());
        if (projectExample.getFixes() != null) {
            this.setFixes(new ArrayList<ProjectFix>(projectExample.getFixes()));
        }
        this.setHeadLine(projectExample.getHeadLine());
        this.setIconPath(projectExample.getIconPath());
        this.setImportType(projectExample.getImportType());
        this.setImportTypeDescription(projectExample.getImportTypeDescription());
        if (projectExample.getIncludedProjects() != null) {
            this.setIncludedProjects(new ArrayList<String>(projectExample.getIncludedProjects()));
        }
        this.setName(projectExample.getName());
        this.setPerspectiveId(projectExample.getPerspectiveId());
        this.setPriority(projectExample.getPriority());
        this.setShortDescription(projectExample.getShortDescription());
        this.setSite(projectExample.getSite());
        this.setSize(projectExample.getSize());
        this.setSourceLocation(projectExample.getSourceLocation());
        this.setStacksId(projectExample.getStacksId());
        this.setStacksType(projectExample.getStacksType());
        if (projectExample.getTags() != null) {
            this.setTags(new LinkedHashSet<String>(projectExample.getTags()));
        }
        this.setType(projectExample.getType());
        if (projectExample.getUnsatisfiedFixes() != null) {
            this.setUnsatisfiedFixes(projectExample.getUnsatisfiedFixes());
        }
        this.setUrl(projectExample.getUrl());
        this.setWelcome(projectExample.isWelcome());
        this.setWelcomeFixRequired(projectExample.isWelcomeFixRequired());
        this.setWelcomeURL(projectExample.getWelcomeURL());
        if (projectExample.getArchetypeModel() != null) {
            try {
                this.setArchetypeModel((ArchetypeModel)projectExample.getArchetypeModel().clone());
            }
            catch (CloneNotSupportedException e) {
                throw new RuntimeException("Error cloning archetypeModel", e);
            }
        }
    }

    @Override
    public List<ProjectFix> getUnsatisfiedFixes() {
        return this.unsatisfiedFixes;
    }

    @Override
    public void setUnsatisfiedFixes(List<ProjectFix> unsatisfiedFixes) {
        this.unsatisfiedFixes = unsatisfiedFixes;
    }

    @Override
    public void setWelcome(boolean welcome) {
        super.setWelcome(welcome);
    }

    @Override
    public void setWelcomeFixRequired(boolean welcomeFixRequired) {
        super.setWelcomeFixRequired(welcomeFixRequired);
    }

    @Override
    public void setType(String type) {
        super.setType(type);
    }

    @Override
    public void setIncludedProjects(List<String> includedProjects) {
        super.setIncludedProjects(includedProjects);
    }

    @Override
    public void setName(String name) {
        super.setName(name);
    }

    @Override
    public void setUrl(String url) {
        super.setUrl(url);
    }

    @Override
    public void setEssentialEnterpriseDependencyGavs(Set<String> gavs) {
        super.setEssentialEnterpriseDependencyGavs(gavs);
    }

    @Override
    public void setImportType(String importType) {
        super.setImportType(importType);
    }

    @Override
    public void setArchetypeModel(ArchetypeModel archetypeModel) {
        super.setArchetypeModel(archetypeModel);
    }

    public String getExampleId() {
        ArchetypeModel model = this.getArchetypeModel();
        if (model != null && "mavenArchetype".equals(this.getImportType())) {
            this.exampleId = model.getGAV();
        }
        if (this.exampleId == null || this.exampleId.trim().isEmpty()) {
            return this.getName();
        }
        return this.exampleId;
    }

    public void setExampleId(String exampleId) {
        this.exampleId = exampleId;
    }
}

