/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.project.examples.model;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerCore;
import org.jboss.ide.eclipse.as.core.server.IJBossServerRuntime;
import org.jboss.tools.foundation.core.ecf.URLTransportUtility;
import org.jboss.tools.foundation.core.properties.PropertiesHelper;
import org.jboss.tools.project.examples.Messages;
import org.jboss.tools.project.examples.ProjectExamplesActivator;
import org.jboss.tools.project.examples.model.ArchetypeModel;
import org.jboss.tools.project.examples.model.IProjectExampleSite;
import org.jboss.tools.project.examples.model.ProjectExample;
import org.jboss.tools.project.examples.model.ProjectExampleCategory;
import org.jboss.tools.project.examples.model.ProjectExampleSite;
import org.jboss.tools.project.examples.model.ProjectFix;
import org.jboss.tools.project.examples.offline.OfflineUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.helpers.DefaultHandler;

public class ProjectExampleUtil {
    private static final String SERVER_PROJECT_EXAMPLE_XML = ".project_example.xml";
    private static final String URL = "url";
    private static final String NAME = "name";
    private static final String SITES = "sites";
    private static final String SITE = "site";
    public static final String EDITOR = "editor";
    public static final String CHEATSHEETS = "cheatsheets";
    public static final String PROTOCOL_FILE = "file";
    public static final String PROTOCOL_PLATFORM = "platform";
    private static final String PROJECT_EXAMPLES_XML_EXTENSION_ID = "org.jboss.tools.project.examples.projectExamplesXml";
    private static final String PROJECT_EXAMPLES_CATEGORIES_EXTENSION_ID = "org.jboss.tools.project.examples.categories";
    private static final int TIME_OUT = 2000;
    private static String URL_EXT = "url";
    private static String URL_KEY = "urlKey";
    private static String EXPERIMENTAL_EXT = "experimental";
    private static Set<IProjectExampleSite> pluginSites;
    private static HashSet<IProjectExampleSite> invalidSites;
    private static Set<URL> categoryUrls;

    static {
        invalidSites = new HashSet();
    }

    private ProjectExampleUtil() {
    }

    public static Set<IProjectExampleSite> getPluginSites() {
        if (pluginSites == null) {
            pluginSites = new HashSet<IProjectExampleSite>();
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            IExtensionPoint extensionPoint = registry.getExtensionPoint(PROJECT_EXAMPLES_XML_EXTENSION_ID);
            IExtension[] extensions = extensionPoint.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                URL url;
                IExtension extension = extensions[i];
                IConfigurationElement[] configurationElements = extension.getConfigurationElements();
                ProjectExampleSite site = new ProjectExampleSite();
                site.setName(extension.getLabel());
                String urlKey = null;
                String urlValue = null;
                int j = 0;
                while (j < configurationElements.length) {
                    IConfigurationElement configurationElement = configurationElements[j];
                    if (URL_KEY.equals(configurationElement.getName())) {
                        urlKey = configurationElement.getValue();
                    }
                    if (URL_EXT.equals(configurationElement.getName())) {
                        urlValue = configurationElement.getValue();
                    } else if (EXPERIMENTAL_EXT.equals(configurationElement.getName())) {
                        String experimental = configurationElement.getValue();
                        site.setExperimental(Boolean.parseBoolean(experimental));
                    }
                    ++j;
                }
                String urlString = urlValue;
                if (urlKey != null) {
                    urlString = PropertiesHelper.getPropertiesProvider().getValue(urlKey, urlValue);
                }
                if ((url = ProjectExampleUtil.getURL(urlString)) != null) {
                    site.setUrl(url);
                }
                if (site.getUrl() != null) {
                    pluginSites.add(site);
                }
                ++i;
            }
        }
        return pluginSites;
    }

    public static Set<IProjectExampleSite> getRuntimeSites() {
        return ProjectExampleUtil.getRuntimeSites(false);
    }

    public static Set<IProjectExampleSite> getRuntimeSites(boolean force) {
        IServer[] servers;
        IPreferenceStore store;
        HashSet<IProjectExampleSite> sites = new HashSet<IProjectExampleSite>();
        if (!force && !(store = ProjectExamplesActivator.getDefault().getPreferenceStore()).getBoolean("showRuntimeSites")) {
            return sites;
        }
        IServer[] iServerArray = servers = ServerCore.getServers();
        int n = servers.length;
        int n2 = 0;
        while (n2 < n) {
            IJBossServerRuntime jbossRuntime;
            IServer server = iServerArray[n2];
            IRuntime runtime = server.getRuntime();
            if (runtime != null && (jbossRuntime = (IJBossServerRuntime)runtime.loadAdapter(IJBossServerRuntime.class, (IProgressMonitor)new NullProgressMonitor())) != null) {
                IPath jbossLocation = runtime.getLocation();
                if (jbossRuntime.getRuntime() != null) {
                    String name = String.valueOf(jbossRuntime.getRuntime().getName()) + " Project Examples";
                    File serverHome = jbossLocation.toFile();
                    File file = ProjectExampleUtil.getFile(serverHome, true);
                    if (file != null) {
                        ProjectExampleSite site = new ProjectExampleSite();
                        site.setExperimental(false);
                        site.setName(name);
                        try {
                            site.setUrl(file.toURI().toURL());
                            sites.add(site);
                        }
                        catch (MalformedURLException e) {
                            ProjectExamplesActivator.log(e.getMessage());
                        }
                    }
                }
            }
            ++n2;
        }
        return sites;
    }

    private static File getFile(File serverHome, boolean b) {
        if (!serverHome.isDirectory()) {
            return null;
        }
        File[] directories = serverHome.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isDirectory();
            }
        });
        if (directories != null && directories.length > 0) {
            File[] fileArray = directories;
            int n = directories.length;
            int n2 = 0;
            while (n2 < n) {
                File directory = fileArray[n2];
                File projectExampleFile = new File(directory, SERVER_PROJECT_EXAMPLE_XML);
                if (projectExampleFile.isFile()) {
                    return projectExampleFile;
                }
                ++n2;
            }
        }
        return null;
    }

    public static Set<IProjectExampleSite> getUserSites() {
        IPreferenceStore store;
        String sitesAsXml;
        HashSet<IProjectExampleSite> sites = new HashSet<IProjectExampleSite>();
        ProjectExampleSite site = ProjectExampleUtil.getSite(ProjectExampleUtil.getProjectExamplesXml());
        if (site != null) {
            sites.add(site);
        }
        if ((sitesAsXml = (store = ProjectExamplesActivator.getDefault().getPreferenceStore()).getString("userSites")) != null && sitesAsXml.trim().length() > 0) {
            Element rootElement = ProjectExampleUtil.parseDocument(sitesAsXml);
            if (!rootElement.getNodeName().equals(SITES)) {
                ProjectExamplesActivator.log(Messages.ProjectUtil_Invalid_preferences);
                return sites;
            }
            NodeList list = rootElement.getChildNodes();
            int length = list.getLength();
            int i = 0;
            while (i < length) {
                block8: {
                    Element entry;
                    Node node = list.item(i);
                    short type = node.getNodeType();
                    if (type == 1 && (entry = (Element)node).getNodeName().equals(SITE)) {
                        String name = entry.getAttribute(NAME);
                        String urlString = entry.getAttribute(URL);
                        if (name != null && name.trim().length() > 0 && urlString != null && urlString.trim().length() > 0) {
                            URL url = null;
                            try {
                                url = new URL(urlString);
                            }
                            catch (MalformedURLException malformedURLException) {
                                ProjectExamplesActivator.log(Messages.ProjectUtil_Invalid_preferences);
                                break block8;
                            }
                            site = new ProjectExampleSite();
                            site.setName(name);
                            site.setUrl(url);
                            site.setExperimental(true);
                            site.setEditable(true);
                            sites.add(site);
                        }
                    }
                }
                ++i;
            }
        }
        return sites;
    }

    private static Set<IProjectExampleSite> getSites() {
        HashSet<IProjectExampleSite> sites = new HashSet<IProjectExampleSite>();
        sites.addAll(ProjectExampleUtil.getPluginSites());
        sites.addAll(ProjectExampleUtil.getUserSites());
        sites.addAll(ProjectExampleUtil.getRuntimeSites());
        return sites;
    }

    private static ProjectExampleSite getSite(String url) {
        if (url != null) {
            ProjectExampleSite site = new ProjectExampleSite();
            try {
                site.setUrl(new URL(url));
            }
            catch (MalformedURLException e) {
                ProjectExamplesActivator.log(e);
                return null;
            }
            site.setExperimental(true);
            site.setName(Messages.ProjectUtil_Test);
            return site;
        }
        return null;
    }

    private static URL getURL(String urlString) {
        if (urlString != null && urlString.trim().length() > 0) {
            urlString = urlString.trim();
            try {
                URL url = new URL(urlString);
                return url;
            }
            catch (MalformedURLException e) {
                ProjectExamplesActivator.log(e);
            }
        }
        return null;
    }

    public static List<ProjectExampleCategory> getProjects(IProgressMonitor monitor) {
        return ProjectExampleUtil.getProjects(ProjectExampleUtil.getSites(), monitor);
    }

    public static List<ProjectExampleCategory> getProjects(Set<IProjectExampleSite> sites, IProgressMonitor monitor) {
        ProjectExampleCategory other;
        ArrayList<ProjectExampleCategory> list;
        block74: {
            monitor.setTaskName(Messages.ProjectUtil_Parsing_project_description_files);
            list = new ArrayList<ProjectExampleCategory>();
            invalidSites.clear();
            other = ProjectExampleCategory.OTHER;
            int threads = Runtime.getRuntime().availableProcessors();
            ExecutorService service = Executors.newFixedThreadPool(threads);
            ExecutorCompletionService<Tuple<IProjectExampleSite, Document>> pool = new ExecutorCompletionService<Tuple<IProjectExampleSite, Document>>(service);
            try {
                try {
                    boolean showExperimentalSites = ProjectExamplesActivator.getDefault().getPreferenceStore().getBoolean("showExperimentalSites");
                    int count = 0;
                    for (IProjectExampleSite site : sites) {
                        if (!showExperimentalSites && site.isExperimental()) continue;
                        if (monitor.isCanceled()) {
                            invalidSites.add(site);
                            continue;
                        }
                        pool.submit(new FetchProjectExampleDocumentTask(site));
                        ++count;
                    }
                    int k = 0;
                    while (k < count) {
                        Tuple tuple = (Tuple)pool.take().get();
                        IProjectExampleSite site = (IProjectExampleSite)tuple.key;
                        Document doc = (Document)tuple.value;
                        if (doc == null) {
                            invalidSites.add(site);
                        } else {
                            NodeList projects = doc.getElementsByTagName("project");
                            int len = projects.getLength();
                            int i = 0;
                            while (i < len) {
                                Node node = projects.item(i);
                                ProjectExample project = new ProjectExample();
                                project.setSite(site);
                                ProjectExampleCategory category = other;
                                if (node.getNodeType() == 1) {
                                    Element element = (Element)node;
                                    NodeList children = element.getChildNodes();
                                    int cLen = children.getLength();
                                    int j = 0;
                                    while (j < cLen) {
                                        Node cNode = children.item(j);
                                        if (cNode.getNodeType() == 1) {
                                            String headLine;
                                            Element child = (Element)cNode;
                                            String nodeName = child.getNodeName();
                                            if (nodeName.equals("fixes")) {
                                                ProjectExampleUtil.parseFixes(project, child);
                                            } else if (nodeName.equals("category")) {
                                                String value = ProjectExampleUtil.getContent(child);
                                                boolean found = false;
                                                for (ProjectExampleCategory cat : list) {
                                                    if (cat.getSite() == null) {
                                                        cat.setSite(site);
                                                    }
                                                    if (!cat.getName().equals(value) || !site.getName().equals(cat.getSite().getName())) continue;
                                                    category = cat;
                                                    found = true;
                                                    break;
                                                }
                                                if (!found) {
                                                    category = new ProjectExampleCategory(value);
                                                    category.setSite(site);
                                                    list.add(category);
                                                }
                                                project.setCategory(category);
                                                category.getProjects().add(project);
                                            } else if (nodeName.equals(NAME)) {
                                                project.setName(ProjectExampleUtil.getContent(child));
                                            } else if (nodeName.equals("priority")) {
                                                String value = ProjectExampleUtil.getContent(child);
                                                if (value != null) {
                                                    try {
                                                        project.setPriority(Integer.parseInt(value));
                                                    }
                                                    catch (Exception e) {
                                                        ProjectExamplesActivator.log(e);
                                                    }
                                                }
                                            } else if (nodeName.equals("shortDescription")) {
                                                project.setShortDescription(ProjectExampleUtil.getContent(child));
                                            } else if (nodeName.equals("description")) {
                                                project.setDescription(ProjectExampleUtil.getContent(child));
                                            } else if (nodeName.equals(URL)) {
                                                project.setUrl(ProjectExampleUtil.getContent(child));
                                            } else if (nodeName.equals("source-location")) {
                                                project.setSourceLocation(ProjectExampleUtil.getContent(child));
                                            } else if (nodeName.equals("perspectiveId")) {
                                                project.setPerspectiveId(ProjectExampleUtil.getContent(child));
                                            } else if (nodeName.equals("importType")) {
                                                project.setImportType(ProjectExampleUtil.getContent(child));
                                            } else if (nodeName.equals("importTypeDescription")) {
                                                project.setImportTypeDescription(ProjectExampleUtil.getContent(child));
                                            } else if (nodeName.equals("size")) {
                                                long size = 0L;
                                                try {
                                                    size = Long.parseLong(ProjectExampleUtil.getContent(child));
                                                }
                                                catch (Exception exception) {}
                                                project.setSize(size);
                                            } else if (nodeName.equals("included-projects")) {
                                                String includedProjects = ProjectExampleUtil.getContent(child);
                                                if (includedProjects != null) {
                                                    includedProjects = includedProjects.trim();
                                                    StringTokenizer tokenizer = new StringTokenizer(includedProjects, ",");
                                                    ArrayList<String> projectList = new ArrayList<String>();
                                                    while (tokenizer.hasMoreTokens()) {
                                                        projectList.add(tokenizer.nextToken().trim());
                                                    }
                                                    project.setIncludedProjects(projectList);
                                                }
                                            } else if (nodeName.equals("defaultMavenProfiles")) {
                                                project.setDefaultProfiles(ProjectExampleUtil.getContent(child));
                                            } else if (nodeName.equals("welcome")) {
                                                project.setWelcome(true);
                                                String attribute = child.getAttribute("type");
                                                if (attribute != null && CHEATSHEETS.equals(attribute.trim())) {
                                                    project.setType(attribute.trim());
                                                } else {
                                                    project.setType(EDITOR);
                                                }
                                                attribute = child.getAttribute(URL);
                                                if (attribute == null || attribute.trim().length() <= 0) {
                                                    project.setWelcome(false);
                                                    ProjectExamplesActivator.log(Messages.ProjectUtil_Invalid_welcome_element);
                                                } else {
                                                    project.setWelcomeURL(attribute.trim());
                                                    project.setWelcomeFixRequired(false);
                                                }
                                            } else if (nodeName.equals("mavenArchetype")) {
                                                ProjectExampleUtil.parseMavenArchetype(project, child);
                                            } else if (nodeName.equals("tags")) {
                                                ProjectExampleUtil.parseTags(project, child);
                                            } else if (nodeName.equals("icon")) {
                                                String path = child.getAttribute("path");
                                                if (path != null) {
                                                    project.setIconPath(path);
                                                }
                                            } else if (nodeName.equals("essentialEnterpriseDependencies")) {
                                                ProjectExampleUtil.parseEssentialEnterpriseDependencies(project, child);
                                            } else if (nodeName.equals("stacksId")) {
                                                String stacksId = ProjectExampleUtil.getContent(child);
                                                if (stacksId != null) {
                                                    project.setStacksId(stacksId);
                                                }
                                            } else if (nodeName.equals("stacksType")) {
                                                String stacksType = ProjectExampleUtil.getContent(child);
                                                if (stacksType != null) {
                                                    project.setStacksType(stacksType);
                                                }
                                            } else if (nodeName.equals("headLine") && (headLine = ProjectExampleUtil.getContent(child)) != null) {
                                                project.setHeadLine(headLine);
                                            }
                                        }
                                        ++j;
                                    }
                                }
                                ++i;
                            }
                        }
                        ++k;
                    }
                }
                catch (Exception e) {
                    ProjectExamplesActivator.log(e);
                    service.shutdown();
                    break block74;
                }
            }
            catch (Throwable throwable) {
                service.shutdown();
                throw throwable;
            }
            service.shutdown();
        }
        list.add(other);
        ProjectExampleUtil.handleCategories(list, monitor);
        return list;
    }

    private static void parseEssentialEnterpriseDependencies(ProjectExample project, Element enterpriseDependenciesElement) {
        String tagsValue = enterpriseDependenciesElement.getTextContent();
        if (tagsValue != null) {
            StringTokenizer tokenizer = new StringTokenizer(tagsValue.trim(), ",");
            HashSet<String> gavs = new HashSet<String>();
            while (tokenizer.hasMoreTokens()) {
                String gav = tokenizer.nextToken().trim();
                if (gav.length() <= 0) continue;
                gavs.add(gav);
            }
            project.setEssentialEnterpriseDependencyGavs(gavs);
        }
    }

    public static Set<URL> getCategoryURLs() {
        if (categoryUrls == null) {
            categoryUrls = new HashSet<URL>();
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            IExtensionPoint extensionPoint = registry.getExtensionPoint(PROJECT_EXAMPLES_CATEGORIES_EXTENSION_ID);
            IExtension[] extensions = extensionPoint.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IExtension extension = extensions[i];
                IConfigurationElement[] configurationElements = extension.getConfigurationElements();
                String urlKey = null;
                String urlValue = null;
                int j = 0;
                while (j < configurationElements.length) {
                    IConfigurationElement configurationElement = configurationElements[j];
                    if (URL_EXT.equals(configurationElement.getName())) {
                        urlValue = configurationElement.getValue();
                    } else if (URL_KEY.equals(configurationElement.getName())) {
                        urlKey = configurationElement.getValue();
                    }
                    ++j;
                }
                String urlString = PropertiesHelper.getPropertiesProvider().getValue(urlKey, urlValue);
                URL url = ProjectExampleUtil.getURL(urlString);
                if (url != null) {
                    categoryUrls.add(url);
                }
                ++i;
            }
        }
        return categoryUrls;
    }

    private static void handleCategories(List<ProjectExampleCategory> list, IProgressMonitor monitor) {
        Set<URL> urls = ProjectExampleUtil.getCategoryURLs();
        for (URL url : urls) {
            Document doc;
            File file = ProjectExampleUtil.getProjectExamplesFile(url, "categories", ".xml", monitor);
            if (monitor.isCanceled()) {
                return;
            }
            if (file == null || !file.exists() || !file.isFile()) {
                ProjectExamplesActivator.log(NLS.bind((String)Messages.ProjectUtil_Invalid_URL, (Object)url.toString()));
                continue;
            }
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            try {
                DocumentBuilder db = dbf.newDocumentBuilder();
                doc = db.parse(file);
            }
            catch (Exception e1) {
                ProjectExamplesActivator.log(e1.getMessage());
                continue;
            }
            NodeList categoryNodes = doc.getElementsByTagName("category");
            int len = categoryNodes.getLength();
            int i = 0;
            while (i < len) {
                String name;
                Node node = categoryNodes.item(i);
                NamedNodeMap attributes = node.getAttributes();
                if (attributes != null && (name = ProjectExampleUtil.getAttributeValue(attributes, NAME)) != null) {
                    String description = ProjectExampleUtil.getAttributeValue(attributes, "description");
                    int priority = 0;
                    try {
                        priority = new Integer(ProjectExampleUtil.getAttributeValue(attributes, "priority"));
                    }
                    catch (Exception e) {
                        ProjectExamplesActivator.log(e);
                    }
                    if (description != null || priority > 0) {
                        for (ProjectExampleCategory projectExampleCategory : list) {
                            if (!name.equals(projectExampleCategory.getName())) continue;
                            projectExampleCategory.setDescription(description);
                            projectExampleCategory.setPriority(priority);
                        }
                    }
                }
                ++i;
            }
        }
    }

    private static String getAttributeValue(NamedNodeMap attributes, String name) {
        String value = null;
        Node node = attributes.getNamedItem(name);
        if (node != null) {
            value = node.getNodeValue();
        }
        return value;
    }

    private static void parseTags(ProjectExample project, Element tagElement) {
        String tagsValue = tagElement.getTextContent();
        if (tagsValue != null) {
            StringTokenizer tokenizer = new StringTokenizer(tagsValue.trim(), ",");
            HashSet<String> tags = new HashSet<String>();
            while (tokenizer.hasMoreTokens()) {
                String tag = tokenizer.nextToken().trim();
                if (tag.length() <= 0) continue;
                tags.add(tag);
            }
            project.setTags(tags);
        }
    }

    private static void parseFixes(ProjectExample project, Element node) {
        NodeList children = node.getChildNodes();
        int cLen = children.getLength();
        int i = 0;
        while (i < cLen) {
            Element child;
            String nodeName;
            Node cNode = children.item(i);
            if (cNode.getNodeType() == 1 && (nodeName = (child = (Element)cNode).getNodeName()).equals("fix")) {
                ProjectExampleUtil.parseFix(project, child);
            }
            ++i;
        }
    }

    private static void parseMavenArchetype(ProjectExample project, Element node) {
        NodeList children = node.getChildNodes();
        int cLen = children.getLength();
        ArchetypeModel archetypeModel = project.getArchetypeModel();
        int i = 0;
        while (i < cLen) {
            Node cNode = children.item(i);
            if (cNode.getNodeType() == 1) {
                Element child = (Element)cNode;
                String nodeName = child.getNodeName();
                if (nodeName.equals("archetypeGroupId")) {
                    archetypeModel.setArchetypeGroupId(ProjectExampleUtil.getContent(child));
                } else if (nodeName.equals("archetypeArtifactId")) {
                    archetypeModel.setArchetypeArtifactId(ProjectExampleUtil.getContent(child));
                } else if (nodeName.equals("archetypeVersion")) {
                    archetypeModel.setArchetypeVersion(ProjectExampleUtil.getContent(child));
                } else if (nodeName.equals("archetypeRepository")) {
                    archetypeModel.setArchetypeRepository(ProjectExampleUtil.getContent(child));
                } else if (nodeName.equals("groupId")) {
                    archetypeModel.setGroupId(ProjectExampleUtil.getContent(child));
                } else if (nodeName.equals("artifactId")) {
                    archetypeModel.setArtifactId(ProjectExampleUtil.getContent(child));
                } else if (nodeName.equals("version")) {
                    archetypeModel.setVersion(ProjectExampleUtil.getContent(child));
                } else if (nodeName.equals("javaPackage")) {
                    archetypeModel.setJavaPackage(ProjectExampleUtil.getContent(child));
                } else if (nodeName.equals("properties")) {
                    ProjectExampleUtil.parseProperties(project, child);
                }
            }
            ++i;
        }
    }

    private static void parseProperties(ProjectExample project, Element node) {
        NodeList children = node.getChildNodes();
        int cLen = children.getLength();
        int i = 0;
        while (i < cLen) {
            Element child;
            String nodeName;
            Node cNode = children.item(i);
            if (cNode.getNodeType() == 1 && (nodeName = (child = (Element)cNode).getNodeName()).equals("property")) {
                String key = child.getAttribute(NAME);
                if (key == null || key.trim().length() <= 0) {
                    ProjectExamplesActivator.log(Messages.ProjectUtil_Invalid_property);
                    return;
                }
                String value = child.getAttribute("value");
                if (value == null || value.trim().length() <= 0) {
                    ProjectExamplesActivator.log(Messages.ProjectUtil_Invalid_property);
                    return;
                }
                project.getArchetypeModel().addProperty(key, value);
            }
            ++i;
        }
    }

    private static void parseFix(ProjectExample project, Element node) {
        String type = node.getAttribute("type");
        if (type == null || type.trim().length() <= 0) {
            ProjectExamplesActivator.log(Messages.ProjectUtil_Invalid_fix);
            return;
        }
        ProjectFix fix = new ProjectFix();
        fix.setType(type);
        NodeList children = node.getChildNodes();
        int cLen = children.getLength();
        int i = 0;
        while (i < cLen) {
            Element child;
            String nodeName;
            Node cNode = children.item(i);
            if (cNode.getNodeType() == 1 && (nodeName = (child = (Element)cNode).getNodeName()).equals("property")) {
                String name = child.getAttribute(NAME);
                if (name == null || name.trim().length() <= 0) {
                    ProjectExamplesActivator.log(Messages.ProjectUtil_Invalid_property);
                    return;
                }
                String value = ProjectExampleUtil.getContent(child);
                fix.getProperties().put(name, value);
            }
            ++i;
        }
        project.getFixes().add(fix);
    }

    private static String getProjectExamplesXml() {
        String projectXML = System.getProperty("org.jboss.tools.project.examples.xml");
        if (projectXML != null && projectXML.length() > 0) {
            return projectXML;
        }
        return null;
    }

    private static String getContent(Element child) {
        String value = child.getTextContent();
        if (value == null) {
            value = "";
        }
        return value.trim();
    }

    public static File getProjectExamplesFile(URL url, String prefix, String suffix, IProgressMonitor monitor) {
        File file = null;
        if (PROTOCOL_FILE.equals(url.getProtocol()) || PROTOCOL_PLATFORM.equalsIgnoreCase(url.getProtocol())) {
            try {
                file = new File(new URI(url.toExternalForm()));
            }
            catch (Exception exception) {
                file = new File(url.getFile());
            }
            if (!file.exists()) {
                return null;
            }
        } else {
            long urlModified;
            block19: {
                boolean fileAlreadyExists;
                block18: {
                    long modified;
                    block17: {
                        block16: {
                            try {
                                if (OfflineUtil.isOfflineEnabled()) {
                                    return OfflineUtil.getOfflineFile(url);
                                }
                                if (!monitor.isCanceled()) break block16;
                                return null;
                            }
                            catch (FileNotFoundException e) {
                                ProjectExamplesActivator.log(e);
                                return null;
                            }
                        }
                        urlModified = -1L;
                        file = ProjectExampleUtil.getFile(url);
                        try {
                            urlModified = new URLTransportUtility().getLastModified(url);
                        }
                        catch (CoreException coreException) {
                            if (!file.exists()) break block17;
                            return file;
                        }
                    }
                    if (file.exists() && (modified = file.lastModified()) > 0L && (urlModified == 0L || urlModified == modified)) {
                        return file;
                    }
                    fileAlreadyExists = file.exists();
                    file.getParentFile().mkdirs();
                    if (!monitor.isCanceled()) break block18;
                    return null;
                }
                BufferedOutputStream destination = new BufferedOutputStream(new FileOutputStream(file));
                IStatus result = new URLTransportUtility().download(prefix, url.toExternalForm(), (OutputStream)destination, 2000, monitor);
                if (result.isOK()) break block19;
                ProjectExamplesActivator.getDefault().getLog().log(result);
                if (!fileAlreadyExists && file.exists()) {
                    file.delete();
                }
                return null;
            }
            if (file.exists()) {
                file.setLastModified(urlModified);
            }
        }
        return file;
    }

    private static File getFile(URL url) {
        IPath location = ProjectExamplesActivator.getDefault().getStateLocation();
        File root = location.toFile();
        String urlFile = url.getFile();
        File file = new File(root, urlFile);
        return file;
    }

    public static Document getDocument() throws ParserConfigurationException {
        DocumentBuilderFactory dfactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = dfactory.newDocumentBuilder();
        Document doc = docBuilder.newDocument();
        return doc;
    }

    public static String getAsXML(Set<IProjectExampleSite> sites) throws ParserConfigurationException, TransformerException, UnsupportedEncodingException {
        if (sites == null || sites.size() == 0) {
            return "";
        }
        Document doc = ProjectExampleUtil.getDocument();
        Element sitesElement = doc.createElement(SITES);
        doc.appendChild(sitesElement);
        for (IProjectExampleSite site : sites) {
            Element siteElement = doc.createElement(SITE);
            siteElement.setAttribute(NAME, site.getName());
            siteElement.setAttribute(URL, site.getUrl().toString());
            sitesElement.appendChild(siteElement);
        }
        ByteArrayOutputStream s = new ByteArrayOutputStream();
        TransformerFactory factory = TransformerFactory.newInstance();
        Transformer transformer = factory.newTransformer();
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("indent", "yes");
        DOMSource source = new DOMSource(doc);
        StreamResult outputTarget = new StreamResult(s);
        transformer.transform(source, outputTarget);
        return s.toString("UTF8");
    }

    public static Element parseDocument(String document) {
        Element root = null;
        InputStream stream = null;
        try {
            try {
                DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                parser.setErrorHandler(new DefaultHandler());
                stream = new ByteArrayInputStream(document.getBytes("UTF8"));
                root = parser.parse(stream).getDocumentElement();
            }
            catch (Exception e) {
                ProjectExamplesActivator.log(e);
                try {
                    if (stream != null) {
                        stream.close();
                    }
                }
                catch (IOException e2) {
                    ProjectExamplesActivator.log(e2);
                }
            }
        }
        finally {
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (IOException e) {
                ProjectExamplesActivator.log(e);
            }
        }
        return root;
    }

    public static HashSet<IProjectExampleSite> getInvalidSites() {
        return invalidSites;
    }

    public static List<ProjectExample> getProjectsByTags(Collection<ProjectExampleCategory> categories, String ... tags) {
        if (categories == null) {
            return null;
        }
        ArrayList<ProjectExample> selection = new ArrayList<ProjectExample>();
        for (ProjectExampleCategory c : categories) {
            for (ProjectExample p : c.getProjects()) {
                if (!p.hasTags(tags) || selection.contains(p)) continue;
                selection.add(p);
            }
        }
        return selection;
    }

    public static void setProjectExamplesFile(ProjectExample project, File file) {
        if (project != null) {
            project.setFile(file);
        }
    }

    private static class FetchProjectExampleDocumentTask
    implements Callable<Tuple<IProjectExampleSite, Document>> {
        Tuple<IProjectExampleSite, Document> tuple;

        public FetchProjectExampleDocumentTask(IProjectExampleSite site) {
            this.tuple = new Tuple(site);
        }

        @Override
        public Tuple<IProjectExampleSite, Document> call() throws Exception {
            URL url = ((IProjectExampleSite)this.tuple.key).getUrl();
            File file = ProjectExampleUtil.getProjectExamplesFile(url, "projectExamples", ".xml", (IProgressMonitor)new NullProgressMonitor());
            if (file == null || !file.exists() || !file.isFile()) {
                ProjectExamplesActivator.log(NLS.bind((String)Messages.ProjectUtil_Invalid_URL, (Object)url.toString()));
                return this.tuple;
            }
            try {
                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                DocumentBuilder db = dbf.newDocumentBuilder();
                Document doc = db.parse(file);
                this.tuple.value = doc;
            }
            catch (Exception e) {
                ProjectExamplesActivator.log(e);
            }
            return this.tuple;
        }
    }

    private static class Tuple<X, Y> {
        X key;
        Y value;

        public Tuple(X key) {
            this.key = key;
        }
    }
}

